/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.VEle;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.LValueI;

public class ArrayAccess
extends VEle
implements LValueI {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(EvaluatorI pv, Node node, Object value) throws ParseException {
        Node lhs = node.jjtGetChild(0);
        if (!(lhs instanceof ASTVarNode)) {
            throw new ParseException("ArrayAccess: lhs of operator must be a Variable");
        }
        Variable var = ((ASTVarNode)lhs).getVar();
        MatrixValueI varVal = (MatrixValueI)var.getValue();
        Object indicies = pv.eval(node.jjtGetChild(1));
        if (varVal instanceof MVector) {
            MVector vec;
            if (indicies instanceof Number) {
                ((MVector)varVal).setEle(((Number)indicies).intValue() - 1, value);
                return;
            }
            if (!(indicies instanceof MVector) || !(vec = (MVector)indicies).getDim().equals(Dimensions.ONE)) throw new ParseException("ArrayAccess: Bad second argument expecting a double " + indicies.toString());
            int d1 = ((Number)vec.getEle(0)).intValue();
            if (d1 < 1 || d1 > ((MVector)varVal).getNumEles()) {
                throw new ParseException("ArrayAccess: array index " + d1 + " out of range 1.." + varVal.getDim());
            }
            ((MVector)varVal).setEle(d1 - 1, value);
            return;
        }
        if (varVal instanceof Matrix) {
            if (!(indicies instanceof MVector)) throw new ParseException("ArrayAccess:Bad second argument, expecting [i,j] " + indicies.toString());
            MVector vec = (MVector)indicies;
            if (!vec.getDim().equals(Dimensions.TWO)) throw new ParseException("ArrayAccess: requires a vector matrix or tensor for first argument it has " + varVal.toString());
            int d1 = ((Number)vec.getEle(0)).intValue();
            int d2 = ((Number)vec.getEle(1)).intValue();
            if (d1 < 1 || d1 > ((Matrix)varVal).getNumRows() || d2 < 1 || d2 > ((Matrix)varVal).getNumCols()) {
                throw new ParseException("ArrayAccess: array indices " + d1 + ", " + d2 + " out of range 1.." + varVal.getDim());
            }
            ((Matrix)varVal).setEle(d1 - 1, d2 - 1, value);
            return;
        }
        if (!(indicies instanceof Tensor)) throw new ParseException("ArrayAccess: requires a vector matrix or tensor for first argument it has " + varVal.toString());
        throw new ParseException("ArrayAccess: Sorry don't know how to set an elements for a tensor");
    }
}

