/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import java.awt.Component;
import java.awt.Container;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import sc.fiji.i5d.plugin.Open_Image5D;

public class Main {
    public static void main(String ... args) {
        if (IJ.getInstance() == null) {
            new ImageJ();
        }
        Open_Image5D openImage5D = new Open_Image5D();
        openImage5D.run("");
        ImagePlus imp = IJ.getImage();
        MyListener listener = new MyListener(imp);
        Main.addScrollListener(imp, listener, listener);
    }

    public static void addScrollListener(ImagePlus img, AdjustmentListener al, MouseWheelListener ml) {
        for (Component c : img.getWindow().getComponents()) {
            if (c instanceof Scrollbar) {
                ((Scrollbar)c).addAdjustmentListener(al);
                continue;
            }
            if (!(c instanceof Container)) continue;
            for (Component c2 : ((Container)c).getComponents()) {
                if (!(c2 instanceof Scrollbar)) continue;
                ((Scrollbar)c2).addAdjustmentListener(al);
            }
        }
        img.getWindow().addMouseWheelListener(ml);
    }

    private static class MyListener
    implements AdjustmentListener,
    MouseWheelListener {
        private final ImagePlus imp;

        public MyListener(ImagePlus imp) {
            this.imp = imp;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.printPositionInfo();
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            this.printPositionInfo();
        }

        private void printPositionInfo() {
            int channel = this.imp.getChannel();
            int slice = this.imp.getSlice();
            int frame = this.imp.getFrame();
            IJ.log((String)("Position: c=" + channel + ", z=" + slice + ", t=" + frame));
        }
    }
}

