/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.ReflectionUtils;
import org.scijava.annotations.Index;
import org.scijava.annotations.IndexItem;

public class CompressionAdapter
implements JsonDeserializer<Compression>,
JsonSerializer<Compression> {
    private static CompressionAdapter instance = null;
    private final HashMap<String, Constructor<? extends Compression>> compressionConstructors = new HashMap();
    private final HashMap<String, HashMap<String, Class<?>>> compressionParameters = new HashMap();

    private static ArrayList<Field> getDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        for (clazz = clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields;
    }

    public static synchronized void update(boolean override) {
        if (override || instance == null) {
            CompressionAdapter newInstance = new CompressionAdapter();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Index annotationIndex = Index.load(Compression.CompressionType.class, (ClassLoader)classLoader);
            for (IndexItem item : annotationIndex) {
                try {
                    Class<?> clazz = Class.forName(item.className());
                    String type = clazz.getAnnotation(Compression.CompressionType.class).value();
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    HashMap parameters = new HashMap();
                    ArrayList<Field> fields = CompressionAdapter.getDeclaredFields(clazz);
                    for (Field field : fields) {
                        if (field.getAnnotation(Compression.CompressionParameter.class) == null) continue;
                        parameters.put(field.getName(), field.getType());
                    }
                    newInstance.compressionConstructors.put(type, constructor);
                    newInstance.compressionParameters.put(type, parameters);
                }
                catch (ClassCastException | ClassNotFoundException | NoSuchMethodException | UnsatisfiedLinkError e) {
                    System.err.println("Compression '" + item.className() + "' could not be registered");
                }
            }
            instance = newInstance;
        }
    }

    public static void update() {
        CompressionAdapter.update(false);
    }

    @Override
    public JsonElement serialize(Compression compression, Type typeOfSrc, JsonSerializationContext context) {
        String type = compression.getType();
        Class<?> clazz = compression.getClass();
        JsonObject json = new JsonObject();
        json.addProperty("type", type);
        HashMap<String, Class<?>> parameterTypes = this.compressionParameters.get(type);
        try {
            for (Map.Entry<String, Class<?>> parameterType : parameterTypes.entrySet()) {
                String name = parameterType.getKey();
                Field field = clazz.getDeclaredField(name);
                boolean isAccessible = field.isAccessible();
                field.setAccessible(true);
                Object value = field.get(compression);
                field.setAccessible(isAccessible);
                json.add(parameterType.getKey(), context.serialize(value));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace(System.err);
            return null;
        }
        return json;
    }

    @Override
    public Compression deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Compression compression;
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement jsonType = jsonObject.get("type");
        if (jsonType == null) {
            return null;
        }
        String type = jsonType.getAsString();
        Constructor<? extends Compression> constructor = this.compressionConstructors.get(type);
        try {
            compression = constructor.newInstance(new Object[0]);
            HashMap<String, Class<?>> parameterTypes = this.compressionParameters.get(type);
            for (Map.Entry<String, Class<?>> parameterType : parameterTypes.entrySet()) {
                String name = parameterType.getKey();
                if (!jsonObject.has(name)) continue;
                Object parameter = context.deserialize(jsonObject.get(name), parameterType.getValue());
                ReflectionUtils.setFieldValue(compression, name, parameter);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException e) {
            e.printStackTrace(System.err);
            return null;
        }
        return compression;
    }

    public static CompressionAdapter getJsonAdapter() {
        if (instance == null) {
            CompressionAdapter.update();
        }
        return instance;
    }
}

