/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import com.google.gson.GsonBuilder;
import java.nio.file.FileSystems;
import org.janelia.saalfeldlab.n5.FileSystemKeyValueAccess;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5KeyValueReader;

public class N5FSReader
extends N5KeyValueReader {
    public N5FSReader(String basePath, GsonBuilder gsonBuilder, boolean cacheMeta) throws N5Exception {
        super(new FileSystemKeyValueAccess(FileSystems.getDefault()), basePath, gsonBuilder, cacheMeta);
        if (!this.exists("/")) {
            throw new N5Exception.N5IOException("No container exists at " + basePath);
        }
    }

    public N5FSReader(String basePath, boolean cacheMeta) throws N5Exception {
        this(basePath, new GsonBuilder(), cacheMeta);
    }

    public N5FSReader(String basePath, GsonBuilder gsonBuilder) throws N5Exception {
        this(basePath, gsonBuilder, false);
    }

    public N5FSReader(String basePath) throws N5Exception {
        this(basePath, new GsonBuilder(), false);
    }
}

