/*
 * Decompiled with CFR 0.152.
 */
package de.biomedical_imaging.ij.steger;

import de.biomedical_imaging.ij.steger.LinesUtil;

public class Line {
    int num;
    float[] row;
    float[] col;
    float[] angle;
    float[] response;
    float[] width_l;
    float[] width_r;
    float[] asymmetry;
    float[] intensity;
    private LinesUtil.contour_class cont_class;
    static int idCounter = 0;
    private int id;
    private int frame;

    public Line() {
        this.assignID();
    }

    public Line(float[] x, float[] y) {
        this.assignID();
        this.col = x;
        this.row = y;
        this.num = x.length;
    }

    public LinesUtil.contour_class getContourClass() {
        return this.cont_class;
    }

    public void setContourClass(LinesUtil.contour_class cont_class) {
        this.cont_class = cont_class;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public int getFrame() {
        return this.frame;
    }

    public float[] getXCoordinates() {
        return this.col;
    }

    public float[] getYCoordinates() {
        return this.row;
    }

    public float[] getResponse() {
        return this.response;
    }

    public float[] getIntensity() {
        return this.intensity;
    }

    public float[] getAngle() {
        return this.angle;
    }

    public float[] getAsymmetry() {
        return this.asymmetry;
    }

    public float[] getLineWidthL() {
        return this.width_l;
    }

    public float[] getLineWidthR() {
        return this.width_r;
    }

    public int getNumber() {
        return this.num;
    }

    public int getID() {
        return this.id;
    }

    public LinesUtil.contour_class getLineClass() {
        return this.cont_class;
    }

    public int getStartOrdEndPosition(float x, float y) {
        double distEnd;
        double distStart = Math.sqrt(Math.pow(this.col[0] - x, 2.0) + Math.pow(this.row[0] - y, 2.0));
        return distStart < (distEnd = Math.sqrt(Math.pow(this.col[this.num - 1] - x, 2.0) + Math.pow(this.row[this.num - 1] - y, 2.0))) ? 0 : this.num - 1;
    }

    public double estimateLength() {
        double length = 0.0;
        for (int i = 1; i < this.num; ++i) {
            length += Math.sqrt(Math.pow(this.col[i] - this.col[i - 1], 2.0) + Math.pow(this.row[i] - this.row[i - 1], 2.0));
        }
        return length;
    }

    private synchronized void assignID() {
        this.id = idCounter++;
    }

    static void resetCounter() {
        idCounter = 0;
    }
}

