/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;

public class Interpolation {
    float[][] pw = new float[256][4];
    float[][] sw = new float[256][4];
    private Control control;

    public Interpolation(Control control) {
        this.control = control;
        this.initializeCubicPolynomialWeights();
        this.initializeCubicSplineWeights();
    }

    void initializeCubicPolynomialWeights() {
        for (int i = 0; i < this.pw.length; ++i) {
            float dx = (float)i / 256.0f;
            float dx2 = dx * dx;
            float dx3 = dx * dx2;
            this.pw[i][0] = (-dx3 + 2.0f * dx2 - dx) / 2.0f;
            this.pw[i][1] = (3.0f * dx3 - 5.0f * dx2 + 2.0f) / 2.0f;
            this.pw[i][2] = (-3.0f * dx3 + 4.0f * dx2 + dx) / 2.0f;
            this.pw[i][3] = (dx3 - dx2) / 2.0f;
        }
    }

    void initializeCubicSplineWeights() {
        for (int i = 0; i < this.pw.length; ++i) {
            float dx = (float)i / 256.0f;
            float dx2 = dx * dx;
            float dx_ = 1.0f - dx;
            float dx_2 = dx_ * dx_;
            this.sw[i][0] = dx_2 * dx_ / 6.0f;
            this.sw[i][1] = 0.6666667f - 0.5f * dx2 * (2.0f - dx);
            this.sw[i][2] = 0.6666667f - 0.5f * dx_2 * (1.0f + dx);
            this.sw[i][3] = dx2 * dx / 6.0f;
        }
    }

    int get(byte[][][] data3D, float z, float y, float x) {
        x = (float)((double)x + 0.5);
        y = (float)((double)y + 0.5);
        z = (float)((double)z + 0.5);
        int z0 = (int)z;
        float dz = z - (float)z0;
        int y0 = (int)y;
        float dy = y - (float)y0;
        int x0 = (int)x;
        float dx = x - (float)x0;
        if (this.control.interpolationMode == 3) {
            float[] wx = this.pw[(int)(dx * 256.0f)];
            float[] wy = this.pw[(int)(dy * 256.0f)];
            float[] wz = this.pw[(int)(dz * 256.0f)];
            float vz = 0.0f;
            for (int zi = 0; zi < 4; ++zi) {
                byte[][] vDataZ = data3D[z0 + zi];
                float vy = 0.0f;
                for (int yi = 0; yi < 4; ++yi) {
                    byte[] vDataZY = vDataZ[y0 + yi];
                    float vx = wx[0] * (float)(0xFF & vDataZY[x0]) + wx[1] * (float)(0xFF & vDataZY[x0 + 1]) + wx[2] * (float)(0xFF & vDataZY[x0 + 2]) + wx[3] * (float)(0xFF & vDataZY[x0 + 3]);
                    vy += wy[yi] * vx;
                }
                vz += wz[zi] * vy;
            }
            return (int)Math.min(255.0f, Math.max(0.0f, vz));
        }
        if (this.control.interpolationMode == 2) {
            float[] wx = this.sw[(int)(dx * 256.0f)];
            float[] wy = this.sw[(int)(dy * 256.0f)];
            float[] wz = this.sw[(int)(dz * 256.0f)];
            float vz = 0.0f;
            for (int zi = 0; zi < 4; ++zi) {
                float vy = 0.0f;
                byte[][] vDataZ = data3D[z0 + zi];
                for (int yi = 0; yi < 4; ++yi) {
                    byte[] vDataZY = vDataZ[y0 + yi];
                    float vx = wx[0] * (float)(0xFF & vDataZY[x0]) + wx[1] * (float)(0xFF & vDataZY[x0 + 1]) + wx[2] * (float)(0xFF & vDataZY[x0 + 2]) + wx[3] * (float)(0xFF & vDataZY[x0 + 3]);
                    vy += wy[yi] * vx;
                }
                vz += wz[zi] * vy;
            }
            return (int)vz;
        }
        if (this.control.interpolationMode == 1) {
            int x1 = ++x0 + 1;
            int y1 = ++y0 + 1;
            float dx_ = 1.0f - dx;
            byte[][] data3D_z0 = data3D[++z0];
            byte[][] data3D_z1 = data3D[z0 + 1];
            float ab = (float)(0xFF & data3D_z0[y0][x0]) * dx_ + dx * (float)(0xFF & data3D_z0[y0][x1]);
            float ef = (float)(0xFF & data3D_z1[y0][x0]) * dx_ + dx * (float)(0xFF & data3D_z1[y0][x1]);
            float cd = (float)(0xFF & data3D_z0[y1][x0]) * dx_ + dx * (float)(0xFF & data3D_z0[y1][x1]);
            float gh = (float)(0xFF & data3D_z1[y1][x0]) * dx_ + dx * (float)(0xFF & data3D_z1[y1][x1]);
            float dy_ = 1.0f - dy;
            ab = ab * dy_ + dy * cd;
            ef = ef * dy_ + dy * gh;
            return (int)(ab + dz * (ef - ab));
        }
        x = (float)((double)x + 1.5);
        y = (float)((double)y + 1.5);
        z = (float)((double)z + 1.5);
        return 0xFF & data3D[(int)z][(int)y][(int)x];
    }
}

