/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJShade;
import ij.IJ;

public class VJAlphaColor {
    public float alpha;
    public float r;
    public float g;
    public float b;
    private boolean grayscale;

    public VJAlphaColor() {
        this.alpha = 0.0f;
        this.r = 0.0f;
        this.g = 0.0f;
        this.b = 0.0f;
        this.grayscale = false;
    }

    public VJAlphaColor(double alpha, int grayvalue) {
        this.alpha = (float)alpha;
        this.r = grayvalue;
        this.grayscale = true;
    }

    public VJAlphaColor(int grayvalue) {
        this.alpha = 0.0f;
        this.r = grayvalue;
        this.grayscale = true;
    }

    public VJAlphaColor(double grayvalue) {
        this.alpha = 0.0f;
        this.r = (float)grayvalue;
        this.grayscale = true;
    }

    public VJAlphaColor(double alpha, int r, int g, int b) {
        this.alpha = (float)alpha;
        this.r = r;
        this.g = g;
        this.b = b;
        this.grayscale = false;
    }

    public VJAlphaColor(double alpha, double r, double g, double b) {
        this.alpha = (float)alpha;
        this.r = (float)(r * 255.0);
        this.g = (float)(g * 255.0);
        this.b = (float)(b * 255.0);
        this.grayscale = false;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int getRed() {
        return (int)((double)this.r + 0.5);
    }

    public int getGreen() {
        return (int)((double)this.g + 0.5);
    }

    public int getBlue() {
        return (int)((double)this.b + 0.5);
    }

    public int getValue() {
        return (int)((double)this.r + 0.5);
    }

    public boolean isGrayscale() {
        return this.grayscale;
    }

    public void compose(VJAlphaColor color, float contribution) {
        this.r += color.r * contribution;
        if (!this.grayscale) {
            this.g += color.g * contribution;
            this.b += color.b * contribution;
        }
    }

    public void blendComposeScalar(VJAlphaColor color, VJShade shade) {
        float composedAlpha = color.getAlpha() * (1.0f - this.alpha);
        this.alpha += composedAlpha;
        this.compose(color, shade, composedAlpha);
    }

    public void compose(VJAlphaColor color, VJShade shade, float contribution) {
        if (shade.singlechannel()) {
            contribution = shade.compute(contribution);
            this.r += color.r * contribution;
            if (!this.grayscale) {
                this.g += color.g * contribution;
                this.b += color.b * contribution;
            }
        } else {
            this.r += color.r * shade.get(0) * contribution;
            this.g += color.g * shade.get(1) * contribution;
            this.b += color.b * shade.get(2) * contribution;
        }
    }

    public boolean visible() {
        return this.alpha > 0.0f;
    }

    public boolean notOpaque() {
        return this.alpha != 1.0f;
    }

    public void setOpaque() {
        this.alpha = 1.0f;
    }

    public void copy(VJAlphaColor ac) {
        this.alpha = ac.alpha;
        this.r = ac.r;
        this.g = ac.g;
        this.b = ac.b;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public boolean almostOpaque() {
        return (double)this.alpha > 0.95;
    }

    public void attenuate(VJShade shade) {
        if (shade.singlechannel()) {
            if (this.grayscale) {
                this.r *= shade.get();
            } else {
                this.r *= shade.get();
                this.g *= shade.get();
                this.b *= shade.get();
            }
        }
    }

    public String toString() {
        if (this.grayscale) {
            return "" + IJ.d2s((double)this.alpha, (int)2) + ":" + IJ.d2s((double)this.r, (int)1);
        }
        return "" + IJ.d2s((double)this.alpha, (int)2) + ":" + IJ.d2s((double)this.r, (int)1) + "," + IJ.d2s((double)this.g, (int)1) + "," + IJ.d2s((double)this.b, (int)1);
    }
}

