/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJCell;
import VolumeJ.VJGradient;
import VolumeJ.VJInterpolator;
import VolumeJ.VJUserInterface;
import VolumeJ.VJValue;
import VolumeJ.VJVoxelLoc;
import volume.Volume;
import volume.VolumeFloat;
import volume.VolumeRGB;
import volume.VolumeShort;

public class VJNearestNeighbor
extends VJInterpolator {
    @Override
    public boolean isValid(VJVoxelLoc vl, Volume v) {
        return vl.ix >= 0 && vl.ix < v.getWidth() && vl.iy >= 0 && vl.iy < v.getHeight() && vl.iz >= 0 && vl.iz < v.getDepth();
    }

    @Override
    public boolean isValidGradient(VJVoxelLoc vl, Volume v) {
        return vl.ix - 1 >= 0 && vl.ix + 1 < v.getWidth() && vl.iy - 1 >= 0 && vl.iy + 1 < v.getHeight() && vl.iz - 1 >= 0 && vl.iz + 1 < v.getDepth();
    }

    @Override
    public boolean isValidGradient(VJCell c, Volume v) {
        return c.ix - 1 >= 0 && c.ix + 1 < v.getWidth() && c.iy - 1 >= 0 && c.iy + 1 < v.getHeight() && c.iz - 1 >= 0 && c.iz + 1 < v.getDepth();
    }

    @Override
    public VJValue value(VJValue voxel, Volume v, VJVoxelLoc vl) {
        if (v instanceof VolumeShort) {
            if (((VolumeShort)v).getIndexed()) {
                voxel.intvalue = VJNearestNeighbor.value(((VolumeShort)v).v, 255, vl);
                voxel.index = (((VolumeShort)v).v[vl.iz][vl.iy][vl.ix] & 0xFF00) >> 8;
            } else {
                voxel.intvalue = VJNearestNeighbor.value(((VolumeShort)v).v, vl);
            }
            voxel.floatvalue = voxel.intvalue;
        } else if (v instanceof VolumeFloat) {
            voxel.floatvalue = VJNearestNeighbor.value(((VolumeFloat)v).v, vl);
        } else if (v instanceof VolumeRGB) {
            voxel.floatvalue = VJNearestNeighbor.value(((VolumeRGB)v).b, v.getHeight(), v.getWidth(), vl);
        } else {
            VJUserInterface.error("unknown Volume type v");
            return null;
        }
        voxel.intvalue = (int)voxel.floatvalue;
        return voxel;
    }

    @Override
    public VJGradient gradient(Volume v, VJVoxelLoc vl) {
        if (v instanceof VolumeShort) {
            return VJNearestNeighbor.gradient(((VolumeShort)v).v, vl);
        }
        if (v instanceof VolumeFloat) {
            return VJNearestNeighbor.gradient(((VolumeFloat)v).v, vl);
        }
        if (v instanceof VolumeRGB) {
            return VJNearestNeighbor.gradient(((VolumeRGB)v).b, v.getHeight(), v.getWidth(), vl);
        }
        VJUserInterface.error("unknown Volume type v");
        return null;
    }

    protected static float value(float[][][][] v, VJVoxelLoc vl, int i) {
        return VJNearestNeighbor.value(v[i], vl);
    }

    protected static float value(float[][][] v, VJVoxelLoc vl) {
        return v[vl.getnnz()][vl.getnny()][vl.getnnx()];
    }

    protected static int value(short[][][] v, VJVoxelLoc vl) {
        return v[vl.getnnz()][vl.getnny()][vl.getnnx()];
    }

    protected static float value(byte[] v, int height, int width, VJVoxelLoc vl) {
        return v[vl.getnnz() * height * width + vl.getnny() * width + vl.getnnx()] & 0xFF;
    }

    private static int value(short[][][] v, int mask, VJVoxelLoc vl) {
        return v[vl.getnnz()][vl.getnny()][vl.getnnx()] & mask;
    }

    protected static float[] valueHS(float[] hs, Object[] sliceArray, int width, VJVoxelLoc vl) {
        int[] slice0 = (int[])sliceArray[vl.getnnz()];
        int vv = slice0[vl.getnny() * width + vl.getnnx()];
        float[] hsb = new float[3];
        VolumeRGB.intToHSB(hsb, vv);
        hs[0] = hsb[0];
        hs[1] = hsb[1];
        return hs;
    }

    protected static VJGradient gradient(short[][][] v, VJVoxelLoc vl) {
        double gx = (v[vl.getnnz()][vl.getnny()][vl.getnnx() - 1] & 0xFFFF) - (v[vl.getnnz()][vl.getnny()][vl.getnnx() + 1] & 0xFFFF);
        double gy = (v[vl.getnnz()][vl.getnny() - 1][vl.getnnx()] & 0xFFFF) - (v[vl.getnnz()][vl.getnny() + 1][vl.getnnx()] & 0xFFFF);
        double gz = (v[vl.getnnz() - 1][vl.getnny()][vl.getnnx()] & 0xFFFF) - (v[vl.getnnz() + 1][vl.getnny()][vl.getnnx()] & 0xFFFF);
        VJGradient g = new VJGradient(gx, gy, gz);
        return g;
    }

    protected static VJGradient gradient(float[][][] v, VJVoxelLoc vl) {
        double gx = v[vl.getnnz()][vl.getnny()][vl.getnnx() - 1] - v[vl.getnnz()][vl.getnny()][vl.getnnx() + 1];
        double gy = v[vl.getnnz()][vl.getnny() - 1][vl.getnnx()] - v[vl.getnnz()][vl.getnny() + 1][vl.getnnx()];
        double gz = v[vl.getnnz() - 1][vl.getnny()][vl.getnnx()] - v[vl.getnnz() + 1][vl.getnny()][vl.getnnx()];
        VJGradient g = new VJGradient(gx, gy, gz);
        return g;
    }

    protected static VJGradient gradient(byte[] v, int height, int width, VJVoxelLoc vl) {
        double gx = (v[vl.getnnz() * height * width + vl.getnny() * width + (vl.getnnx() - 1)] & 0xFF) - (v[vl.getnnz() * height * width + vl.getnny() * width + (vl.getnnx() + 1)] & 0xFF);
        double gy = (v[vl.getnnz() * height * width + (vl.getnny() - 1) * width + vl.getnnx()] & 0xFF) - (v[vl.getnnz() * height * width + (vl.getnny() + 1) * width + vl.getnnx()] & 0xFF);
        double gz = (v[(vl.getnnz() - 1) * height * width + vl.getnny() * width + vl.getnnx()] & 0xFF) - (v[(vl.getnnz() + 1) * height * width + vl.getnny() * width + vl.getnnx()] & 0xFF);
        VJGradient g = new VJGradient(gx, gy, gz);
        return g;
    }

    protected static float value(float[][][][] v, int dimension, VJVoxelLoc vl) {
        return v[vl.getnnz()][vl.getnny()][vl.getnnx()][dimension];
    }

    @Override
    public String toString() {
        return " nearest neighbor ";
    }
}

