/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.util.Optional;
import net.imagej.updater.UpdateSite;

public class URLChange {
    private final UpdateSite site;
    private final String newUrl;
    private final boolean recommended;
    private boolean approved = false;

    public static Optional<URLChange> create(UpdateSite site, String newUrl) {
        newUrl = UpdateSite.format(newUrl);
        if (site.getURL().equals(newUrl)) {
            return Optional.empty();
        }
        return Optional.of(new URLChange(site, newUrl));
    }

    private URLChange(UpdateSite site, String newUrl) {
        this.site = site;
        this.newUrl = newUrl;
        this.recommended = !site.shouldKeepURL() && !URLChange.isMirror(site);
        this.approved = this.recommended && !site.isActive();
    }

    public UpdateSite updateSite() {
        return this.site;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void applyIfApproved() {
        if (this.newUrl == null) {
            return;
        }
        if (this.approved) {
            this.site.setURL(this.newUrl);
            this.site.setKeepURL(false);
        }
    }

    public String toString() {
        return "new URL: " + this.newUrl + ",  approved: " + this.approved;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public String getNewURL() {
        return this.newUrl;
    }

    public boolean isRecommended() {
        return this.recommended;
    }

    private static boolean isMirror(UpdateSite site) {
        return site.getURL().startsWith("https://downloads.micron.ox.ac.uk");
    }
}

