/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.net.URL;
import javax.swing.ImageIcon;

public class Images {
    private Images() {
    }

    public static Image createImage(Class baseClass, String resourceName) {
        URL resource = baseClass.getResource(resourceName);
        if (resource == null) {
            throw new InternalError("Ressource \"" + resourceName + "\" not found for class " + baseClass);
        }
        Image image = Toolkit.getDefaultToolkit().createImage(resource);
        return image;
    }

    public static Image createImage(URL resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource must not be null");
        }
        Image image = Toolkit.getDefaultToolkit().createImage(resource);
        return image;
    }

    public static BufferedImage toBufferedImage(RenderedImage rImg) {
        BufferedImage image;
        if (rImg instanceof BufferedImage) {
            image = (BufferedImage)rImg;
        } else {
            Raster r = rImg.getData();
            WritableRaster wr = WritableRaster.createWritableRaster(r.getSampleModel(), null);
            rImg.copyData(wr);
            image = new BufferedImage(rImg.getColorModel(), wr, rImg.getColorModel().isAlphaPremultiplied(), null);
        }
        return image;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bimage = null;
        if (System.getProperty("java.version").startsWith("1.4.1_")) {
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        } else {
            boolean hasAlpha;
            try {
                hasAlpha = Images.hasAlpha(image);
            }
            catch (IllegalAccessError e) {
                hasAlpha = true;
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                int transparency = 1;
                if (hasAlpha) {
                    transparency = 3;
                }
                GraphicsDevice gs = ge.getDefaultScreenDevice();
                GraphicsConfiguration gc = gs.getDefaultConfiguration();
                bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (bimage == null) {
                int type = 1;
                if (hasAlpha) {
                    type = 2;
                }
                bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
            }
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage[] split(Image image, int count, boolean isHorizontal) {
        BufferedImage src = Images.toBufferedImage(image);
        if (count == 1) {
            return new BufferedImage[]{src};
        }
        BufferedImage[] parts = new BufferedImage[count];
        for (int i = 0; i < count; ++i) {
            parts[i] = isHorizontal ? src.getSubimage(src.getWidth() / count * i, 0, src.getWidth() / count, src.getHeight()) : src.getSubimage(0, src.getHeight() / count * i, src.getWidth(), src.getHeight() / count);
        }
        return parts;
    }

    public static BufferedImage getScaledInstance(Image image, int width, int height) {
        int h;
        int w;
        if (width < 0 && height < 0) {
            w = image.getWidth(null);
            h = image.getHeight(null);
        } else if (width < 0) {
            w = image.getWidth(null) * height / image.getHeight(null);
            h = height;
        } else if (height < 0) {
            w = width;
            h = image.getHeight(null) * width / image.getWidth(null);
        } else {
            w = width;
            h = height;
        }
        BufferedImage scaled = new BufferedImage(w, h, 2);
        Graphics2D g = scaled.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(image, 0, 0, w, h, null);
        g.dispose();
        return scaled;
    }
}

