/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Stack;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;
import org.jhotdraw.app.Disposable;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMOutput;

public class NanoXMLDOMOutput
implements DOMOutput,
Disposable {
    private String doctype;
    private HashMap<Object, String> objectids;
    private HashMap<String, Object> prototypes;
    @Nullable
    private XMLElement document;
    private XMLElement current;
    private DOMFactory factory;
    private Stack<XMLElement> stack;

    public NanoXMLDOMOutput(DOMFactory factory) {
        this.factory = factory;
        this.objectids = new HashMap();
        this.current = this.document = new XMLElement();
        this.stack = new Stack();
        this.stack.push(this.current);
    }

    public void save(OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF8");
        this.save(w);
        ((Writer)w).flush();
    }

    public void save(Writer out) throws IOException {
        if (this.doctype != null) {
            out.write("<!DOCTYPE ");
            out.write(this.doctype);
            out.write(">\n");
        }
        XMLWriter writer = new XMLWriter(out);
        writer.write((XMLElement)this.document.getChildren().get(0));
    }

    public void print(PrintWriter out) {
        XMLWriter writer = new XMLWriter(out);
        try {
            writer.write((XMLElement)this.document.getChildren().get(0), true);
        }
        catch (IOException e) {
            InternalError error = new InternalError();
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public void openElement(String tagName) {
        XMLElement newElement = new XMLElement();
        newElement.setName(tagName);
        this.current.addChild(newElement);
        this.stack.push(this.current);
        this.current = newElement;
    }

    @Override
    public void closeElement() {
        this.current = this.stack.pop();
    }

    @Override
    public void addComment(String comment) {
    }

    @Override
    public void addText(String text) {
        String old = this.current.getContent();
        if (old == null) {
            this.current.setContent(text);
        } else {
            this.current.setContent(old + text);
        }
    }

    @Override
    public void addAttribute(String name, String value) {
        if (value != null) {
            this.current.setAttribute(name, value);
        }
    }

    @Override
    public void addAttribute(String name, int value) {
        this.current.setAttribute(name, Integer.toString(value));
    }

    @Override
    public void addAttribute(String name, boolean value) {
        this.current.setAttribute(name, Boolean.valueOf(value).toString());
    }

    @Override
    public void addAttribute(String name, float value) {
        String str = Float.toString(value);
        if (str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        this.current.setAttribute(name, str);
    }

    @Override
    public void addAttribute(String name, double value) {
        String str = Double.toString(value);
        if (str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        this.current.setAttribute(name, str);
    }

    @Override
    public void writeObject(Object o) throws IOException {
        String tagName = this.factory.getName(o);
        if (tagName == null) {
            throw new IllegalArgumentException("no tag name for:" + o);
        }
        this.openElement(tagName);
        XMLElement element = this.current;
        if (this.objectids.containsKey(o)) {
            this.addAttribute("ref", this.objectids.get(o));
        } else {
            String id = Integer.toString(this.objectids.size(), 16);
            this.objectids.put(o, id);
            this.addAttribute("id", id);
            this.factory.write(this, o);
        }
        this.closeElement();
    }

    @Override
    public void addAttribute(String name, float value, float defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    @Override
    public void addAttribute(String name, int value, int defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    @Override
    public void addAttribute(String name, double value, double defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    @Override
    public void addAttribute(String name, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    @Override
    public void addAttribute(String name, String value, String defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            this.addAttribute(name, value);
        }
    }

    @Override
    public Object getPrototype() {
        if (this.prototypes == null) {
            this.prototypes = new HashMap();
        }
        if (!this.prototypes.containsKey(this.current.getName())) {
            this.prototypes.put(this.current.getName(), this.factory.create(this.current.getName()));
        }
        return this.prototypes.get(this.current.getName());
    }

    @Override
    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    @Override
    public void dispose() {
        if (this.document != null) {
            this.document.dispose();
            this.document = null;
        }
    }
}

