/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ij;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converters;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.type.numeric.integer.GenericLongType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.util.Util;

public interface N5IJConverters {
    public static final byte[][] PEARSON_HASH_LUT = new byte[][]{{-122, 127, -1, 24, 77, -7, 79, 109, 104, 112, -40, -15, -48, 21, 63, 97, 123, -55, -60, -20, -5, 18, 117, -110, -24, -59, 46, -121, 74, -8, -42, 110, 37, -100, -97, 22, -75, 94, 30, 19, -93, 115, 51, -31, 96, 7, -13, 6, 86, 91, -27, -25, 17, -71, 68, -108, -98, -125, 89, 16, 92, 27, 62, -23, 59, 3, -21, -73, -68, 41, 102, -115, -118, -16, -39, -61, -26, 118, 99, 31, -19, -92, 45, -2, 69, -116, -35, 121, -114, 93, -81, 124, 67, 88, -112, -52, -76, -88, 64, 76, -43, -124, 85, 5, -62, 28, 75, 36, 122, -17, -65, 107, 116, 38, -50, -107, -12, -28, -57, -128, 81, -79, -72, 2, -34, 80, 53, -120, 26, -89, 95, -94, 119, -69, -38, -109, 103, -22, 98, 48, -96, -66, 42, 87, 8, 126, -58, 14, 35, -53, -4, 113, -46, -111, 13, -86, -74, -99, -9, 34, -119, -78, -105, 111, -82, 10, 1, 11, -87, -29, -102, -51, 20, -95, 82, -113, 12, -70, 71, -11, 58, -123, 101, -85, -18, -49, 73, 125, 120, -91, -37, 78, 4, 90, 55, 83, 106, 49, -80, -127, -106, 32, -54, -33, 43, -77, 23, 47, 65, -84, -126, -67, 39, -101, -104, 84, 15, 25, -56, 54, -63, 72, 40, -64, 0, 52, -6, -10, -41, -36, -83, 100, 57, -30, 9, -103, 60, -3, 44, -14, 105, -47, 50, 33, -117, 108, 56, -32, -45, 114, 70, 29, -44, 66, 61, -90}, {93, -47, -44, 33, 54, 36, -104, 25, 2, 107, 50, 40, 73, -107, -51, 21, 8, 102, 46, 115, -77, -128, -58, -59, 29, 63, 84, 15, -54, -68, -95, 3, -1, -48, -115, 24, -62, 28, -75, 61, -26, 59, -113, 83, 0, 96, -42, 85, -112, 35, -96, -28, -31, 79, -11, 113, -33, -71, -22, 120, -12, -111, -10, -41, -67, -3, -60, -97, 89, 88, 37, -40, 101, -37, 51, -69, 100, 109, 11, 118, -64, -43, -80, -55, -120, -102, 55, -32, -98, 87, 39, -86, -14, 66, -119, 41, -73, -61, 65, -56, -88, -90, 58, 62, 48, -93, -30, -16, -36, 81, -7, 105, 111, -81, 38, 121, 14, 9, -8, -2, 60, 12, 68, 82, -29, -87, 1, 116, 123, -84, -9, -125, -82, 72, 47, 26, 98, 17, 18, 52, -52, -110, -108, -66, 6, 117, -103, -122, -50, 20, 114, 91, -106, 110, 45, 53, -17, 5, 43, -21, 23, -121, -63, -34, 92, 64, -53, -70, 75, 104, 127, -57, 42, -114, -124, -74, 122, 7, -117, -116, -5, -38, -15, -83, -127, 16, 57, -101, 126, -91, -72, 103, 112, -19, 44, -99, 78, 77, 70, -49, -39, -65, 32, 19, -92, 106, 124, 69, -89, -4, -13, 10, -118, 27, -94, -123, 95, 94, 97, -25, 67, -85, -6, 99, 30, -100, -45, 34, 125, 4, -79, 86, -126, -35, 31, 119, -76, -78, 108, 56, -105, 49, 80, 74, -24, -18, -20, -27, 22, -109, 13, 76, 71, 90, -46, -23}, {48, -117, -113, -115, 23, 15, -17, 12, -59, -18, -1, -30, 93, -28, 77, 19, 95, -3, 79, -40, 87, 3, -87, 109, -14, 40, 10, -7, -94, 85, -65, 42, 83, 112, 119, 73, 86, 51, -32, -22, -127, 67, 89, -103, 57, -60, -93, 84, -45, 98, -102, -43, 53, -61, -108, 55, 124, 70, 47, -48, 2, 20, -26, 26, 54, 59, -55, -95, 99, -41, 72, 30, 34, 24, 76, 82, 18, -128, -35, -11, -99, 32, -27, -114, 60, -70, -16, 127, 36, 58, -122, -118, 38, 74, -112, 116, -85, 88, -39, -97, -13, 16, -56, 81, -71, -62, 94, -64, -49, 45, -50, 105, -12, -76, -46, 50, -44, 56, 41, 68, 118, -83, 121, 92, 111, -6, -47, 22, -4, -74, -8, 35, -58, -98, 123, 27, 31, 33, -84, -110, -124, 11, 62, 49, -36, -101, 0, -89, -88, 7, -37, 25, 69, 115, -9, 106, 75, -125, 117, -90, 110, -68, -24, 46, -92, -100, -52, -75, 71, -86, -79, 6, 28, -119, 37, 122, 44, -69, 66, -53, 126, -121, 65, 90, -42, -57, -31, 29, -104, -72, -33, 101, 21, -67, 61, -120, -116, -80, 64, -123, 13, -10, -96, 4, -54, 125, 97, -91, -29, 108, 80, 14, -81, 103, 96, -105, 5, -15, -21, 43, -34, -77, -2, -23, 8, -111, -109, -107, 107, -106, 104, 52, -78, -66, -38, 100, 113, -126, -5, -73, -25, 102, -20, 114, -19, -63, 1, 17, 120, 78, -51, -82, 39, 91, 9, 63}, {109, -49, 49, -14, -85, -42, -56, 69, 13, -103, 44, 96, 39, -83, -53, 51, 20, 80, -92, 27, 55, -86, -46, 41, -24, 40, -101, -68, -16, -27, -105, -111, -10, -88, 60, 12, -5, 0, -97, 98, -2, -50, -110, 11, -67, -25, -23, -6, 35, -20, 1, 53, -13, -1, 127, 36, 31, -36, -37, 123, 3, -106, -108, 70, -76, 117, -29, 17, -109, -51, -62, 106, 8, -125, 82, 92, 77, -21, 97, 115, 52, 74, -69, -26, 59, 114, 90, 87, -52, 28, 62, -112, 76, 5, 99, -40, -9, 108, -115, 19, 112, -122, -8, -19, 18, -72, -123, 126, 4, -57, -59, -121, -113, -116, 91, 67, 38, 46, -71, -44, -43, 58, 50, 81, 47, 9, 72, -84, 119, 120, 75, -104, -89, 6, 86, -114, -73, 104, -30, 16, 61, -81, 110, 125, -33, 7, 56, -64, -80, 89, 65, 85, -77, 121, 116, 48, 95, -18, 21, 32, -74, -75, -58, 30, 57, 45, 24, 2, -54, -82, -94, -32, 26, -99, -95, -60, 94, -4, 63, -61, 25, 88, -31, -34, -22, 42, 122, 83, -17, 64, -78, 43, 37, -126, -39, 111, 105, 84, -119, 78, -117, -118, -12, -38, -124, -93, -7, -79, -15, -98, 124, -55, 23, 22, -102, 71, -127, 113, -100, 15, 14, -41, -70, -128, 68, -47, -35, -90, -11, -120, 34, 73, -63, -87, 101, 93, 100, 102, 79, 54, 33, 66, -65, 10, -45, -48, -28, 29, 107, -96, -91, -66, -3, 118, 103, -107}, {-111, -74, -119, 41, 98, 54, 107, 71, 16, 19, 58, 21, -76, -94, -82, -78, -110, -73, 1, 88, 103, 84, -25, -21, -48, 66, -126, 95, -120, 116, -7, -11, -104, 127, -117, -63, -14, -87, 59, 108, -38, 33, -4, -10, -54, 93, -112, 3, 27, 81, 69, -28, -27, -102, 18, -30, -77, 39, 65, 2, 74, -18, -44, 15, -52, -65, 101, -85, -43, -116, 44, 80, 86, 32, -6, 29, -103, -101, -16, 78, 87, 70, -1, 36, -51, -105, -59, -26, 37, -90, -109, 60, -5, -36, 124, -75, 30, -68, 34, -19, 51, -107, -20, -118, 55, -96, 115, 43, -40, 99, -88, -58, -70, -41, 96, 50, -123, -114, -49, 118, 77, 25, 111, 45, 42, -47, -22, -55, 61, 83, 9, -39, 75, -8, -100, 62, 102, 31, 94, -122, -86, -95, 109, 72, -37, 110, -45, -50, 125, 57, 120, 8, 11, -9, 97, 13, 14, 49, 119, 105, 35, 5, -113, -92, 68, -97, 63, 46, -15, 82, 56, -24, 122, 85, -106, -84, 48, 10, 26, 24, -29, 17, -91, -35, -33, -83, 22, 12, -72, 73, -127, -62, -13, 28, -46, -3, -121, -128, -125, 64, -61, 106, -56, -64, -67, -60, 112, -32, -42, 104, -99, -69, 89, 121, -12, -66, 92, 67, -53, -89, 4, -93, 47, 114, 76, -31, 91, 7, -17, 20, 53, 38, 0, -57, -124, 100, -81, -98, 90, 79, -79, 117, 123, 40, 126, 6, -23, 52, 113, -71, -2, -108, -34, 23, -80, -115}, {-118, -94, -21, 7, 111, 16, 92, 83, -79, 12, -65, -90, -72, 86, -25, 94, -13, 123, -68, -43, 81, 107, -128, 8, 126, -55, 82, 62, 114, 67, 56, -39, 68, -96, 3, -100, -87, 55, 18, -81, -114, -101, -51, 102, 41, 80, -1, 63, 21, -24, -2, 95, 13, -89, -19, 97, -107, 17, -33, 19, -66, -111, -9, -70, -48, 48, -112, 125, -59, 65, 29, 110, 59, -120, 57, 5, -52, -119, -125, -7, -36, 109, -11, -4, -105, 99, 14, -77, 106, 30, -121, -123, -26, 88, 116, 54, -98, 27, -20, 115, -95, -78, -91, -38, 72, 100, -35, -63, -15, 121, 28, -3, 122, 25, 58, 113, -117, -8, 47, -127, -16, 119, -42, 42, -10, 75, -85, 20, -50, -47, -17, -106, 2, 31, -124, 43, 52, 24, -102, -71, -99, 120, 79, 6, 15, 40, 105, 117, -60, 0, -14, -45, 112, -57, 33, -41, 101, 10, -97, 90, -56, 89, -27, -18, 46, 76, -22, -28, -54, 26, -76, -80, -34, -84, 66, 108, -62, 73, -104, -108, -83, -58, -92, -86, -109, 103, 1, 22, -40, -82, -115, -29, 98, -46, -53, -37, 11, 23, 34, 60, 35, -113, 53, -110, 74, -122, -44, -31, -74, -6, 38, 39, 84, -12, 85, 49, -88, 70, 69, -69, 91, 36, -32, 127, 45, -49, -126, 9, 87, 78, 124, -75, 118, -30, -61, 93, 71, 64, 77, -5, -73, 51, -23, -116, 32, -93, -103, 61, 96, 44, 50, 4, -64, -67, 37, 104}, {9, -53, -20, -68, 103, -88, 36, -9, 87, 16, -108, 82, -12, 86, 74, 14, 119, 105, 32, 22, -59, -119, -32, 11, 116, 46, -92, -69, 95, 40, 91, -49, -90, 60, -4, 44, -106, -109, -78, -118, 102, -24, 43, 10, -71, 30, -30, -42, 57, -70, -57, -27, 90, 96, 71, 66, -38, -126, -113, -31, 24, 124, -44, 114, 112, 26, 19, 62, 80, 53, -110, 118, -85, -111, -17, 2, 89, -83, 6, 3, -64, -87, 49, 122, -16, 107, -63, -82, 0, 108, -73, -19, 1, -36, -55, 120, -97, -123, -22, -35, -58, 97, -13, 123, -86, 35, 79, -37, -33, -117, 106, 4, -21, 69, -72, 64, 61, -25, -96, -101, -43, -103, 113, -112, -26, -105, -34, 29, 76, 18, 94, 99, -67, 23, -62, -91, -79, 45, 28, -124, -56, -76, -94, -10, -84, 55, 13, -66, 104, 51, -52, -99, -114, -128, -29, -23, -46, -8, 93, 37, -11, 56, -2, -65, 72, 127, 75, 110, 38, 42, 15, 54, 67, -40, 77, 121, 58, 31, 21, -39, 109, 101, -125, 84, 50, -100, -48, 8, -104, 73, -81, -80, 7, 17, 59, 88, -89, 39, -60, -51, 41, -75, 5, -50, -28, -14, 126, 34, -7, -5, -122, 100, 33, -18, 63, 68, 70, -107, 125, -98, -95, 85, 115, -121, -61, -102, -127, 27, -93, 81, 78, -6, -47, -45, -41, -115, 52, -116, 98, 117, -1, -77, 92, 47, 48, 20, -74, -54, 12, -15, -3, 83, 111, -120, 25, 65}, {-79, 32, 103, -60, 108, 119, 9, -111, 54, -70, 114, -91, -84, 28, 107, -97, 11, 24, 7, -76, -34, -64, 26, 71, 38, 106, 76, 50, 27, 41, -99, 78, -2, 85, 92, 83, -3, 120, -27, -74, 8, -5, -47, 82, 48, 18, 110, -125, -36, -16, -101, -42, -29, -112, 60, -67, -102, -50, 3, 31, 65, -18, -35, -25, -17, -13, 104, -106, 77, 111, -56, 121, -92, -128, 100, 63, -82, 49, 123, -121, -81, 29, -12, -116, -88, -28, 73, 102, -124, 43, -26, 2, 25, -77, 53, 46, -108, 87, 88, -122, -86, 115, 5, -103, 105, -59, -104, -63, 19, -7, 117, 84, 116, 113, 42, 40, 81, 79, 98, -30, -61, -100, 12, 122, 58, -20, -55, -43, -85, -19, 94, -117, -94, 52, -109, -57, -114, -39, 36, 14, 74, 45, 95, -68, 35, 44, 21, 47, -69, 20, -38, -115, 57, 67, 66, -9, -32, -33, -95, -10, -21, -53, 68, -1, 112, -87, -41, -24, 34, -113, -83, -123, 80, 72, -105, -31, 10, 59, 4, -98, -8, 51, 62, 56, -110, -37, -118, -62, 6, -107, -48, -89, -6, 70, -22, 109, -90, 125, 93, 55, 17, 89, 75, 101, 64, -72, -120, -51, 30, -45, 22, -44, -96, 37, -11, 97, 124, 90, 118, 69, -54, -71, 39, -15, -75, 16, 33, -52, 99, -65, 126, -119, -126, -40, 127, 13, -66, -46, 61, -127, 96, -4, -14, -80, 1, -93, 15, -58, 23, -73, 91, 0, 86, -23, -49, -78}};

    public static byte byteHash(long a, byte[] lut) {
        int b = lut[(int)a & 0xFF] & 0xFF;
        b = lut[(int)(a >> 8) & 0xFF ^ b] & 0xFF;
        b = lut[(int)(a >> 16) & 0xFF ^ b] & 0xFF;
        b = lut[(int)(a >> 24) & 0xFF ^ b] & 0xFF;
        b = lut[(int)(a >> 32) & 0xFF ^ b] & 0xFF;
        b = lut[(int)(a >> 40) & 0xFF ^ b] & 0xFF;
        b = lut[(int)(a >> 48) & 0xFF ^ b] & 0xFF;
        b = lut[(int)(a >> 56) & 0xFF ^ b] & 0xFF;
        return (byte)b;
    }

    public static byte byteHash(int a, byte[] lut) {
        int b = lut[a & 0xFF] & 0xFF;
        b = lut[a >> 8 & 0xFF ^ b] & 0xFF;
        b = lut[a >> 16 & 0xFF ^ b] & 0xFF;
        b = lut[a >> 24 & 0xFF ^ b] & 0xFF;
        return (byte)b;
    }

    public static byte byteHash(short a, byte[] lut) {
        int b = lut[a & 0xFF] & 0xFF;
        b = lut[a >> 8 & 0xFF ^ b] & 0xFF;
        return (byte)b;
    }

    public static byte byteHash(byte a, byte[] lut) {
        return lut[a & 0xFF];
    }

    public static short byteHash(long a) {
        return N5IJConverters.byteHash(a, PEARSON_HASH_LUT[0]);
    }

    public static short byteHash(int a) {
        return N5IJConverters.byteHash(a, PEARSON_HASH_LUT[0]);
    }

    public static short byteHash(short a) {
        return N5IJConverters.byteHash(a, PEARSON_HASH_LUT[0]);
    }

    public static short byteHash(byte a) {
        return N5IJConverters.byteHash(a, PEARSON_HASH_LUT[0]);
    }

    public static short shortHash(long a) {
        int b = N5IJConverters.byteHash(a, PEARSON_HASH_LUT[0]) & 0xFF;
        return (short)(b |= (N5IJConverters.byteHash(a, PEARSON_HASH_LUT[1]) & 0xFF) << 8);
    }

    public static short shortHash(int a) {
        int b = N5IJConverters.byteHash(a, PEARSON_HASH_LUT[0]) & 0xFF;
        return (short)(b |= (N5IJConverters.byteHash(a, PEARSON_HASH_LUT[1]) & 0xFF) << 8);
    }

    public static short shortHash(short a) {
        int b = N5IJConverters.byteHash(a, PEARSON_HASH_LUT[0]) & 0xFF;
        return (short)(b |= (N5IJConverters.byteHash(a, PEARSON_HASH_LUT[1]) & 0xFF) << 8);
    }

    public static short shortHash(byte a) {
        int b = N5IJConverters.byteHash(a, PEARSON_HASH_LUT[0]) & 0xFF;
        return (short)(b |= (N5IJConverters.byteHash(a, PEARSON_HASH_LUT[1]) & 0xFF) << 8);
    }

    public static int rgbHash(long a) {
        int b = N5IJConverters.byteHash(a, PEARSON_HASH_LUT[0]) & 0xFF;
        b |= (N5IJConverters.byteHash(a, PEARSON_HASH_LUT[1]) & 0xFF) << 8;
        return b |= (N5IJConverters.byteHash(a, PEARSON_HASH_LUT[2]) & 0xFF) << 16;
    }

    public static int rgbHash(int a) {
        int b = N5IJConverters.byteHash(a, PEARSON_HASH_LUT[0]) & 0xFF;
        b |= (N5IJConverters.byteHash(a, PEARSON_HASH_LUT[1]) & 0xFF) << 8;
        return b |= (N5IJConverters.byteHash(a, PEARSON_HASH_LUT[2]) & 0xFF) << 16;
    }

    public static int rgbHash(short a) {
        int b = N5IJConverters.byteHash(a, PEARSON_HASH_LUT[0]) & 0xFF;
        b |= (N5IJConverters.byteHash(a, PEARSON_HASH_LUT[1]) & 0xFF) << 8;
        return b |= (N5IJConverters.byteHash(a, PEARSON_HASH_LUT[2]) & 0xFF) << 16;
    }

    public static int rgbHash(byte a) {
        int b = N5IJConverters.byteHash(a, PEARSON_HASH_LUT[0]) & 0xFF;
        b |= (N5IJConverters.byteHash(a, PEARSON_HASH_LUT[1]) & 0xFF) << 8;
        return b |= (N5IJConverters.byteHash(a, PEARSON_HASH_LUT[2]) & 0xFF) << 16;
    }

    public static <T extends AbstractIntegerType<T>> RandomAccessibleInterval<UnsignedByteType> uint8Hash(RandomAccessibleInterval<T> src) {
        AbstractIntegerType t = (AbstractIntegerType)Util.getTypeFromInterval(src);
        if (t instanceof GenericLongType) {
            return Converters.convert(src, (a, b) -> b.set((int)N5IJConverters.byteHash(a.getLong())), (Type)new UnsignedByteType());
        }
        if (t instanceof GenericIntType) {
            return Converters.convert(src, (a, b) -> b.set((int)N5IJConverters.byteHash(a.getInt())), (Type)new UnsignedByteType());
        }
        if (t instanceof GenericShortType) {
            return Converters.convert(src, (a, b) -> b.set((int)N5IJConverters.byteHash(a.getShort())), (Type)new UnsignedByteType());
        }
        if (t instanceof GenericByteType) {
            return Converters.convert(src, (a, b) -> b.set((int)N5IJConverters.byteHash(a.getByte())), (Type)new UnsignedByteType());
        }
        return null;
    }
}

