/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.it.jacs.shared.ffmpeg;

import java.util.ArrayList;
import org.janelia.it.jacs.shared.ffmpeg.Frame;

public class ImageStack {
    private int _height;
    private int _width;
    private int _padding_right;
    private int _padding_bottom;
    private int _bytes_per_pixel;
    private double _spcx = 1.0;
    private double _spcy = 1.0;
    private double _spcz = 1.0;
    private String _unit = "";
    private String _info = "";
    private ArrayList<Frame> _image = new ArrayList();

    public int width() {
        return this._width;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public int height() {
        return this._height;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public int getPaddingRight() {
        return this._padding_right;
    }

    public void setPaddingRight(int _padding_right) {
        this._padding_right = _padding_right;
    }

    public int getPaddingBottom() {
        return this._padding_bottom;
    }

    public void setPaddingBottom(int _padding_bottom) {
        this._padding_bottom = _padding_bottom;
    }

    public int getNumFrames() {
        return this._image.size();
    }

    public int getNumComponents() {
        if (this._image.size() > 0) {
            return this._image.get((int)0).imageBytes.size();
        }
        return 0;
    }

    public int getBytesPerPixel() {
        return this._bytes_per_pixel;
    }

    public void setBytesPerPixel(int bytes_per_pixel) {
        this._bytes_per_pixel = bytes_per_pixel;
    }

    public double[] getSpacings() {
        double[] spcs = new double[]{this._spcx, this._spcy, this._spcz};
        return spcs;
    }

    public void setSpacings(double spcx, double spcy, double spcz) {
        this._spcx = spcx;
        this._spcy = spcy;
        this._spcz = spcz;
    }

    public String getUnit() {
        return this._unit;
    }

    public void setUnit(String unit) {
        this._unit = unit;
    }

    public byte[] image(int i, int component) {
        return this._image.get((int)i).imageBytes.get(component);
    }

    public byte[] interleave(int idx, int component, int count) {
        byte[] result = new byte[this._width * this._height * count];
        Frame f = this._image.get(idx);
        for (int j = 0; j < count; ++j) {
            if (component + j > f.imageBytes.size()) {
                for (int i = 0; i < this._width * this._height; ++i) {
                    result[count * i + j] = 0;
                }
                continue;
            }
            byte[] bytes = f.imageBytes.get(component + j);
            for (int i = 0; i < this._width * this._height; ++i) {
                result[count * i + j] = bytes[i];
            }
        }
        return result;
    }

    public Frame frame(int i) {
        return this._image.get(i);
    }

    public int linesize(int i) {
        return this._image.get((int)i).picture_rgb.linesize(0);
    }

    public void add(Frame f) {
        this._image.add(f);
    }

    public void merge(ImageStack other) {
        if (this._image.size() == 0) {
            this._width = other.width();
            this._height = other.height();
            this._bytes_per_pixel = other.getBytesPerPixel();
            for (int i = 0; i < other.getNumFrames(); ++i) {
                this.add(other.frame(i));
            }
        } else {
            for (int i = 0; i < other.getNumFrames(); ++i) {
                this.frame((int)i).imageBytes.add(other.frame((int)i).imageBytes.get(0));
            }
        }
    }

    public void release() throws Exception {
        for (int i = 0; i < this._image.size(); ++i) {
            this._image.get(i).release();
        }
        this._image.clear();
        this._height = 0;
        this._width = 0;
    }

    public void setInfo(String info) {
        this._info = info;
    }

    public String getInfo() {
        return this._info;
    }
}

