/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.filter.RollingBall;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.util.Tools;
import java.awt.AWTEvent;

public class BackgroundSubtracter
implements ExtendedPlugInFilter,
DialogListener {
    private static double staticRadius = 50.0;
    private static boolean staticLightBackground = Prefs.get("bs.background", true);
    private static boolean staticSeparateColors;
    private static boolean staticCreateBackground;
    private static boolean staticUseParaboloid;
    private static boolean staticDoPresmooth;
    private double radius = staticRadius;
    private boolean lightBackground = staticLightBackground;
    private boolean separateColors = staticSeparateColors;
    private boolean createBackground = staticCreateBackground;
    private boolean useParaboloid = staticUseParaboloid;
    private boolean doPresmooth = staticDoPresmooth;
    private boolean isRGB;
    private boolean previewing;
    private static final int MAXIMUM = 0;
    private static final int MEAN = 1;
    private static final int X_DIRECTION = 0;
    private static final int Y_DIRECTION = 1;
    private static final int DIAGONAL_1A = 2;
    private static final int DIAGONAL_1B = 3;
    private static final int DIAGONAL_2A = 4;
    private static final int DIAGONAL_2B = 5;
    private static final int DIRECTION_PASSES = 9;
    private int nPasses = 9;
    private int pass;
    private int flags = 16875551;
    private boolean calledAsPlugin;

    @Override
    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("final")) {
            imp.getProcessor().resetMinAndMax();
            return 4096;
        }
        return this.flags;
    }

    @Override
    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        this.isRGB = imp.getProcessor() instanceof ColorProcessor;
        this.calledAsPlugin = true;
        String options = Macro.getOptions();
        if (options != null) {
            Macro.setOptions(options.replaceAll("white", "light"));
            this.radius = 50.0;
            this.lightBackground = false;
            this.separateColors = false;
            this.createBackground = false;
            this.useParaboloid = false;
            this.doPresmooth = true;
        }
        GenericDialog gd = new GenericDialog(command);
        gd.addNumericField("Rolling ball radius:", this.radius, 1, 6, "pixels");
        gd.addCheckbox("Light background", this.lightBackground);
        if (this.isRGB) {
            gd.addCheckbox("Separate colors", this.separateColors);
        }
        gd.addCheckbox("Create background (don't subtract)", this.createBackground);
        gd.addCheckbox("Sliding paraboloid", this.useParaboloid);
        gd.addCheckbox("Disable smoothing", !this.doPresmooth);
        gd.addPreviewCheckbox(pfr);
        gd.addDialogListener(this);
        this.previewing = true;
        gd.addHelp("http://imagej.net/ij/docs/menus/process.html#background");
        gd.showDialog();
        this.previewing = false;
        if (gd.wasCanceled()) {
            return 4096;
        }
        IJ.register(this.getClass());
        if (imp.getProcessor() instanceof FloatProcessor && !this.createBackground) {
            this.flags |= 0x4000;
        }
        if (options == null) {
            staticRadius = this.radius;
            staticLightBackground = this.lightBackground;
            staticSeparateColors = this.separateColors;
            staticCreateBackground = this.createBackground;
            staticUseParaboloid = this.useParaboloid;
            staticDoPresmooth = this.doPresmooth;
            Prefs.set("bs.background", this.lightBackground);
        }
        return IJ.setupDialog(imp, this.flags);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        this.radius = gd.getNextNumber();
        if (this.radius <= 1.0E-4 || gd.invalidNumber()) {
            return false;
        }
        this.lightBackground = gd.getNextBoolean();
        if (this.isRGB) {
            this.separateColors = gd.getNextBoolean();
        }
        this.createBackground = gd.getNextBoolean();
        this.useParaboloid = gd.getNextBoolean();
        this.doPresmooth = !gd.getNextBoolean();
        return true;
    }

    @Override
    public void run(ImageProcessor ip) {
        if (this.isRGB && !this.separateColors) {
            this.rollingBallBrightnessBackground((ColorProcessor)ip, this.radius, this.createBackground, this.lightBackground, this.useParaboloid, this.doPresmooth, true);
        } else {
            this.rollingBallBackground(ip, this.radius, this.createBackground, this.lightBackground, this.useParaboloid, this.doPresmooth, true);
        }
        if (this.previewing && (ip instanceof FloatProcessor || ip instanceof ShortProcessor)) {
            ip.resetMinAndMax();
        }
    }

    public void subtractRGBBackround(ColorProcessor ip, int ballRadius) {
        this.rollingBallBrightnessBackground(ip, ballRadius, false, this.lightBackground, false, true, true);
    }

    public void subtractBackround(ImageProcessor ip, int ballRadius) {
        this.rollingBallBackground(ip, ballRadius, false, this.lightBackground, false, true, true);
    }

    public void rollingBallBrightnessBackground(ColorProcessor ip, double radius, boolean createBackground, boolean lightBackground, boolean useParaboloid, boolean doPresmooth, boolean correctCorners) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        byte[] H = new byte[width * height];
        byte[] S = new byte[width * height];
        byte[] B = new byte[width * height];
        ip.getHSB(H, S, B);
        ByteProcessor bp = new ByteProcessor(width, height, B, null);
        this.rollingBallBackground(bp, radius, createBackground, lightBackground, useParaboloid, doPresmooth, correctCorners);
        ip.setHSB(H, S, (byte[])bp.getPixels());
    }

    public void rollingBallBackground(ImageProcessor ip, double radius, boolean createBackground, boolean lightBackground, boolean useParaboloid, boolean doPresmooth, boolean correctCorners) {
        boolean invertedLut = ip.isInvertedLut();
        boolean invert = invertedLut && !lightBackground || !invertedLut && lightBackground;
        RollingBall ball = null;
        if (!useParaboloid) {
            ball = new RollingBall(radius);
        }
        FloatProcessor fp = null;
        for (int channelNumber = 0; channelNumber < ip.getNChannels(); ++channelNumber) {
            int p;
            fp = ip.toFloat(channelNumber, fp);
            if (ip instanceof FloatProcessor && !this.calledAsPlugin && !createBackground) {
                fp.snapshot();
            }
            if (useParaboloid) {
                this.slidingParaboloidFloatBackground(fp, (float)radius, invert, doPresmooth, correctCorners);
            } else {
                this.rollingBallFloatBackground(fp, (float)radius, invert, doPresmooth, ball);
            }
            if (createBackground) {
                ip.setPixels(channelNumber, fp);
                continue;
            }
            float[] bgPixels = (float[])fp.getPixels();
            if (ip instanceof FloatProcessor) {
                float[] snapshotPixels = (float[])fp.getSnapshotPixels();
                for (int p2 = 0; p2 < bgPixels.length; ++p2) {
                    bgPixels[p2] = snapshotPixels[p2] - bgPixels[p2];
                }
                continue;
            }
            if (ip instanceof ShortProcessor) {
                float offset = invert ? 65535.5f : 0.5f;
                short[] pixels = (short[])ip.getPixels();
                for (p = 0; p < bgPixels.length; ++p) {
                    float value = (float)(pixels[p] & 0xFFFF) - bgPixels[p] + offset;
                    if (value < 0.0f) {
                        value = 0.0f;
                    }
                    if (value > 65535.0f) {
                        value = 65535.0f;
                    }
                    pixels[p] = (short)value;
                }
                continue;
            }
            if (ip instanceof ByteProcessor) {
                float offset = invert ? 255.5f : 0.5f;
                byte[] pixels = (byte[])ip.getPixels();
                for (p = 0; p < bgPixels.length; ++p) {
                    float value = (float)(pixels[p] & 0xFF) - bgPixels[p] + offset;
                    if (value < 0.0f) {
                        value = 0.0f;
                    }
                    if (value > 255.0f) {
                        value = 255.0f;
                    }
                    pixels[p] = (byte)value;
                }
                continue;
            }
            if (!(ip instanceof ColorProcessor)) continue;
            float offset = invert ? 255.5f : 0.5f;
            int[] pixels = (int[])ip.getPixels();
            int shift = 16 - 8 * channelNumber;
            int byteMask = 255 << shift;
            int resetMask = 0xFFFFFFFF ^ 255 << shift;
            for (int p3 = 0; p3 < bgPixels.length; ++p3) {
                int pxl = pixels[p3];
                float value = (float)((pxl & byteMask) >> shift) - bgPixels[p3] + offset;
                if (value < 0.0f) {
                    value = 0.0f;
                }
                if (value > 255.0f) {
                    value = 255.0f;
                }
                pixels[p3] = pxl & resetMask | (int)value << shift;
            }
        }
    }

    void slidingParaboloidFloatBackground(FloatProcessor fp, float radius, boolean invert, boolean doPresmooth, boolean correctCorners) {
        block7: {
            float shiftBy;
            float[] pixels;
            block6: {
                pixels = (float[])fp.getPixels();
                int width = fp.getWidth();
                int height = fp.getHeight();
                float[] cache = new float[Math.max(width, height)];
                int[] nextPoint = new int[Math.max(width, height)];
                float coeff2 = 0.5f / radius;
                float coeff2diag = 1.0f / radius;
                this.showProgress(1.0E-6);
                if (invert) {
                    for (int i = 0; i < pixels.length; ++i) {
                        pixels[i] = -pixels[i];
                    }
                }
                shiftBy = 0.0f;
                if (doPresmooth) {
                    shiftBy = (float)this.filter3x3(fp, 0);
                    this.showProgress(0.5);
                    this.filter3x3(fp, 1);
                    ++this.pass;
                }
                if (correctCorners) {
                    this.correctCorners(fp, coeff2, cache, nextPoint);
                }
                this.filter1D(fp, 0, coeff2, cache, nextPoint);
                this.filter1D(fp, 1, coeff2, cache, nextPoint);
                this.filter1D(fp, 0, coeff2, cache, nextPoint);
                this.filter1D(fp, 2, coeff2diag, cache, nextPoint);
                this.filter1D(fp, 3, coeff2diag, cache, nextPoint);
                this.filter1D(fp, 4, coeff2diag, cache, nextPoint);
                this.filter1D(fp, 5, coeff2diag, cache, nextPoint);
                this.filter1D(fp, 2, coeff2diag, cache, nextPoint);
                this.filter1D(fp, 3, coeff2diag, cache, nextPoint);
                if (!invert) break block6;
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = -(pixels[i] - shiftBy);
                }
                break block7;
            }
            if (!doPresmooth) break block7;
            int i = 0;
            while (i < pixels.length) {
                int n = i++;
                pixels[n] = pixels[n] - shiftBy;
            }
        }
    }

    void filter1D(FloatProcessor fp, int direction, float coeff2, float[] cache, int[] nextPoint) {
        float[] pixels = (float[])fp.getPixels();
        int width = fp.getWidth();
        int height = fp.getHeight();
        int startLine = 0;
        int nLines = 0;
        int lineInc = 0;
        int pointInc = 0;
        int length = 0;
        switch (direction) {
            case 0: {
                nLines = height;
                lineInc = width;
                pointInc = 1;
                length = width;
                break;
            }
            case 1: {
                nLines = width;
                lineInc = 1;
                pointInc = width;
                length = height;
                break;
            }
            case 2: {
                nLines = width - 2;
                lineInc = 1;
                pointInc = width + 1;
                break;
            }
            case 3: {
                startLine = 1;
                nLines = height - 2;
                lineInc = width;
                pointInc = width + 1;
                break;
            }
            case 4: {
                startLine = 2;
                nLines = width;
                lineInc = 1;
                pointInc = width - 1;
                break;
            }
            case 5: {
                startLine = 0;
                nLines = height - 2;
                lineInc = width;
                pointInc = width - 1;
            }
        }
        for (int i = startLine; i < nLines; ++i) {
            if (i % 50 == 0) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.showProgress((double)i / (double)nLines);
            }
            int startPixel = i * lineInc;
            if (direction == 5) {
                startPixel += width - 1;
            }
            switch (direction) {
                case 2: {
                    length = Math.min(height, width - i);
                    break;
                }
                case 3: {
                    length = Math.min(width, height - i);
                    break;
                }
                case 4: {
                    length = Math.min(height, i + 1);
                    break;
                }
                case 5: {
                    length = Math.min(width, height - i);
                }
            }
            BackgroundSubtracter.lineSlideParabola(pixels, startPixel, pointInc, length, coeff2, cache, nextPoint, null);
        }
        ++this.pass;
    }

    static float[] lineSlideParabola(float[] pixels, int start, int inc, int length, float coeff2, float[] cache, int[] nextPoint, float[] correctedEdges) {
        float minValue = Float.MAX_VALUE;
        int lastpoint = 0;
        int firstCorner = length - 1;
        int lastCorner = 0;
        float vPrevious1 = 0.0f;
        float vPrevious2 = 0.0f;
        float curvatureTest = 1.999f * coeff2;
        int i = 0;
        int p = start;
        while (i < length) {
            float v;
            cache[i] = v = pixels[p];
            if (v < minValue) {
                minValue = v;
            }
            if (i >= 2 && vPrevious1 + vPrevious1 - vPrevious2 - v < curvatureTest) {
                nextPoint[lastpoint] = i - 1;
                lastpoint = i - 1;
            }
            vPrevious2 = vPrevious1;
            vPrevious1 = v;
            ++i;
            p += inc;
        }
        nextPoint[lastpoint] = length - 1;
        nextPoint[length - 1] = Integer.MAX_VALUE;
        int i1 = 0;
        while (i1 < length - 1) {
            float v1 = cache[i1];
            float minSlope = Float.MAX_VALUE;
            int i2 = 0;
            int searchTo = length;
            int recalculateLimitNow = 0;
            int j = nextPoint[i1];
            while (j < searchTo) {
                double b;
                int maxSearch;
                float v2 = cache[j];
                float slope = (v2 - v1) / (float)(j - i1) + coeff2 * (float)(j - i1);
                if (slope < minSlope) {
                    minSlope = slope;
                    i2 = j;
                    recalculateLimitNow = -3;
                }
                if (recalculateLimitNow == 0 && (maxSearch = i1 + (int)((b = (double)(0.5f * minSlope / coeff2)) + Math.sqrt(b * b + (double)((v1 - minValue) / coeff2)) + 1.0)) < searchTo && maxSearch > 0) {
                    searchTo = maxSearch;
                }
                j = nextPoint[j];
                ++recalculateLimitNow;
            }
            if (i1 == 0) {
                firstCorner = i2;
            }
            if (i2 == length - 1) {
                lastCorner = i1;
            }
            j = i1 + 1;
            int p2 = start + j * inc;
            while (j < i2) {
                pixels[p2] = v1 + (float)(j - i1) * (minSlope - (float)(j - i1) * coeff2);
                ++j;
                p2 += inc;
            }
            i1 = i2;
        }
        if (correctedEdges != null) {
            if (4 * firstCorner >= length) {
                firstCorner = 0;
            }
            if (4 * (length - 1 - lastCorner) >= length) {
                lastCorner = length - 1;
            }
            float v1 = cache[firstCorner];
            float v2 = cache[lastCorner];
            float slope = (v2 - v1) / (float)(lastCorner - firstCorner);
            float value0 = v1 - slope * (float)firstCorner;
            float coeff6 = 0.0f;
            float mid = 0.5f * (float)(lastCorner + firstCorner);
            for (int i2 = (length + 2) / 3; i2 <= 2 * length / 3; ++i2) {
                float dx = ((float)i2 - mid) * 2.0f / (float)(lastCorner - firstCorner);
                float poly6 = dx * dx * dx * dx * dx * dx - 1.0f;
                if (!(cache[i2] < value0 + slope * (float)i2 + coeff6 * poly6)) continue;
                coeff6 = -(value0 + slope * (float)i2 - cache[i2]) / poly6;
            }
            float dx = ((float)firstCorner - mid) * 2.0f / (float)(lastCorner - firstCorner);
            correctedEdges[0] = value0 + coeff6 * (dx * dx * dx * dx * dx * dx - 1.0f) + coeff2 * (float)firstCorner * (float)firstCorner;
            dx = ((float)lastCorner - mid) * 2.0f / (float)(lastCorner - firstCorner);
            correctedEdges[1] = value0 + (float)(length - 1) * slope + coeff6 * (dx * dx * dx * dx * dx * dx - 1.0f) + coeff2 * (float)(length - 1 - lastCorner) * (float)(length - 1 - lastCorner);
        }
        return correctedEdges;
    }

    void correctCorners(FloatProcessor fp, float coeff2, float[] cache, int[] nextPoint) {
        int width = fp.getWidth();
        int height = fp.getHeight();
        float[] pixels = (float[])fp.getPixels();
        float[] corners = new float[4];
        float[] correctedEdges = new float[2];
        correctedEdges = BackgroundSubtracter.lineSlideParabola(pixels, 0, 1, width, coeff2, cache, nextPoint, correctedEdges);
        corners[0] = correctedEdges[0];
        corners[1] = correctedEdges[1];
        correctedEdges = BackgroundSubtracter.lineSlideParabola(pixels, (height - 1) * width, 1, width, coeff2, cache, nextPoint, correctedEdges);
        corners[2] = correctedEdges[0];
        corners[3] = correctedEdges[1];
        correctedEdges = BackgroundSubtracter.lineSlideParabola(pixels, 0, width, height, coeff2, cache, nextPoint, correctedEdges);
        corners[0] = corners[0] + correctedEdges[0];
        corners[2] = corners[2] + correctedEdges[1];
        correctedEdges = BackgroundSubtracter.lineSlideParabola(pixels, width - 1, width, height, coeff2, cache, nextPoint, correctedEdges);
        corners[1] = corners[1] + correctedEdges[0];
        corners[3] = corners[3] + correctedEdges[1];
        int diagLength = Math.min(width, height);
        float coeff2diag = 2.0f * coeff2;
        correctedEdges = BackgroundSubtracter.lineSlideParabola(pixels, 0, 1 + width, diagLength, coeff2diag, cache, nextPoint, correctedEdges);
        corners[0] = corners[0] + correctedEdges[0];
        correctedEdges = BackgroundSubtracter.lineSlideParabola(pixels, width - 1, -1 + width, diagLength, coeff2diag, cache, nextPoint, correctedEdges);
        corners[1] = corners[1] + correctedEdges[0];
        correctedEdges = BackgroundSubtracter.lineSlideParabola(pixels, (height - 1) * width, 1 - width, diagLength, coeff2diag, cache, nextPoint, correctedEdges);
        corners[2] = corners[2] + correctedEdges[0];
        correctedEdges = BackgroundSubtracter.lineSlideParabola(pixels, width * height - 1, -1 - width, diagLength, coeff2diag, cache, nextPoint, correctedEdges);
        corners[3] = corners[3] + correctedEdges[0];
        if (pixels[0] > corners[0] / 3.0f) {
            pixels[0] = corners[0] / 3.0f;
        }
        if (pixels[width - 1] > corners[1] / 3.0f) {
            pixels[width - 1] = corners[1] / 3.0f;
        }
        if (pixels[(height - 1) * width] > corners[2] / 3.0f) {
            pixels[(height - 1) * width] = corners[2] / 3.0f;
        }
        if (pixels[width * height - 1] > corners[3] / 3.0f) {
            pixels[width * height - 1] = corners[3] / 3.0f;
        }
    }

    void rollingBallFloatBackground(FloatProcessor fp, float radius, boolean invert, boolean doPresmooth, RollingBall ball) {
        FloatProcessor smallImage;
        float[] pixels = (float[])fp.getPixels();
        boolean shrink = ball.shrinkFactor > 1;
        this.showProgress(0.0);
        if (invert) {
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = -pixels[i];
            }
        }
        if (doPresmooth) {
            this.filter3x3(fp, 1);
        }
        double[] minmax = Tools.getMinMax(pixels);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        FloatProcessor floatProcessor = smallImage = shrink ? this.shrinkImage(fp, ball.shrinkFactor) : fp;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        this.rollBall(ball, smallImage);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        this.showProgress(0.9);
        if (shrink) {
            this.enlargeImage(smallImage, fp, ball.shrinkFactor);
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (invert) {
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = -pixels[i];
            }
        }
        ++this.pass;
    }

    FloatProcessor shrinkImage(FloatProcessor ip, int shrinkFactor) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        float[] pixels = (float[])ip.getPixels();
        int sWidth = (width + shrinkFactor - 1) / shrinkFactor;
        int sHeight = (height + shrinkFactor - 1) / shrinkFactor;
        this.showProgress(0.1);
        FloatProcessor smallImage = new FloatProcessor(sWidth, sHeight);
        float[] sPixels = (float[])smallImage.getPixels();
        for (int ySmall = 0; ySmall < sHeight; ++ySmall) {
            for (int xSmall = 0; xSmall < sWidth; ++xSmall) {
                float min = Float.MAX_VALUE;
                int j = 0;
                for (int y = shrinkFactor * ySmall; j < shrinkFactor && y < height; ++j, ++y) {
                    int k = 0;
                    for (int x = shrinkFactor * xSmall; k < shrinkFactor && x < width; ++k, ++x) {
                        float thispixel = pixels[x + y * width];
                        if (!(thispixel < min)) continue;
                        min = thispixel;
                    }
                }
                sPixels[xSmall + ySmall * sWidth] = min;
            }
        }
        return smallImage;
    }

    void rollBall(RollingBall ball, FloatProcessor fp) {
        float[] pixels = (float[])fp.getPixels();
        int width = fp.getWidth();
        int height = fp.getHeight();
        float[] zBall = ball.data;
        int ballWidth = ball.width;
        int radius = ballWidth / 2;
        float[] cache = new float[width * ballWidth];
        Thread thread = Thread.currentThread();
        long lastTime = System.currentTimeMillis();
        for (int y = -radius; y < height + radius; ++y) {
            int y0;
            long time = System.currentTimeMillis();
            if (time - lastTime > 100L) {
                lastTime = time;
                if (thread.isInterrupted()) {
                    return;
                }
                this.showProgress(0.1 + 0.8 * (double)y / (double)(height + ballWidth));
            }
            int nextLineToWriteInCache = (y + radius) % ballWidth;
            int nextLineToRead = y + radius;
            if (nextLineToRead < height) {
                System.arraycopy(pixels, nextLineToRead * width, cache, nextLineToWriteInCache * width, width);
                int x = 0;
                int p = nextLineToRead * width;
                while (x < width) {
                    pixels[p] = -3.4028235E38f;
                    ++x;
                    ++p;
                }
            }
            if ((y0 = y - radius) < 0) {
                y0 = 0;
            }
            int yBall0 = y0 - y + radius;
            int yend = y + radius;
            if (yend >= height) {
                yend = height - 1;
            }
            for (int x = -radius; x < width + radius; ++x) {
                int bp;
                float z = Float.MAX_VALUE;
                int x0 = x - radius;
                if (x0 < 0) {
                    x0 = 0;
                }
                int xBall0 = x0 - x + radius;
                int xend = x + radius;
                if (xend >= width) {
                    xend = width - 1;
                }
                int yp = y0;
                int yBall = yBall0;
                while (yp <= yend) {
                    int cachePointer = yp % ballWidth * width + x0;
                    int xp = x0;
                    bp = xBall0 + yBall * ballWidth;
                    while (xp <= xend) {
                        float zReduced = cache[cachePointer] - zBall[bp];
                        if (z > zReduced) {
                            z = zReduced;
                        }
                        ++xp;
                        ++cachePointer;
                        ++bp;
                    }
                    ++yp;
                    ++yBall;
                }
                yp = y0;
                yBall = yBall0;
                while (yp <= yend) {
                    int xp = x0;
                    int p = xp + yp * width;
                    bp = xBall0 + yBall * ballWidth;
                    while (xp <= xend) {
                        float zMin = z + zBall[bp];
                        if (pixels[p] < zMin) {
                            pixels[p] = zMin;
                        }
                        ++xp;
                        ++p;
                        ++bp;
                    }
                    ++yp;
                    ++yBall;
                }
            }
        }
    }

    void enlargeImage(FloatProcessor smallImage, FloatProcessor fp, int shrinkFactor) {
        int width = fp.getWidth();
        int height = fp.getHeight();
        int smallWidth = smallImage.getWidth();
        int smallHeight = smallImage.getHeight();
        float[] pixels = (float[])fp.getPixels();
        float[] sPixels = (float[])smallImage.getPixels();
        int[] xSmallIndices = new int[width];
        float[] xWeights = new float[width];
        this.makeInterpolationArrays(xSmallIndices, xWeights, width, smallWidth, shrinkFactor);
        int[] ySmallIndices = new int[height];
        float[] yWeights = new float[height];
        this.makeInterpolationArrays(ySmallIndices, yWeights, height, smallHeight, shrinkFactor);
        float[] line0 = new float[width];
        float[] line1 = new float[width];
        for (int x = 0; x < width; ++x) {
            line1[x] = sPixels[xSmallIndices[x]] * xWeights[x] + sPixels[xSmallIndices[x] + 1] * (1.0f - xWeights[x]);
        }
        int ySmallLine0 = -1;
        for (int y = 0; y < height; ++y) {
            if (ySmallLine0 < ySmallIndices[y]) {
                float[] swap = line0;
                line0 = line1;
                line1 = swap;
                ++ySmallLine0;
                int sYPointer = (ySmallIndices[y] + 1) * smallWidth;
                for (int x = 0; x < width; ++x) {
                    line1[x] = sPixels[sYPointer + xSmallIndices[x]] * xWeights[x] + sPixels[sYPointer + xSmallIndices[x] + 1] * (1.0f - xWeights[x]);
                }
            }
            float weight = yWeights[y];
            int x = 0;
            int p = y * width;
            while (x < width) {
                pixels[p] = line0[x] * weight + line1[x] * (1.0f - weight);
                ++x;
                ++p;
            }
        }
    }

    void makeInterpolationArrays(int[] smallIndices, float[] weights, int length, int smallLength, int shrinkFactor) {
        for (int i = 0; i < length; ++i) {
            int smallIndex = (i - shrinkFactor / 2) / shrinkFactor;
            if (smallIndex >= smallLength - 1) {
                smallIndex = smallLength - 2;
            }
            smallIndices[i] = smallIndex;
            float distance = ((float)i + 0.5f) / (float)shrinkFactor - ((float)smallIndex + 0.5f);
            weights[i] = 1.0f - distance;
        }
    }

    double filter3x3(FloatProcessor fp, int type) {
        int width = fp.getWidth();
        int height = fp.getHeight();
        double shiftBy = 0.0;
        float[] pixels = (float[])fp.getPixels();
        for (int y = 0; y < height; ++y) {
            shiftBy += this.filter3(pixels, width, y * width, 1, type);
        }
        for (int x = 0; x < width; ++x) {
            shiftBy += this.filter3(pixels, height, x, width, type);
        }
        return shiftBy / (double)width / (double)height;
    }

    double filter3(float[] pixels, int length, int pixel0, int inc, int type) {
        float v3;
        double shiftBy = 0.0;
        float v2 = v3 = pixels[pixel0];
        int i = 0;
        int p = pixel0;
        while (i < length) {
            float v1 = v2;
            v2 = v3;
            if (i < length - 1) {
                v3 = pixels[p + inc];
            }
            if (type == 0) {
                float max;
                float f = max = v1 > v3 ? v1 : v3;
                if (v2 > max) {
                    max = v2;
                }
                shiftBy += (double)(max - v2);
                pixels[p] = max;
            } else {
                pixels[p] = (v1 + v2 + v3) * 0.33333334f;
            }
            ++i;
            p += inc;
        }
        return shiftBy;
    }

    @Override
    public void setNPasses(int nPasses) {
        if (this.isRGB && this.separateColors) {
            nPasses *= 3;
        }
        if (this.useParaboloid) {
            nPasses *= this.doPresmooth ? 11 : 9;
        }
        this.nPasses = nPasses;
        this.pass = 0;
    }

    private void showProgress(double percent) {
        if (this.nPasses <= 0) {
            return;
        }
        percent = (double)this.pass / (double)this.nPasses + percent / (double)this.nPasses;
        IJ.showProgress(percent);
    }

    static {
        staticDoPresmooth = true;
    }
}

