/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import ij.IJ;
import mpicbg.imglib.algorithm.fft.FourierConvolution;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.fusion.IsolatedPixelWeightener;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.registration.ViewDataBeads;

public class GaussContent
extends IsolatedPixelWeightener<GaussContent> {
    Image<FloatType> gaussContent;

    protected GaussContent(ViewDataBeads view, ContainerFactory entropyContainer) {
        super(view);
        try {
            SPIMConfiguration conf = view.getViewStructure().getSPIMConfiguration();
            double[] k1 = new double[view.getNumDimensions()];
            double[] k2 = new double[view.getNumDimensions()];
            for (int d = 0; d < view.getNumDimensions() - 1; ++d) {
                k1[d] = conf.fusionSigma1;
                k2[d] = conf.fusionSigma2;
            }
            k1[view.getNumDimensions() - 1] = (double)conf.fusionSigma1 / view.getZStretching();
            k2[view.getNumDimensions() - 1] = (double)conf.fusionSigma2 / view.getZStretching();
            Image kernel1 = FourierConvolution.createGaussianKernel((ContainerFactory)new ArrayContainerFactory(), (double[])k1);
            Image kernel2 = FourierConvolution.createGaussianKernel((ContainerFactory)new ArrayContainerFactory(), (double[])k2);
            FourierConvolution fftConv1 = new FourierConvolution(view.getImage(), kernel1);
            fftConv1.process();
            Image conv1 = fftConv1.getResult();
            fftConv1.close();
            fftConv1 = null;
            Cursor cursorImg = view.getImage().createCursor();
            Cursor cursorConv = conv1.createCursor();
            while (cursorImg.hasNext()) {
                cursorImg.fwd();
                cursorConv.fwd();
                float diff = ((FloatType)cursorImg.getType()).get() - ((FloatType)cursorConv.getType()).get();
                ((FloatType)cursorConv.getType()).set(diff * diff);
            }
            FourierConvolution fftConv2 = new FourierConvolution(conv1, kernel2);
            fftConv2.process();
            this.gaussContent = fftConv2.getResult();
            fftConv2.close();
            fftConv2 = null;
            kernel1.close();
            kernel2.close();
            conv1.close();
            ViewDataBeads.normalizeImage(this.gaussContent);
        }
        catch (OutOfMemoryError e) {
            IJ.log((String)("OutOfMemory: Cannot compute Gauss approximated Entropy for " + view.getName() + ": " + e));
            e.printStackTrace();
            this.gaussContent = null;
        }
    }

    @Override
    public LocalizableByDimCursor<FloatType> getResultIterator() {
        return this.gaussContent.createLocalizableByDimCursor();
    }

    @Override
    public LocalizableByDimCursor<FloatType> getResultIterator(OutOfBoundsStrategyFactory<FloatType> factory) {
        return this.gaussContent.createLocalizableByDimCursor(factory);
    }

    @Override
    public void close() {
        this.gaussContent.close();
    }

    @Override
    public Image<FloatType> getResultImage() {
        return this.gaussContent;
    }
}

