/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.bead;

import ij.IJ;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.math.LocalizablePoint;
import mpicbg.imglib.algorithm.peak.GaussianPeakFitterND;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianReal1;
import mpicbg.imglib.algorithm.scalespace.SubpixelLocalization;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor3D;
import mpicbg.imglib.cursor.special.HyperSphereIterator;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.integer.IntType;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import mpicbg.spim.registration.bead.Bead;
import mpicbg.spim.registration.bead.BeadStructure;
import mpicbg.spim.registration.bead.SegmentationBenchmark;
import mpicbg.spim.registration.bead.laplace.LaPlaceFunctions;
import mpicbg.spim.registration.threshold.ComponentProperties;
import mpicbg.spim.registration.threshold.ConnectedComponent;
import mpicbg.spim.segmentation.DOM;
import mpicbg.spim.segmentation.IntegralImage3d;
import mpicbg.spim.segmentation.InteractiveIntegral;
import mpicbg.spim.segmentation.SimplePeak;
import spim.vecmath.Point3d;
import spim.vecmath.Point3i;

public class BeadSegmentation {
    public static final boolean debugBeads = false;
    public ViewStructure viewStructure;
    public SegmentationBenchmark benchmark = new SegmentationBenchmark();
    public static boolean subpixel = true;

    public BeadSegmentation(ViewStructure viewStructure) {
        this.viewStructure = viewStructure;
    }

    public void segment() {
        this.segment(this.viewStructure.getSPIMConfiguration(), this.viewStructure.getViews());
    }

    public void segment(SPIMConfiguration conf, ArrayList<ViewDataBeads> views) {
        double threshold = conf.threshold;
        for (ViewDataBeads view : views) {
            if (conf.segmentation == SPIMConfiguration.SegmentationTypes.DOG) {
                if (this.viewStructure.getDebugLevel() <= 1) {
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting Scale Space Bead Extraction for " + view.getName());
                }
                view.setBeadStructure(this.extractBeadsLaPlaceImgLib(view, conf));
            } else if (conf.segmentation == SPIMConfiguration.SegmentationTypes.THRESHOLD) {
                if (this.viewStructure.getDebugLevel() <= 1) {
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting Threshold Bead Extraction for " + view.getName());
                }
                view.setBeadStructure(this.extractBeadsThresholdSegmentation(view, (float)threshold, conf.minSize, conf.maxSize, conf.minBlackBorder));
            } else if (conf.segmentation == SPIMConfiguration.SegmentationTypes.DOM) {
                if (this.viewStructure.getDebugLevel() <= 1) {
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting Integral Image based DOM Bead Extraction for " + view.getName());
                }
                view.setBeadStructure(this.extractBeadsDOM(view, conf));
            } else {
                throw new RuntimeException("Unknown segmentation: " + (Object)((Object)conf.segmentation));
            }
            if (this.viewStructure.getDebugLevel() <= 1) {
                IOFunctions.println("Found peaks (possible beads): " + view.getBeadStructure().getBeadList().size() + " in view " + view.getName());
            }
            if (conf.doFit == 3) {
                if (this.viewStructure.getDebugLevel() <= 1) {
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting Gaussian fit for all detections (this will take a little)");
                }
                double sxy = 2.0;
                double sz = 2.0;
                IJ.log((String)("Assumed sigma: [" + sxy + ", " + sxy + ", " + sz + "]"));
                double[] typicalSigma = new double[]{sxy, sxy, sz};
                BeadSegmentation.gaussFit(view.getImage(), view.getBeadStructure().getBeadList(), typicalSigma);
            }
            if (conf.doFit != 2 || !conf.doGaussKeepImagesOpen) {
                view.closeImage();
            }
            if (!conf.writeSegmentation) continue;
            IOFunctions.writeSegmentation(view, conf.registrationFiledirectory);
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            int p1 = (int)Math.round((double)this.benchmark.openFiles / ((double)this.benchmark.computation + (double)this.benchmark.openFiles) * 100.0);
            int p2 = (int)Math.round((double)this.benchmark.computation / ((double)this.benchmark.computation + (double)this.benchmark.openFiles) * 100.0);
            IJ.log((String)("Opening files took: " + this.benchmark.openFiles / 1000L + " sec (" + p1 + " %)"));
            IJ.log((String)("Computation took: " + this.benchmark.computation / 1000L + " sec (" + p2 + " %)"));
        }
    }

    public int reLocalizeTrueCorrespondences(boolean run) {
        int count = 0;
        for (ViewDataBeads view : this.viewStructure.getViews()) {
            ArrayList<Bead> beadList = new ArrayList<Bead>();
            for (Bead bead : view.getBeadStructure().getBeadList()) {
                if (bead.getRANSACCorrespondence().size() <= 0 || bead.relocalized) continue;
                beadList.add(bead);
            }
            count += beadList.size();
            if (!run) continue;
            if (this.viewStructure.getDebugLevel() <= 1) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Re-localizing " + beadList.size() + " beads using gaussian fit for view " + view.getName());
            }
            BeadSegmentation.gaussFit(view.getImage(false), beadList, new double[]{1.0, 1.0, 2.0});
            if (this.viewStructure.getSPIMConfiguration().doGaussKeepImagesOpen) continue;
            view.closeImage();
        }
        return count;
    }

    public static void gaussFit(final Image<FloatType> image, final ArrayList<Bead> beadList, final double[] typicalSigma) {
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final Vector threadChunks = SimpleMultiThreading.divideIntoChunks((long)beadList.size(), (int)threads.length);
        final int[] count = new int[threads.length];
        final double[][] sigmas = new double[threads.length][3];
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    int loopSize = (int)myChunk.getLoopSize();
                    int start = (int)myChunk.getStartPosition();
                    int end = start + loopSize;
                    GaussianPeakFitterND fitter = new GaussianPeakFitterND(image);
                    float[] tmp = new float[image.getNumDimensions()];
                    for (int j = start; j < end; ++j) {
                        Bead bead = (Bead)((Object)beadList.get(j));
                        for (int d = 0; d < tmp.length; ++d) {
                            tmp[d] = (float)bead.getL()[d];
                        }
                        double[] results = fitter.process((Localizable)new LocalizablePoint(tmp), typicalSigma);
                        double sx = 1.0 / Math.sqrt(results[4]);
                        double sy = 1.0 / Math.sqrt(results[5]);
                        double sz = 1.0 / Math.sqrt(results[6]);
                        double d = results[1];
                        bead.getW()[0] = d;
                        bead.getL()[0] = d;
                        double d2 = results[2];
                        bead.getW()[1] = d2;
                        bead.getL()[1] = d2;
                        double d3 = results[3];
                        bead.getW()[2] = d3;
                        bead.getL()[2] = d3;
                        bead.relocalized = true;
                        if (Double.isNaN(sx) || Double.isNaN(sy) || Double.isNaN(sz)) continue;
                        double[] dArray = sigmas[myNumber];
                        dArray[0] = dArray[0] + sx;
                        double[] dArray2 = sigmas[myNumber];
                        dArray2[1] = dArray2[1] + sy;
                        double[] dArray3 = sigmas[myNumber];
                        dArray3[2] = dArray3[2] + sz;
                        int n = myNumber;
                        count[n] = count[n] + 1;
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        for (int i = 1; i < sigmas.length; ++i) {
            double[] dArray = sigmas[0];
            dArray[0] = dArray[0] + sigmas[i][0];
            double[] dArray2 = sigmas[0];
            dArray2[1] = dArray2[1] + sigmas[i][1];
            double[] dArray3 = sigmas[0];
            dArray3[2] = dArray3[2] + sigmas[i][2];
            count[0] = count[0] + count[i];
        }
        IJ.log((String)("avg sigma: [" + sigmas[0][0] / (double)count[0] + " px, " + sigmas[0][1] / (double)count[0] + " px, " + sigmas[0][2] / (double)count[0] + " px]"));
    }

    public Image<FloatType> getFoundBeads(ViewDataBeads view) {
        ImageFactory factory = new ImageFactory((Type)new FloatType(), view.getViewStructure().getSPIMConfiguration().inputImageFactory);
        Image img = factory.createImage(view.getImageSize());
        LocalizableByDimCursor3D cursor = (LocalizableByDimCursor3D)img.createLocalizableByDimCursor();
        float[] tmp = new float[img.getNumDimensions()];
        for (Bead bead : view.getBeadStructure().getBeadList()) {
            for (int d = 0; d < tmp.length; ++d) {
                tmp[d] = (float)bead.getL()[d];
            }
            LocalizablePoint p = new LocalizablePoint(tmp);
            HyperSphereIterator it = new HyperSphereIterator(img, (Localizable)p, 1, (OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory());
            for (FloatType f : it) {
                f.setOne();
            }
        }
        cursor.close();
        return img;
    }

    protected BeadStructure extractBeadsDOM(ViewDataBeads view, SPIMConfiguration conf) {
        Image<FloatType> domImg;
        long time1 = System.currentTimeMillis();
        Image<FloatType> img = view.getImage(false);
        long time2 = System.currentTimeMillis();
        this.benchmark.openFiles += time2 - time1;
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Computing Integral Image");
        }
        Image<LongType> integralImg = IntegralImage3d.compute(img);
        FloatType min = new FloatType();
        FloatType max = new FloatType();
        if (ViewDataBeads.minmaxset == null) {
            DOM.computeMinMax(img, min, max);
        } else {
            min.set(ViewDataBeads.minmaxset[0]);
            max.set(ViewDataBeads.minmaxset[1]);
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): min intensity = " + min.get() + ", max intensity = " + max.get());
        }
        int r1 = view.getIntegralRadius1();
        int r2 = view.getIntegralRadius2();
        float t = view.getIntegralThreshold();
        int s1 = r1 * 2 + 1;
        int s2 = r2 * 2 + 1;
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Computing Difference-of-Mean");
        }
        if (conf.doFit == 3 || conf.doFit == 2 && conf.doGaussKeepImagesOpen) {
            domImg = img.createNewImage();
        } else {
            domImg = img;
            for (FloatType tt : img) {
                tt.setZero();
            }
        }
        DOM.computeDifferencOfMean3d(integralImg, domImg, s1, s1, s1, s2, s2, s2, min.get(), max.get());
        integralImg.close();
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Extracting peaks");
        }
        ArrayList<SimplePeak> peaks = InteractiveIntegral.findPeaks(domImg, t);
        BeadStructure beads = new BeadStructure();
        int id = 0;
        if (conf.doFit == 1) {
            if (this.viewStructure.getDebugLevel() <= 1) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Subpixel localization using quadratic n-dimensional fit");
            }
            ArrayList<DifferenceOfGaussianPeak> peakList = new ArrayList<DifferenceOfGaussianPeak>();
            for (SimplePeak peak : peaks) {
                if (!peak.isMax) continue;
                peakList.add(new DifferenceOfGaussianPeak(peak.location, (NumericType)new FloatType(peak.intensity), DifferenceOfGaussian.SpecialPoint.MAX));
            }
            SubpixelLocalization spl = new SubpixelLocalization(domImg, peakList);
            spl.setAllowMaximaTolerance(true);
            spl.setMaxNumMoves(10);
            if (!(spl.checkInput() && spl.process() || this.viewStructure.getDebugLevel() > 2)) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Warning! Failed to compute subpixel localization " + spl.getErrorMessage());
            }
            float[] pos = new float[img.getNumDimensions()];
            for (DifferenceOfGaussianPeak maximum : peakList) {
                if (!maximum.isMax()) continue;
                maximum.getSubPixelPosition(pos);
                Bead bead = new Bead(id, new Point3d(pos[0], pos[1], pos[2]), view);
                beads.addDetection(bead);
                ++id;
            }
        } else {
            for (SimplePeak peak : peaks) {
                if (!peak.isMax) continue;
                Bead bead = new Bead(id++, new Point3d(peak.location[0], peak.location[1], peak.location[2]), view);
                beads.addDetection(bead);
            }
        }
        if (domImg != img) {
            domImg.close();
        }
        this.benchmark.computation += System.currentTimeMillis() - time2;
        return beads;
    }

    protected BeadStructure extractBeadsLaPlaceImgLib(ViewDataBeads view, SPIMConfiguration conf) {
        float minInitialPeakValue;
        float minPeakValue;
        long time1 = System.currentTimeMillis();
        Image<FloatType> img = view.getImage();
        long time2 = System.currentTimeMillis();
        this.benchmark.openFiles += time2 - time1;
        float imageSigma = conf.imageSigma;
        float initialSigma = view.getInitialSigma();
        if (view.getMaxValueUnnormed() > 256.0f) {
            minPeakValue = view.getMinPeakValue();
            minInitialPeakValue = view.getMinInitialPeakValue();
        } else {
            minPeakValue = view.getMinPeakValue();
            minInitialPeakValue = view.getMinInitialPeakValue();
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): min intensity = " + view.getMinValue() + ", max intensity = " + view.getMaxValue());
            IOFunctions.println(view.getName() + " sigma: " + initialSigma + " minPeakValue: " + minPeakValue);
        }
        float k = LaPlaceFunctions.computeK(conf.stepsPerOctave);
        float K_MIN1_INV = LaPlaceFunctions.computeKWeight(k);
        int steps = conf.steps;
        float[] sigma = LaPlaceFunctions.computeSigma(steps, k, initialSigma);
        float[] sigmaDiff = LaPlaceFunctions.computeSigmaDiff(sigma, imageSigma);
        DifferenceOfGaussianReal1 dog = new DifferenceOfGaussianReal1(img, conf.strategyFactoryGauss, (double)sigmaDiff[0], (double)sigmaDiff[1], (double)minInitialPeakValue, (double)K_MIN1_INV);
        if (conf.doFit == 1) {
            dog.setKeepDoGImage(true);
        } else {
            dog.setKeepDoGImage(false);
        }
        if (!dog.checkInput() || !dog.process()) {
            if (this.viewStructure.getDebugLevel() <= 2) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Cannot compute difference of gaussian for " + dog.getErrorMessage());
            }
            return new BeadStructure();
        }
        ArrayList peakListOld = dog.getPeaks();
        ArrayList peakList = new ArrayList();
        for (int i = peakListOld.size() - 1; i >= 0; --i) {
            if (!((DifferenceOfGaussianPeak)peakListOld.get(i)).isMax()) continue;
            peakList.add(peakListOld.get(i));
        }
        if (conf.doFit == 1) {
            SubpixelLocalization spl = new SubpixelLocalization(dog.getDoGImage(), (List)dog.getPeaks());
            spl.setAllowMaximaTolerance(true);
            spl.setMaxNumMoves(10);
            if (!(spl.checkInput() && spl.process() || this.viewStructure.getDebugLevel() > 2)) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Warning! Failed to compute subpixel localization " + spl.getErrorMessage());
            }
            dog.getDoGImage().close();
        }
        BeadStructure beads = new BeadStructure();
        int id = 0;
        float[] pos = new float[img.getNumDimensions()];
        int peakTooLow = 0;
        int invalid = 0;
        int max = 0;
        for (DifferenceOfGaussianPeak maximum : dog.getPeaks()) {
            if (!maximum.isValid()) {
                ++invalid;
            }
            if (maximum.isMax()) {
                ++max;
            }
            if (!maximum.isMax()) continue;
            if (Math.abs(((FloatType)maximum.getValue()).get()) >= minPeakValue) {
                maximum.getSubPixelPosition(pos);
                Bead bead = new Bead(id, new Point3d(pos[0], pos[1], pos[2]), view);
                beads.addDetection(bead);
                ++id;
                continue;
            }
            ++peakTooLow;
        }
        if (this.viewStructure.getDebugLevel() <= 0) {
            IOFunctions.println("number of peaks: " + dog.getPeaks().size());
            IOFunctions.println("invalid: " + invalid);
            IOFunctions.println("max: " + max);
            IOFunctions.println("peak to low: " + peakTooLow);
        }
        this.benchmark.computation += System.currentTimeMillis() - time2;
        return beads;
    }

    protected BeadStructure extractBeadsThresholdSegmentation(ViewDataBeads view, float thresholdI, int minSize, int maxSize, int minBlackBorder) {
        float thresholdImg;
        SPIMConfiguration conf = view.getViewStructure().getSPIMConfiguration();
        Image<FloatType> img = view.getImage();
        ImageFactory imageFactory = new ImageFactory((Type)new IntType(), img.getContainerFactory());
        Image connectedComponents = imageFactory.createImage(img.getDimensions());
        int label = 0;
        img.getDisplay().setMinMax();
        int maxValue = (int)Util.round((double)img.getDisplay().getMax());
        if (!conf.useFixedThreshold) {
            if (this.viewStructure.getDebugLevel() <= 1) {
                IOFunctions.println(view.getName() + " maximum value: " + maxValue + " means a threshold of " + thresholdI * (float)maxValue);
            }
            thresholdImg = thresholdI * (float)maxValue;
        } else {
            if (this.viewStructure.getDebugLevel() <= 1) {
                IOFunctions.println(view.getName() + " maximum value: " + maxValue + " using a threshold of " + conf.fixedThreshold);
            }
            thresholdImg = conf.fixedThreshold;
        }
        ArrayList<Point3i> neighbors = this.getVisitedNeighbors();
        ConnectedComponent components = new ConnectedComponent();
        int w = connectedComponents.getDimension(0);
        int h = connectedComponents.getDimension(1);
        int d = connectedComponents.getDimension(2);
        LocalizableByDimCursor3D cursorImg = (LocalizableByDimCursor3D)img.createLocalizableByDimCursor();
        LocalizableByDimCursor3D cursorComponents = (LocalizableByDimCursor3D)connectedComponents.createLocalizableByDimCursor();
        for (int z = 0; z < d; ++z) {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    cursorImg.setPosition(x, y, z);
                    if (!(((FloatType)cursorImg.getType()).get() > thresholdImg)) continue;
                    ArrayList<Integer> neighboringLabels = this.getNeighboringLabels((Image<IntType>)connectedComponents, neighbors, x, y, z);
                    if (neighboringLabels == null || neighboringLabels.size() == 0) {
                        cursorComponents.setPosition(x, y, z);
                        ((IntType)cursorComponents.getType()).set(++label);
                        components.addLabel(label);
                        continue;
                    }
                    if (neighboringLabels.size() == 1) {
                        ((IntType)cursorComponents.getType()).set(neighboringLabels.get(0).intValue());
                        continue;
                    }
                    int label1 = neighboringLabels.get(0);
                    try {
                        for (int i = 1; i < neighboringLabels.size(); ++i) {
                            components.addEqualLabels(label1, neighboringLabels.get(i));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        IOFunctions.printErr("\n" + x + " " + y);
                        System.exit(0);
                    }
                    ((IntType)cursorComponents.getType()).set(label1);
                }
            }
        }
        cursorImg.close();
        cursorComponents.close();
        components.equalizeLabels((Image<IntType>)connectedComponents);
        if (this.viewStructure.getDebugLevel() <= 0) {
            IOFunctions.println("Found " + components.distinctLabels.size() + " distinct labels out of " + label + " labels");
        }
        ArrayList<ComponentProperties> segmentedBeads = components.getBeads((Image<IntType>)connectedComponents, img, minSize, maxSize, minBlackBorder, conf.useCenterOfMass, conf.circularityFactor);
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("Fount Beads: " + segmentedBeads.size());
        }
        BeadStructure beads = new BeadStructure();
        int id = 0;
        for (ComponentProperties comp : segmentedBeads) {
            Bead bead = new Bead(id, comp.center, view);
            beads.addDetection(bead);
            ++id;
        }
        return beads;
    }

    protected ArrayList<Integer> getNeighboringLabels(Image<IntType> connectedComponents, ArrayList<Point3i> neighbors, int x, int y, int z) {
        ArrayList<Integer> labels = new ArrayList<Integer>();
        Iterator<Point3i> iterateNeighbors = neighbors.iterator();
        int w = connectedComponents.getDimension(0);
        int h = connectedComponents.getDimension(1);
        int d = connectedComponents.getDimension(2);
        LocalizableByDimCursor3D cursor = (LocalizableByDimCursor3D)connectedComponents.createLocalizableByDimCursor();
        while (iterateNeighbors.hasNext()) {
            Point3i neighbor = iterateNeighbors.next();
            int xp = x + neighbor.x;
            int yp = y + neighbor.y;
            int zp = z + neighbor.z;
            if (xp < 0 || yp < 0 || zp < 0 || xp >= w || yp >= h || zp >= d) continue;
            cursor.setPosition(xp, yp, zp);
            int label = ((IntType)cursor.getType()).get();
            if (label == 0 || labels.contains(neighbor)) continue;
            labels.add(label);
        }
        cursor.close();
        return labels;
    }

    protected ArrayList<Point3i> getVisitedNeighbors() {
        ArrayList<Point3i> visitedNeighbors = new ArrayList<Point3i>();
        int z = -1;
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                visitedNeighbors.add(new Point3i(x, y, z));
            }
        }
        visitedNeighbors.add(new Point3i(-1, 0, 0));
        visitedNeighbors.add(new Point3i(-1, -1, 0));
        visitedNeighbors.add(new Point3i(0, -1, 0));
        visitedNeighbors.add(new Point3i(1, -1, 0));
        return visitedNeighbors;
    }
}

