/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.autonaming;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.autonaming.AutoNamingPanel;
import fiji.plugin.trackmate.action.autonaming.AutoNamingPerformer;
import fiji.plugin.trackmate.action.autonaming.AutoNamingRule;
import fiji.plugin.trackmate.action.autonaming.CopyTrackNameNamingRule;
import fiji.plugin.trackmate.action.autonaming.DefaultAutoNamingRule;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.util.EverythingDisablerAndReenabler;
import fiji.plugin.trackmate.util.Threads;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class AutoNamingController {
    private final TrackMate trackmate;
    private final AutoNamingPanel gui;
    private final Logger logger;

    public AutoNamingController(TrackMate trackmate, Logger logger) {
        this.trackmate = trackmate;
        this.logger = logger;
        ArrayList<AutoNamingRule> namingRules = new ArrayList<AutoNamingRule>(3);
        namingRules.add(new CopyTrackNameNamingRule());
        namingRules.add(new DefaultAutoNamingRule(".", "", false));
        namingRules.add(new DefaultAutoNamingRule(".", "", true));
        this.gui = new AutoNamingPanel(namingRules);
        this.gui.btnRun.addActionListener(e -> this.run((AutoNamingRule)this.gui.cmbboxRule.getSelectedItem()));
    }

    private void run(AutoNamingRule autoNaming) {
        EverythingDisablerAndReenabler disabler = new EverythingDisablerAndReenabler(this.gui, new Class[]{JLabel.class});
        disabler.disable();
        Threads.run("TrackMateAutoNamingThread", () -> {
            try {
                this.logger.log("Applying naming rule: " + autoNaming.toString() + ".\n");
                this.logger.setStatus("Spot auto-naming");
                AutoNamingPerformer.autoNameSpots(this.trackmate.getModel(), autoNaming);
                this.trackmate.getModel().notifyFeaturesComputed();
                this.logger.log("Spot auto-naming done.\n");
            }
            finally {
                disabler.reenable();
            }
        });
    }

    public void show() {
        if (this.gui.getParent() != null && this.gui.getParent().isVisible()) {
            return;
        }
        JFrame frame = new JFrame("Spot auto-naming");
        frame.setIconImage(Icons.TRACK_SCHEME_ICON.getImage());
        frame.setSize(500, 400);
        frame.getContentPane().add(this.gui);
        GuiUtils.positionWindow(frame, (Component)this.trackmate.getSettings().imp.getCanvas());
        frame.setVisible(true);
    }
}

