/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.features.spot.SpotAnalyzer;
import fiji.plugin.trackmate.features.spot.SpotAnalyzerFactoryBase;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.Threads;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.imagej.ImgPlus;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import org.scijava.Cancelable;

public class SpotFeatureCalculator
extends MultiThreadedBenchmarkAlgorithm
implements Cancelable {
    private static final String BASE_ERROR_MSG = "[SpotFeatureCalculator] ";
    private final Settings settings;
    private final Model model;
    private boolean isCanceled;
    private String cancelReason;
    private final boolean doLogIt;

    public SpotFeatureCalculator(Model model, Settings settings, boolean doLogIt) {
        this.settings = settings;
        this.model = model;
        this.doLogIt = doLogIt;
    }

    public boolean checkInput() {
        if (null == this.model) {
            this.errorMessage = "[SpotFeatureCalculator] Model object is null.";
            return false;
        }
        if (null == this.settings) {
            this.errorMessage = "[SpotFeatureCalculator] Settings object is null.";
            return false;
        }
        return true;
    }

    public boolean process() {
        for (SpotAnalyzerFactoryBase<?> factory : this.settings.getSpotAnalyzerFactories()) {
            List<String> features = factory.getFeatures();
            Map<String, String> featureNames = factory.getFeatureNames();
            Map<String, String> featureShortNames = factory.getFeatureShortNames();
            Map<String, Dimension> featureDimensions = factory.getFeatureDimensions();
            Map<String, Boolean> isIntFeature = factory.getIsIntFeature();
            this.model.getFeatureModel().declareSpotFeatures(features, featureNames, featureShortNames, featureDimensions, isIntFeature);
        }
        this.computeSpotFeaturesAgent(this.model.getSpots(), this.settings.getSpotAnalyzerFactories(), this.doLogIt);
        return true;
    }

    public void computeSpotFeatures(SpotCollection toCompute, boolean doLogIt) {
        List<SpotAnalyzerFactoryBase<?>> spotFeatureAnalyzers = this.settings.getSpotAnalyzerFactories();
        this.computeSpotFeaturesAgent(toCompute, spotFeatureAnalyzers, doLogIt);
    }

    private void computeSpotFeaturesAgent(final SpotCollection toCompute, final List<SpotAnalyzerFactoryBase<?>> analyzerFactories, boolean doLogIt) {
        Logger logger;
        this.isCanceled = false;
        this.cancelReason = null;
        long start = System.currentTimeMillis();
        Logger logger2 = logger = doLogIt ? this.model.getLogger() : Logger.VOID_LOGGER;
        if (this.settings.imp == null) {
            return;
        }
        final ImgPlus img = TMUtils.rawWraps(this.settings.imp);
        final ArrayList<Integer> frameSet = new ArrayList<Integer>(toCompute.keySet());
        int numFrames = frameSet.size();
        int nSimultaneousFrames = Math.max(1, Math.min(this.numThreads, numFrames));
        final int threadsPerFrame = Math.max(1, this.numThreads / nSimultaneousFrames);
        if (doLogIt) {
            logger.log("Computing spot features over " + (String)(nSimultaneousFrames > 1 ? nSimultaneousFrames + " frames" : "1 frame") + " simultaneously and allocating " + (String)(threadsPerFrame > 1 ? threadsPerFrame + " threads" : "1 thread") + " per frame.\n");
            logger.setStatus("Calculating " + toCompute.getNSpots(false) + " spots features...");
        }
        final AtomicInteger progress = new AtomicInteger(0);
        ArrayList<Object> tasks = new ArrayList<Object>(numFrames);
        final int workToDo = numFrames * analyzerFactories.size() * this.settings.imp.getNChannels();
        int iFrame = 0;
        while (iFrame < numFrames) {
            final int index = iFrame++;
            Callable<Void> frameTask = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int frame = (Integer)frameSet.get(index);
                    for (int channel = 0; channel < SpotFeatureCalculator.this.settings.imp.getNChannels(); ++channel) {
                        for (SpotAnalyzerFactoryBase factory : analyzerFactories) {
                            if (SpotFeatureCalculator.this.isCanceled()) {
                                return null;
                            }
                            SpotAnalyzer analyzer = factory.getAnalyzer(img, frame, channel);
                            if (analyzer instanceof MultiThreaded) {
                                ((MultiThreaded)analyzer).setNumThreads(threadsPerFrame);
                            }
                            analyzer.process(toCompute.iterable(frame, false));
                            logger.setProgress((double)progress.incrementAndGet() / (double)workToDo);
                        }
                    }
                    return null;
                }
            };
            tasks.add(frameTask);
        }
        ExecutorService executorService = Threads.newFixedThreadPool(nSimultaneousFrames);
        try {
            List futures = executorService.invokeAll(tasks);
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        executorService.shutdown();
        logger.setProgress(1.0);
        logger.setStatus("");
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void cancel(String reason) {
        this.isCanceled = true;
        this.cancelReason = reason;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }
}

