/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.features.AbstractFeatureGrapher;
import fiji.plugin.trackmate.features.ModelDataset;
import fiji.plugin.trackmate.features.TrackCollectionDataset;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import java.util.List;

public class TrackFeatureGrapher
extends AbstractFeatureGrapher {
    private final List<Integer> trackIDs;
    private final Model model;
    private final SelectionModel selectionModel;
    private final DisplaySettings ds;

    public TrackFeatureGrapher(List<Integer> trackIDs, String xFeature, List<String> yFeatures, Model model, SelectionModel selectionModel, DisplaySettings displaySettings) {
        super(xFeature, yFeatures, model.getFeatureModel().getTrackFeatureDimensions().get(xFeature), model.getFeatureModel().getTrackFeatureDimensions(), model.getFeatureModel().getTrackFeatureNames(), model.getSpaceUnits(), model.getTimeUnits());
        this.trackIDs = trackIDs;
        this.model = model;
        this.selectionModel = selectionModel;
        this.ds = displaySettings;
    }

    @Override
    protected ModelDataset buildMainDataSet(List<String> targetYFeatures) {
        return new TrackCollectionDataset(this.model, this.selectionModel, this.ds, this.xFeature, targetYFeatures, this.trackIDs);
    }
}

