/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.kdtree;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.tracker.NearestNeighborTrackerSettingsPanel;
import fiji.plugin.trackmate.tracking.SpotTracker;
import fiji.plugin.trackmate.tracking.SpotTrackerFactory;
import fiji.plugin.trackmate.tracking.kdtree.NearestNeighborTracker;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotTrackerFactory.class, priority=-100.0)
public class NearestNeighborTrackerFactory
implements SpotTrackerFactory {
    public static final String TRACKER_KEY = "NEAREST_NEIGHBOR_TRACKER";
    public static final String NAME = "Nearest-neighbor tracker";
    public static final String INFO_TEXT = "<html>This tracker is the most simple one, and is based on nearest neighbor search. <p>For each pair of consecutive frames <i>t1</i> and <i>t2</i>, it iterates through all spots in frame <i>t1</i>. For each source spot in <i>t1</i>, it searches for the nearest target spot in frame <i>t2</i>. If it is not already connected to a spot in frame <i>t1</i>, and is within the maximal linking distance, a link between the two spots is created. <br><p>The nearest neighbor search relies upon the KD-tree technique implemented in imglib2. This ensure a very efficient tracking and makes this tracker suitable for situation where a huge number of particles are to be tracked over a very large number of frames. However, because of the naiveness of its principles, it can result in pathological tracks. It can only do frame-to-frame linking; there cannot be any track merging or splitting, and gaps will not be closed. Also, the end results are non-deterministic, as the links created depend in the order in which the source spots are iterated. </html>";
    public static final String DOC_URL = "https://imagej.net/plugins/trackmate/trackers/nearest-neighbor-tracker";
    public static final ImageIcon ICON = new ImageIcon(Icons.class.getResource("images/NNtracker-icon-64px.png"));

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public String getKey() {
        return TRACKER_KEY;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getUrl() {
        return DOC_URL;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public SpotTracker create(SpotCollection spots, Map<String, Object> settings) {
        return new NearestNeighborTracker(spots, settings);
    }

    @Override
    public ConfigurationPanel getTrackerConfigurationPanel(Model model) {
        String spaceUnits = model.getSpaceUnits();
        return new NearestNeighborTrackerSettingsPanel(NAME, INFO_TEXT, spaceUnits);
    }

    @Override
    public String toString(Map<String, Object> sm) {
        return String.format("  Max distance: %.1f\n", (Double)sm.get("LINKING_MAX_DISTANCE"));
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("LINKING_MAX_DISTANCE", 15.0);
        return settings;
    }
}

