/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jfree.chart.JFreeChart;
import org.w3c.dom.DOMImplementation;

public class ChartExporter {
    public static void exportChartAsSVG(File svgFile, JFreeChart chart, int width, int height) throws UnsupportedEncodingException, IOException {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        org.w3c.dom.Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        chart.draw((Graphics2D)svgGenerator, (Rectangle2D)new Rectangle(width, height));
        try (FileOutputStream outputStream = new FileOutputStream(svgFile);
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");){
            svgGenerator.stream((Writer)out, true);
        }
    }

    public static void exportChartAsPDF(File pdfFile, JFreeChart chart, int width, int height) throws FileNotFoundException, DocumentException {
        com.itextpdf.text.Rectangle pageSize = new com.itextpdf.text.Rectangle(0.0f, 0.0f, (float)width, (float)height);
        Document document = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(pdfFile));
        document.open();
        PdfContentByte cb = writer.getDirectContent();
        PdfGraphics2D g2 = new PdfGraphics2D(cb, (float)width, (float)height);
        chart.draw((Graphics2D)g2, (Rectangle2D)new Rectangle(0, 0, width, height));
        g2.dispose();
        document.close();
    }
}

