/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.util.cli.CLIConfigurator;
import fiji.plugin.trackmate.util.cli.CLIUtils;
import fiji.plugin.trackmate.util.cli.Configurator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class CondaCLIConfigurator
extends CLIConfigurator {
    public static final String KEY_CONDA_ENV = "CONDA_ENV";
    protected final CondaEnvironmentCommand condaEnv;

    protected CondaCLIConfigurator() {
        ArrayList<String> envList = new ArrayList<String>();
        try {
            List<String> l = CLIUtils.getEnvList();
            envList.addAll(l);
        }
        catch (Exception e) {
            System.err.println("There was an error retrieving the list of conda environments.\nDid you configure Conda for TrackMate? (Edit >  Options > Configure TrackMate Conda path...)");
            e.printStackTrace();
        }
        this.condaEnv = new CondaEnvironmentCommand();
        envList.forEach(this.condaEnv::addEnvironment);
        this.condaEnv.key(KEY_CONDA_ENV);
        this.condaEnv.set(0);
        this.setCommandTranslator(this.condaEnv, s -> {
            ArrayList<String> cmd = new ArrayList<String>();
            String condaPath = CLIUtils.getCondaPath();
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("win")) {
                cmd.addAll(Arrays.asList("cmd.exe", "/c"));
            }
            cmd.add(condaPath);
            cmd.add("run");
            cmd.add("-n");
            String envname = (String)s;
            cmd.add(envname);
            String executableCommand = this.getCommand();
            String[] split = executableCommand.split(" ");
            cmd.addAll(Arrays.asList(split));
            return cmd;
        });
    }

    public CondaEnvironmentCommand getCommandArg() {
        return this.condaEnv;
    }

    protected abstract String getCommand();

    public String getVersion() {
        return this.getVersion((String)this.getCommandArg().getValue());
    }

    public String getVersion(String moduleName) {
        return CLIUtils.getModuleVersion((String)this.condaEnv.getValue(), moduleName);
    }

    public static class CondaEnvironmentCommand
    extends Configurator.AbstractStringArgument<CondaEnvironmentCommand> {
        private final List<String> envs = new ArrayList<String>();

        protected CondaEnvironmentCommand() {
            this.name("Conda environment");
            this.help("The conda environment in which the tool is configured.");
            this.key(CondaCLIConfigurator.KEY_CONDA_ENV);
            this.defaultValue("base");
            this.required(true);
        }

        protected CondaEnvironmentCommand addEnvironment(String env) {
            if (!this.envs.contains(env)) {
                this.envs.add(env);
            }
            return this;
        }

        @Override
        public void set(String env) {
            if (this.envs.isEmpty()) {
                System.err.println("The list of conda environments is empty.");
                return;
            }
            int sel = this.envs.indexOf(env);
            if (sel < 0) {
                super.set(this.envs.get(0));
                return;
            }
            super.set(env);
        }

        @Override
        public void set(int selected) {
            if (this.envs.isEmpty()) {
                System.err.println("The list of conda environments is empty.");
                return;
            }
            if (selected < 0 || selected >= this.envs.size()) {
                this.set(this.envs.get(0));
            } else {
                this.set(this.envs.get(selected));
            }
        }

        public List<String> getEnvironments() {
            return this.envs;
        }

        @Override
        public void accept(Configurator.ArgumentVisitor visitor) {
            visitor.visit(this);
        }
    }
}

