/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.cellCounter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ListIterator;
import java.util.Vector;
import sc.fiji.cellCounter.CellCntrMarker;
import sc.fiji.cellCounter.CellCntrMarkerVector;
import sc.fiji.cellCounter.CellCounter;

public class CellCntrImageCanvas
extends ImageCanvas {
    private Vector<CellCntrMarkerVector> typeVector;
    private CellCntrMarkerVector currentMarkerVector;
    private final CellCounter cc;
    private final ImagePlus img;
    private boolean delmode = false;
    private boolean showNumbers = true;
    private boolean showAll = false;
    private final Font font = new Font("SansSerif", 0, 10);
    private Rectangle srcRect = new Rectangle(0, 0, 0, 0);

    public CellCntrImageCanvas(ImagePlus img, Vector<CellCntrMarkerVector> typeVector, CellCounter cc, Vector<Roi> displayList) {
        super(img);
        this.img = img;
        this.typeVector = typeVector;
        this.cc = cc;
        if (displayList != null) {
            this.setDisplayList(displayList);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (IJ.spaceBarDown() || Toolbar.getToolId() == 11 || Toolbar.getToolId() == 12) {
            super.mousePressed(e);
            return;
        }
        if (this.currentMarkerVector == null) {
            IJ.error((String)"Select a counter type first!");
            return;
        }
        int x = super.offScreenX(e.getX());
        int y = super.offScreenY(e.getY());
        if (!this.delmode) {
            CellCntrMarker m = new CellCntrMarker(x, y, this.img.getCurrentSlice());
            this.currentMarkerVector.addMarker(m);
        } else {
            CellCntrMarker m = this.currentMarkerVector.getMarkerFromPosition(new Point(x, y), this.img.getCurrentSlice());
            this.currentMarkerVector.remove(m);
        }
        this.repaint();
        this.cc.populateTxtFields();
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }

    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
    }

    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        if (!IJ.spaceBarDown() | Toolbar.getToolId() != 11 | Toolbar.getToolId() != 12) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
    }

    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.srcRect = this.getSrcRect();
        double xM = 0.0;
        double yM = 0.0;
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f));
        g2.setFont(this.font);
        ListIterator<CellCntrMarkerVector> it = this.typeVector.listIterator();
        while (it.hasNext()) {
            CellCntrMarkerVector mv = it.next();
            int typeID = mv.getType();
            g2.setColor(mv.getColor());
            ListIterator mit = mv.listIterator();
            while (mit.hasNext()) {
                boolean sameSlice;
                CellCntrMarker m = (CellCntrMarker)mit.next();
                boolean bl = sameSlice = m.getZ() == this.img.getCurrentSlice();
                if (!sameSlice && !this.showAll) continue;
                xM = (double)(m.getX() - this.srcRect.x) * this.magnification;
                yM = (double)(m.getY() - this.srcRect.y) * this.magnification;
                if (sameSlice) {
                    g2.fillOval((int)xM - 2, (int)yM - 2, 4, 4);
                } else {
                    g2.drawOval((int)xM - 2, (int)yM - 2, 4, 4);
                }
                if (!this.showNumbers) continue;
                g2.drawString(Integer.toString(typeID), (int)xM + 3, (int)yM - 3);
            }
        }
    }

    public void removeLastMarker() {
        this.currentMarkerVector.removeLastMarker();
        this.repaint();
        this.cc.populateTxtFields();
    }

    public ImagePlus imageWithMarkers() {
        Roi roi;
        Image image = this.createImage(this.img.getWidth(), this.img.getHeight());
        Graphics gr = image.getGraphics();
        double xM = 0.0;
        double yM = 0.0;
        try {
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.img.updateImage();
            }
            Image image2 = this.img.getImage();
            gr.drawImage(image2, 0, 0, this.img.getWidth(), this.img.getHeight(), null);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory((String)("Paint " + e.getMessage()));
        }
        Graphics2D g2r = (Graphics2D)gr;
        g2r.setStroke(new BasicStroke(1.0f));
        ListIterator<CellCntrMarkerVector> it = this.typeVector.listIterator();
        while (it.hasNext()) {
            CellCntrMarkerVector mv = it.next();
            int typeID = mv.getType();
            g2r.setColor(mv.getColor());
            ListIterator mit = mv.listIterator();
            while (mit.hasNext()) {
                CellCntrMarker m = (CellCntrMarker)mit.next();
                if (m.getZ() != this.img.getCurrentSlice()) continue;
                xM = m.getX();
                yM = m.getY();
                g2r.fillOval((int)xM - 2, (int)yM - 2, 4, 4);
                if (!this.showNumbers) continue;
                g2r.drawString(Integer.toString(typeID), (int)xM + 3, (int)yM - 3);
            }
        }
        Vector displayList = this.getDisplayList();
        if (displayList != null && displayList.size() == 1 && (roi = (Roi)displayList.elementAt(0)).getType() == 9) {
            roi.draw(gr);
        }
        return new ImagePlus("Markers_" + this.img.getTitle(), image);
    }

    public void measure() {
        Calibration cal = this.img.getCalibration();
        String unit = cal.getUnit();
        String columnHeadings = String.format("Type\tSlice\tX\tY\tValue\tC-pos\tZ-pos\tT-pos\tX(%s)\tY(%s)\tZ(%s)", unit, unit, unit);
        IJ.setColumnHeadings((String)columnHeadings);
        for (int i = 1; i <= this.img.getStackSize(); ++i) {
            this.img.setSlice(i);
            ImageProcessor ip = this.img.getProcessor();
            ListIterator<CellCntrMarkerVector> it = this.typeVector.listIterator();
            while (it.hasNext()) {
                CellCntrMarkerVector mv = it.next();
                int typeID = mv.getType();
                ListIterator mit = mv.listIterator();
                while (mit.hasNext()) {
                    CellCntrMarker m = (CellCntrMarker)mit.next();
                    if (m.getZ() != i) continue;
                    int xM = m.getX();
                    int yM = m.getY();
                    int zM = m.getZ();
                    double value = ip.getPixelValue(xM, yM);
                    int[] realPosArray = this.img.convertIndexToPosition(zM);
                    int channel = realPosArray[0];
                    int zPos = realPosArray[1];
                    int frame = realPosArray[2];
                    double xMcal = (double)xM * cal.pixelWidth;
                    double yMcal = (double)yM * cal.pixelHeight;
                    double zMcal = (double)(zPos - 1) * cal.pixelDepth;
                    String resultsRow = String.format("%d\t%d\t%d\t%d\t%f\t%d\t%d\t%d\t%.3f\t%.3f\t%.3f", typeID, zM, xM, yM, value, channel, zPos, frame, xMcal, yMcal, zMcal);
                    IJ.write((String)resultsRow);
                }
            }
        }
    }

    public Vector<CellCntrMarkerVector> getTypeVector() {
        return this.typeVector;
    }

    public void setTypeVector(Vector<CellCntrMarkerVector> typeVector) {
        this.typeVector = typeVector;
    }

    public CellCntrMarkerVector getCurrentMarkerVector() {
        return this.currentMarkerVector;
    }

    public void setCurrentMarkerVector(CellCntrMarkerVector currentMarkerVector) {
        this.currentMarkerVector = currentMarkerVector;
    }

    public boolean isDelmode() {
        return this.delmode;
    }

    public void setDelmode(boolean delmode) {
        this.delmode = delmode;
    }

    public boolean isShowNumbers() {
        return this.showNumbers;
    }

    public void setShowNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }
}

