/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.Morph;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.LeafState;

public class MorphState
extends LeafState {
    private int[] geometry;
    private double[] weights;
    private int appearance;

    public MorphState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.appearance = control.getSymbolTable().addReference(((Morph)this.node).getAppearance());
            this.weights = ((Morph)this.node).getWeights();
            this.geometry = new int[this.weights.length];
            for (int i = 0; i < this.weights.length; ++i) {
                this.geometry[i] = control.getSymbolTable().addReference(((Morph)this.node).getGeometryArray(i));
            }
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        this.control.writeBounds(out, ((Morph)this.node).getCollisionBounds());
        out.writeInt(this.appearance);
        out.writeBoolean(((Morph)this.node).getAppearanceOverrideEnable());
        out.writeInt(this.geometry.length);
        for (int i = 0; i < this.geometry.length; ++i) {
            out.writeInt(this.geometry[i]);
            out.writeDouble(this.weights[i]);
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((Morph)this.node).setCollisionBounds(this.control.readBounds(in));
        this.appearance = in.readInt();
        ((Morph)this.node).setAppearanceOverrideEnable(in.readBoolean());
        int len = in.readInt();
        this.geometry = new int[len];
        this.weights = new double[len];
        for (int i = 0; i < this.geometry.length; ++i) {
            this.geometry[i] = in.readInt();
            this.weights[i] = in.readDouble();
        }
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.appearance);
        for (int i = 0; i < this.geometry.length; ++i) {
            this.control.getSymbolTable().incNodeComponentRefCount(this.geometry[i]);
        }
    }

    @Override
    public void buildGraph() {
        ((Morph)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.appearance));
        GeometryArray[] geom = new GeometryArray[this.geometry.length];
        for (int i = 0; i < this.geometry.length; ++i) {
            geom[i] = (GeometryArray)this.control.getSymbolTable().getJ3dNode(this.geometry[i]);
        }
        ((Morph)this.node).setGeometryArrays(geom);
        ((Morph)this.node).setWeights(this.weights);
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Morph(null);
    }
}

