/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.GenericMetadataGroup;
import org.janelia.saalfeldlab.n5.universe.metadata.MultiscaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataGroup;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;

public class N5ViewerMultichannelMetadata
implements N5MetadataGroup<MultiscaleMetadata<?>> {
    public static final Predicate<String> channelPredicate = Pattern.compile("^c\\d+$").asPredicate();
    private final String basePath;
    private final MultiscaleMetadata<?>[] childMetadata;

    public N5ViewerMultichannelMetadata(String basePath, MultiscaleMetadata<?>[] childMetadata) {
        this.basePath = basePath;
        this.childMetadata = childMetadata;
    }

    public String getPath() {
        return this.basePath;
    }

    public String[] getPaths() {
        return (String[])Arrays.stream(this.childMetadata).map(m -> m.getPath()).toArray(String[]::new);
    }

    public MultiscaleMetadata<?>[] getChildrenMetadata() {
        return this.childMetadata;
    }

    public static class GenericMultichannelMetadataParser
    implements N5MetadataParser<GenericMetadataGroup<N5SingleScaleMetadata>> {
        public Optional<GenericMetadataGroup<N5SingleScaleMetadata>> parseMetadata(N5Reader n5, N5TreeNode node) {
            HashMap<String, N5TreeNode> children = new HashMap<String, N5TreeNode>();
            for (N5TreeNode childNode : node.childrenList()) {
                if (!channelPredicate.test(childNode.getNodeName()) || !(childNode.getMetadata() instanceof N5SingleScaleMetadata)) continue;
                children.put(childNode.getNodeName(), childNode);
            }
            N5SingleScaleMetadata[] childMetadata = (N5SingleScaleMetadata[])children.values().stream().map(N5TreeNode::getMetadata).toArray(N5SingleScaleMetadata[]::new);
            if (childMetadata.length == 0) {
                return Optional.empty();
            }
            return Optional.of(new GenericMetadataGroup(node.getPath(), (N5Metadata[])childMetadata));
        }
    }

    public static class N5ViewerMultichannelMetadataParser
    implements N5MetadataParser<N5ViewerMultichannelMetadata> {
        public Optional<N5ViewerMultichannelMetadata> parseMetadata(N5Reader n5, N5TreeNode node) {
            HashMap<String, N5TreeNode> scaleLevelNodes = new HashMap<String, N5TreeNode>();
            for (N5TreeNode childNode : node.childrenList()) {
                if (!channelPredicate.test(childNode.getNodeName()) || !(childNode.getMetadata() instanceof MultiscaleMetadata)) continue;
                scaleLevelNodes.put(childNode.getNodeName(), childNode);
            }
            if (scaleLevelNodes.isEmpty()) {
                return Optional.empty();
            }
            MultiscaleMetadata[] childMetadata = (MultiscaleMetadata[])scaleLevelNodes.values().stream().map(N5TreeNode::getMetadata).toArray(MultiscaleMetadata[]::new);
            return Optional.of(new N5ViewerMultichannelMetadata(node.getPath(), childMetadata));
        }
    }
}

