/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.scijava.script.ScriptLanguage;
import org.scijava.ui.swing.script.TextEditor;

public class ErrorHandler {
    protected List<Error> list = new ArrayList<Error>();
    protected int current = -1;
    protected JTextArea textArea;
    protected int currentOffset;
    protected Parser parser;

    public ErrorHandler(JTextArea textArea) {
        this.textArea = textArea;
    }

    public ErrorHandler(ScriptLanguage language, JTextArea textArea, int startOffset) {
        this(textArea);
        String languageName;
        String string = languageName = language == null ? "None" : language.getLanguageName();
        if (!languageName.equals("Java")) {
            return;
        }
        this.parser = new JavacErrorParser();
        this.currentOffset = startOffset;
        try {
            this.parseErrors();
        }
        catch (BadLocationException e) {
            this.handleException(e);
        }
    }

    public int getErrorCount() {
        return this.list.size();
    }

    public boolean setCurrent(int index) {
        if (index < 0 || index >= this.list.size()) {
            return false;
        }
        this.current = index;
        return true;
    }

    public boolean nextError(boolean forward) {
        if (forward) {
            if (this.current + 1 >= this.list.size()) {
                return false;
            }
            ++this.current;
        } else {
            if (this.current - 1 < 0) {
                return false;
            }
            --this.current;
        }
        return true;
    }

    public String getPath() {
        return this.list.get((int)this.current).path;
    }

    public int getLine() {
        return this.list.get((int)this.current).line;
    }

    public Position getPosition() {
        return this.list.get((int)this.current).position;
    }

    public void markLine() throws BadLocationException {
        int offset = this.getPosition().getOffset();
        int line = this.textArea.getLineOfOffset(offset);
        int start = this.textArea.getLineStartOffset(line);
        int end = this.textArea.getLineEndOffset(line);
        this.textArea.getHighlighter().removeAllHighlights();
        this.textArea.getHighlighter().addHighlight(start, end, DefaultHighlighter.DefaultPainter);
        this.scrollToVisible(start);
    }

    public void scrollToVisible(int offset) {
        if (this.textArea == null) {
            return;
        }
        JTextArea textArea = this.textArea;
        Runnable task = () -> {
            try {
                textArea.scrollRectToVisible(textArea.modelToView(textArea.getDocument().getLength()));
                textArea.scrollRectToVisible(textArea.modelToView(offset));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(task);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addError(String path, int line, String text) {
        try {
            Document document = this.textArea.getDocument();
            int offset = document.getLength();
            if (!text.endsWith("\n")) {
                text = text + "\n";
            }
            this.textArea.insert(text, offset);
            if (path == null || line < 0) {
                return;
            }
            Error error = new Error(path, line);
            error.position = document.createPosition(offset + 1);
            this.list.add(error);
        }
        catch (BadLocationException e) {
            this.handleException(e);
        }
    }

    void parseErrors() throws BadLocationException {
        int line = this.textArea.getLineOfOffset(this.currentOffset);
        int lineCount = this.textArea.getLineCount();
        while (++line < lineCount) {
            int end;
            int start = this.textArea.getLineStartOffset(line);
            String text = this.textArea.getText(start, (end = this.textArea.getLineEndOffset(line)) - start);
            Error error = this.parser.getError(text);
            if (error == null) continue;
            try {
                error.position = this.textArea.getDocument().createPosition(start);
                this.list.add(error);
                continue;
            }
            catch (BadLocationException e) {
                this.handleException(e);
                continue;
            }
            break;
        }
        return;
    }

    private void handleException(Throwable e) {
        TextEditor.handleException(e, this.textArea);
    }

    class JavacErrorParser
    implements Parser {
        JavacErrorParser() {
        }

        @Override
        public Error getError(String line) {
            int lineNumber;
            int colon = line.indexOf(".java:");
            if (colon <= 0) {
                return null;
            }
            int next = line.indexOf(58, (colon += 5) + 1);
            if (next < colon + 2) {
                return null;
            }
            try {
                lineNumber = Integer.parseInt(line.substring(colon + 1, next));
            }
            catch (NumberFormatException e) {
                return null;
            }
            String fileName = line.substring(0, colon);
            return new Error(fileName, lineNumber);
        }
    }

    static interface Parser {
        public Error getError(String var1);
    }

    static class Error {
        String path;
        int line;
        Position position;

        public Error(String path, int line) {
            this.path = path;
            this.line = line;
        }
    }
}

