/*
 * Decompiled with CFR 0.152.
 */
package io.scif.jj2000.j2k.wavelet.synthesis;

import io.scif.jj2000.j2k.decoder.DecoderSpecs;
import io.scif.jj2000.j2k.image.DataBlk;
import io.scif.jj2000.j2k.image.DataBlkFloat;
import io.scif.jj2000.j2k.image.DataBlkInt;
import io.scif.jj2000.j2k.util.FacilityManager;
import io.scif.jj2000.j2k.util.ProgressWatch;
import io.scif.jj2000.j2k.wavelet.Subband;
import io.scif.jj2000.j2k.wavelet.synthesis.CBlkWTDataSrcDec;
import io.scif.jj2000.j2k.wavelet.synthesis.InverseWT;
import io.scif.jj2000.j2k.wavelet.synthesis.SubbandSyn;
import java.awt.Point;

public class InvWTFull
extends InverseWT {
    private ProgressWatch pw = null;
    private int cblkToDecode = 0;
    private int nDecCblk = 0;
    private CBlkWTDataSrcDec src;
    private int dtype;
    private DataBlk[] reconstructedComps;
    private int[] ndl;
    private boolean[][] reversible;

    public InvWTFull(CBlkWTDataSrcDec src, DecoderSpecs decSpec) {
        super(src, decSpec);
        this.src = src;
        int nc = src.getNumComps();
        this.reconstructedComps = new DataBlk[nc];
        this.ndl = new int[nc];
        this.pw = FacilityManager.getProgressWatch();
    }

    private boolean isSubbandReversible(Subband subband) {
        if (subband.isNode) {
            return this.isSubbandReversible(subband.getLL()) && this.isSubbandReversible(subband.getHL()) && this.isSubbandReversible(subband.getLH()) && this.isSubbandReversible(subband.getHH()) && ((SubbandSyn)subband).hFilter.isReversible() && ((SubbandSyn)subband).vFilter.isReversible();
        }
        return true;
    }

    public boolean isReversible(int t, int c) {
        if (this.reversible[t] == null) {
            this.reversible[t] = new boolean[this.getNumComps()];
            for (int i = this.reversible.length - 1; i >= 0; --i) {
                this.reversible[t][i] = this.isSubbandReversible(this.src.getSynSubbandTree(t, i));
            }
        }
        return this.reversible[t][c];
    }

    public int getNomRangeBits(int c) {
        return this.src.getNomRangeBits(c);
    }

    public int getFixedPoint(int c) {
        return this.src.getFixedPoint(c);
    }

    public final DataBlk getInternCompData(DataBlk blk, int c) {
        int tIdx = this.getTileIdx();
        this.dtype = this.src.getSynSubbandTree(tIdx, c).getHorWFilter() == null ? 3 : this.src.getSynSubbandTree(tIdx, c).getHorWFilter().getDataType();
        if (this.reconstructedComps[c] == null) {
            switch (this.dtype) {
                case 4: {
                    this.reconstructedComps[c] = new DataBlkFloat(0, 0, this.getTileCompWidth(tIdx, c), this.getTileCompHeight(tIdx, c));
                    break;
                }
                case 3: {
                    this.reconstructedComps[c] = new DataBlkInt(0, 0, this.getTileCompWidth(tIdx, c), this.getTileCompHeight(tIdx, c));
                }
            }
            this.waveletTreeReconstruction(this.reconstructedComps[c], this.src.getSynSubbandTree(tIdx, c), c);
            if (this.pw != null && c == this.src.getNumComps() - 1) {
                this.pw.terminateProgressWatch();
            }
        }
        if (blk.getDataType() != this.dtype) {
            blk = this.dtype == 3 ? new DataBlkInt(blk.ulx, blk.uly, blk.w, blk.h) : new DataBlkFloat(blk.ulx, blk.uly, blk.w, blk.h);
        }
        blk.setData(this.reconstructedComps[c].getData());
        blk.offset = this.reconstructedComps[c].w * blk.uly + blk.ulx;
        blk.scanw = this.reconstructedComps[c].w;
        blk.progressive = false;
        return blk;
    }

    public DataBlk getCompData(DataBlk blk, int c) {
        Object[] dst_data = null;
        switch (blk.getDataType()) {
            case 3: {
                int[] dst_data_int = (int[])blk.getData();
                if (dst_data_int == null || dst_data_int.length < blk.w * blk.h) {
                    dst_data_int = new int[blk.w * blk.h];
                }
                dst_data = dst_data_int;
                break;
            }
            case 4: {
                float[] dst_data_float = (float[])blk.getData();
                if (dst_data_float == null || dst_data_float.length < blk.w * blk.h) {
                    dst_data_float = new float[blk.w * blk.h];
                }
                dst_data = dst_data_float;
            }
        }
        blk = this.getInternCompData(blk, c);
        blk.setData(dst_data);
        blk.offset = 0;
        blk.scanw = blk.w;
        return blk;
    }

    private void wavelet2DReconstruction(DataBlk db, SubbandSyn sb, int c) {
        int i;
        if (sb.w == 0 || sb.h == 0) {
            return;
        }
        Object data = db.getData();
        int ulx = sb.ulx;
        int uly = sb.uly;
        int w = sb.w;
        int h = sb.h;
        Object[] buf = null;
        switch (sb.getHorWFilter().getDataType()) {
            case 3: {
                buf = new int[w >= h ? w : h];
                break;
            }
            case 4: {
                buf = new float[w >= h ? w : h];
            }
        }
        int offset = (uly - db.uly) * db.w + ulx - db.ulx;
        if (sb.ulcx % 2 == 0) {
            i = 0;
            while (i < h) {
                System.arraycopy(data, offset, buf, 0, w);
                sb.hFilter.synthetize_lpf(buf, 0, (w + 1) / 2, 1, buf, (w + 1) / 2, w / 2, 1, data, offset, 1);
                ++i;
                offset += db.w;
            }
        } else {
            i = 0;
            while (i < h) {
                System.arraycopy(data, offset, buf, 0, w);
                sb.hFilter.synthetize_hpf(buf, 0, w / 2, 1, buf, w / 2, (w + 1) / 2, 1, data, offset, 1);
                ++i;
                offset += db.w;
            }
        }
        offset = (uly - db.uly) * db.w + ulx - db.ulx;
        switch (sb.getVerWFilter().getDataType()) {
            case 3: {
                int[] data_int = (int[])data;
                Object[] buf_int = buf;
                if (sb.ulcy % 2 == 0) {
                    int j = 0;
                    while (j < w) {
                        i = h - 1;
                        int k = offset + i * db.w;
                        while (i >= 0) {
                            buf_int[i] = data_int[k];
                            --i;
                            k -= db.w;
                        }
                        sb.vFilter.synthetize_lpf(buf, 0, (h + 1) / 2, 1, buf, (h + 1) / 2, h / 2, 1, data, offset, db.w);
                        ++j;
                        ++offset;
                    }
                } else {
                    int j = 0;
                    while (j < w) {
                        i = h - 1;
                        int k = offset + i * db.w;
                        while (i >= 0) {
                            buf_int[i] = data_int[k];
                            --i;
                            k -= db.w;
                        }
                        sb.vFilter.synthetize_hpf(buf, 0, h / 2, 1, buf, h / 2, (h + 1) / 2, 1, data, offset, db.w);
                        ++j;
                        ++offset;
                    }
                }
                break;
            }
            case 4: {
                float[] data_float = (float[])data;
                float[] buf_float = buf;
                if (sb.ulcy % 2 == 0) {
                    int j = 0;
                    while (j < w) {
                        i = h - 1;
                        int k = offset + i * db.w;
                        while (i >= 0) {
                            buf_float[i] = data_float[k];
                            --i;
                            k -= db.w;
                        }
                        sb.vFilter.synthetize_lpf(buf, 0, (h + 1) / 2, 1, buf, (h + 1) / 2, h / 2, 1, data, offset, db.w);
                        ++j;
                        ++offset;
                    }
                } else {
                    int j = 0;
                    while (j < w) {
                        i = h - 1;
                        int k = offset + i * db.w;
                        while (i >= 0) {
                            buf_float[i] = data_float[k];
                            --i;
                            k -= db.w;
                        }
                        sb.vFilter.synthetize_hpf(buf, 0, h / 2, 1, buf, h / 2, (h + 1) / 2, 1, data, offset, db.w);
                        ++j;
                        ++offset;
                    }
                }
                break;
            }
        }
    }

    private void waveletTreeReconstruction(DataBlk img, SubbandSyn sb, int c) {
        if (!sb.isNode) {
            if (sb.w == 0 || sb.h == 0) {
                return;
            }
            DataBlk subbData = this.dtype == 3 ? new DataBlkInt() : new DataBlkFloat();
            Point ncblks = sb.numCb;
            Object dst_data = img.getData();
            for (int m = 0; m < ncblks.y; ++m) {
                for (int n = 0; n < ncblks.x; ++n) {
                    subbData = this.src.getInternCodeBlock(c, m, n, sb, subbData);
                    Object src_data = subbData.getData();
                    if (this.pw != null) {
                        ++this.nDecCblk;
                        this.pw.updateProgressWatch(this.nDecCblk, null);
                    }
                    for (int i = subbData.h - 1; i >= 0; --i) {
                        System.arraycopy(src_data, subbData.offset + i * subbData.scanw, dst_data, (subbData.uly + i) * img.w + subbData.ulx, subbData.w);
                    }
                }
            }
        } else if (sb.isNode) {
            this.waveletTreeReconstruction(img, (SubbandSyn)sb.getLL(), c);
            if (sb.resLvl <= this.reslvl - this.maxImgRes + this.ndl[c]) {
                this.waveletTreeReconstruction(img, (SubbandSyn)sb.getHL(), c);
                this.waveletTreeReconstruction(img, (SubbandSyn)sb.getLH(), c);
                this.waveletTreeReconstruction(img, (SubbandSyn)sb.getHH(), c);
                this.wavelet2DReconstruction(img, sb, c);
            }
        }
    }

    public int getImplementationType(int c) {
        return 2;
    }

    public void setTile(int x, int y) {
        super.setTile(x, y);
        int nc = this.src.getNumComps();
        int tIdx = this.src.getTileIdx();
        for (int c = 0; c < nc; ++c) {
            this.ndl[c] = this.src.getSynSubbandTree((int)tIdx, (int)c).resLvl;
        }
        if (this.reconstructedComps != null) {
            for (int i = this.reconstructedComps.length - 1; i >= 0; --i) {
                this.reconstructedComps[i] = null;
            }
        }
        this.cblkToDecode = 0;
        for (int c = 0; c < nc; ++c) {
            SubbandSyn root = this.src.getSynSubbandTree(tIdx, c);
            for (int r = 0; r <= this.reslvl - this.maxImgRes + root.resLvl; ++r) {
                SubbandSyn sb;
                if (r == 0) {
                    sb = (SubbandSyn)root.getSubbandByIdx(0, 0);
                    if (sb == null) continue;
                    this.cblkToDecode += sb.numCb.x * sb.numCb.y;
                    continue;
                }
                sb = (SubbandSyn)root.getSubbandByIdx(r, 1);
                if (sb != null) {
                    this.cblkToDecode += sb.numCb.x * sb.numCb.y;
                }
                if ((sb = (SubbandSyn)root.getSubbandByIdx(r, 2)) != null) {
                    this.cblkToDecode += sb.numCb.x * sb.numCb.y;
                }
                if ((sb = (SubbandSyn)root.getSubbandByIdx(r, 3)) == null) continue;
                this.cblkToDecode += sb.numCb.x * sb.numCb.y;
            }
        }
        this.nDecCblk = 0;
        if (this.pw != null) {
            this.pw.initProgressWatch(0, this.cblkToDecode, "Decoding tile " + tIdx + "...");
        }
    }

    public void nextTile() {
        super.nextTile();
        int nc = this.src.getNumComps();
        int tIdx = this.src.getTileIdx();
        for (int c = 0; c < nc; ++c) {
            this.ndl[c] = this.src.getSynSubbandTree((int)tIdx, (int)c).resLvl;
        }
        if (this.reconstructedComps != null) {
            for (int i = this.reconstructedComps.length - 1; i >= 0; --i) {
                this.reconstructedComps[i] = null;
            }
        }
    }
}

