/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import sc.fiji.io.FlexibleFileOpener;
import sc.fiji.io.NrrdFileInfo;

public class Nrrd_Reader
extends ImagePlus
implements PlugIn {
    public final String uint8Types = "uchar, unsigned char, uint8, uint8_t";
    public final String int16Types = "short, short int, signed short, signed short int, int16, int16_t";
    public final String uint16Types = "ushort, unsigned short, unsigned short int, uint16, uint16_t";
    public final String int32Types = "int, signed int, int32, int32_t";
    public final String uint32Types = "uint, unsigned int, uint32, uint32_t";
    private String notes = "";
    private boolean detachedHeader = false;
    public String headerPath = null;
    public String imagePath = null;
    public String imageName = null;

    public void run(String arg) {
        String directory = "";
        String name = arg;
        if (arg == null || arg == "") {
            OpenDialog od = new OpenDialog("Load Nrrd (or .nhdr) File...", arg);
            name = od.getFileName();
            if (name == null) {
                return;
            }
            directory = od.getDirectory();
        } else {
            File dest = new File(arg);
            directory = dest.getParent();
            name = dest.getName();
        }
        ImagePlus imp = this.load(directory, name);
        if (imp == null) {
            return;
        }
        if (this.imageName != null) {
            this.setStack(this.imageName, imp.getStack());
        } else {
            this.setStack(name, imp.getStack());
        }
        if (!this.notes.equals("")) {
            this.setProperty("Info", this.notes);
        }
        this.copyScale(imp);
        if (arg.equals("")) {
            this.show();
        }
    }

    public ImagePlus load(String directory, String fileName) {
        ImagePlus imp;
        NrrdFileInfo fi;
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        if (fileName == null || fileName == "") {
            return null;
        }
        try {
            fi = this.getHeaderInfo(directory, fileName);
        }
        catch (IOException e) {
            IJ.write((String)("readHeader: " + e.getMessage()));
            return null;
        }
        if (IJ.debugMode) {
            IJ.log((String)("fi:" + (Object)((Object)fi)));
        }
        IJ.showStatus((String)("Loading Nrrd File: " + directory + fileName));
        if (fi.encoding.equals("gzip") && this.detachedHeader) {
            FlexibleFileOpener gzfo = new FlexibleFileOpener(fi, 1);
            imp = gzfo.open(false);
        } else if (fi.encoding.equals("gzip")) {
            long preOffset = fi.longOffset > 0L ? fi.longOffset : (long)fi.offset;
            fi.offset = 0;
            fi.longOffset = 0L;
            FlexibleFileOpener gzfo = new FlexibleFileOpener(fi, 1, preOffset);
            if (IJ.debugMode) {
                IJ.log((String)("gzfo:" + (Object)((Object)gzfo)));
            }
            imp = gzfo.open(false);
        } else {
            FileOpener fo = new FileOpener((FileInfo)fi);
            imp = fo.open(false);
        }
        if (imp == null) {
            return null;
        }
        Calibration cal = imp.getCalibration();
        Calibration spatialCal = this.getCalibration();
        cal.pixelWidth = spatialCal.pixelWidth;
        cal.pixelHeight = spatialCal.pixelHeight;
        cal.pixelDepth = spatialCal.pixelDepth;
        cal.setUnit(spatialCal.getUnit());
        cal.xOrigin = spatialCal.xOrigin;
        cal.yOrigin = spatialCal.yOrigin;
        cal.zOrigin = spatialCal.zOrigin;
        imp.setCalibration(cal);
        return imp;
    }

    public NrrdFileInfo getHeaderInfo(String directory, String fileName) throws IOException {
        if (IJ.debugMode) {
            IJ.log((String)"Entering Nrrd_Reader.readHeader():");
        }
        NrrdFileInfo fi = new NrrdFileInfo();
        fi.directory = directory;
        fi.fileName = fileName;
        Calibration spatialCal = this.getCalibration();
        RandomAccessFile input = new RandomAccessFile(fi.directory + fi.fileName, "r");
        fi.fileType = 0;
        spatialCal.setUnit("micron");
        fi.fileFormat = 1;
        fi.nImages = 1;
        while (true) {
            int i;
            String thisLine;
            if ((thisLine = input.readLine()) == null || thisLine.equals("")) {
                if (this.detachedHeader) break;
                fi.longOffset = input.getFilePointer();
                break;
            }
            this.notes = this.notes + thisLine + "\n";
            if (thisLine.indexOf("#") == 0) continue;
            String noteType = this.getFieldPart(thisLine, 0).toLowerCase();
            String noteValue = this.getFieldPart(thisLine, 1);
            String noteValuelc = noteValue.toLowerCase();
            String firstNoteValue = this.getSubField(thisLine, 0);
            if (IJ.debugMode) {
                IJ.log((String)("NoteType:" + noteType + ", noteValue:" + noteValue));
            }
            if (noteType.equals("data file") || noteType.equals("datafile")) {
                if (firstNoteValue.equals("LIST")) {
                    throw new IOException("Nrrd_Reader: not yet able to handle datafile: LIST specifications");
                }
                if (!this.getSubField(thisLine, 1).equals("")) {
                    throw new IOException("Nrrd_Reader: not yet able to handle datafile: sprintf file specifications");
                }
                File imageFile = noteValue.indexOf("/") == 0 ? new File(noteValue) : new File(fi.directory, noteValue);
                if (imageFile.exists()) {
                    fi.directory = imageFile.getParent();
                    fi.fileName = imageFile.getName();
                    this.imagePath = imageFile.getPath();
                    this.detachedHeader = true;
                } else {
                    throw new IOException("Unable to find image file =" + imageFile.getPath());
                }
            }
            if (noteType.equals("dimension")) {
                fi.dimension = Integer.valueOf(noteValue);
                if (fi.dimension > 3) {
                    throw new IOException("Nrrd_Reader: Dimension>3 not yet implemented!");
                }
            }
            if (noteType.equals("sizes")) {
                fi.sizes = new int[fi.dimension];
                for (int i2 = 0; i2 < fi.dimension; ++i2) {
                    fi.sizes[i2] = Integer.valueOf(this.getSubField(thisLine, i2));
                    if (i2 == 0) {
                        fi.width = fi.sizes[0];
                    }
                    if (i2 == 1) {
                        fi.height = fi.sizes[1];
                    }
                    if (i2 != 2) continue;
                    fi.nImages = fi.sizes[2];
                }
            }
            if (noteType.equals("units")) {
                spatialCal.setUnit(firstNoteValue);
            }
            if (noteType.equals("space units")) {
                spatialCal.setUnit(firstNoteValue);
            }
            if (noteType.equals("spacings")) {
                double[] spacings = new double[fi.dimension];
                for (i = 0; i < fi.dimension; ++i) {
                    spacings[i] = Double.valueOf(this.getSubField(thisLine, i));
                    if (i == 0) {
                        spatialCal.pixelWidth = spacings[0];
                    }
                    if (i == 1) {
                        spatialCal.pixelHeight = spacings[1];
                    }
                    if (i != 2) continue;
                    spatialCal.pixelDepth = spacings[2];
                }
            }
            if (noteType.equals("space dimension")) {
                fi.spaceDims = Integer.valueOf(noteValue);
                if (fi.spaceDims != fi.dimension) {
                    throw new IOException("Nrrd_Reader: Don't yet know how to handle image dimension!=space dimension!");
                }
            }
            if (noteType.equals("space")) {
                fi.setSpace(noteValue);
                if (fi.spaceDims > 3) {
                    throw new IOException("Nrrd_Reader: Dimension>3 not yet implemented!");
                }
            }
            if (noteType.equals("space directions")) {
                double[][] spaceDirs = new double[fi.spaceDims][fi.spaceDims];
                int dim = 0;
                for (i = 0; i < fi.dimension; ++i) {
                    double[] vec = this.getVector(noteValue, i);
                    if (vec == null) continue;
                    for (int j = 0; j < fi.spaceDims; ++j) {
                        spaceDirs[dim][j] = vec[j];
                    }
                    ++dim;
                }
                fi.setSpaceDirs(spaceDirs);
            }
            if (noteType.equals("space origin")) {
                fi.setSpaceOrigin(this.getVector(thisLine, 0));
            }
            if (noteType.equals("centers") || noteType.equals("centerings")) {
                fi.centers = new String[fi.dimension];
                for (int i3 = 0; i3 < fi.dimension; ++i3) {
                    fi.centers[i3] = this.getSubField(thisLine, i3);
                }
            }
            if (noteType.equals("axis mins") || noteType.equals("axismins")) {
                double[] axismins = new double[fi.dimension];
                for (i = 0; i < fi.dimension; ++i) {
                    axismins[i] = Double.valueOf(this.getSubField(thisLine, i));
                    if (i == 0) {
                        spatialCal.xOrigin = axismins[0];
                    }
                    if (i == 1) {
                        spatialCal.yOrigin = axismins[1];
                    }
                    if (i != 2) continue;
                    spatialCal.zOrigin = axismins[2];
                }
            }
            if (noteType.equals("type")) {
                if ("uchar, unsigned char, uint8, uint8_t".indexOf(noteValuelc) >= 0) {
                    fi.fileType = 0;
                } else if ("ushort, unsigned short, unsigned short int, uint16, uint16_t".indexOf(noteValuelc) >= 0) {
                    fi.fileType = 2;
                } else if ("short, short int, signed short, signed short int, int16, int16_t".indexOf(noteValuelc) >= 0) {
                    fi.fileType = 1;
                } else if ("uint, unsigned int, uint32, uint32_t".indexOf(noteValuelc) >= 0) {
                    fi.fileType = 11;
                } else if ("int, signed int, int32, int32_t".indexOf(noteValuelc) >= 0) {
                    fi.fileType = 3;
                } else if (noteValuelc.equals("float")) {
                    fi.fileType = 4;
                } else if (noteValuelc.equals("double")) {
                    fi.fileType = 16;
                } else {
                    throw new IOException("Unimplemented data type =" + noteValue);
                }
            }
            if (noteType.equals("byte skip") || noteType.equals("byteskip")) {
                fi.longOffset = Long.valueOf(noteValue);
            }
            if (noteType.equals("endian")) {
                fi.intelByteOrder = noteValuelc.equals("little");
            }
            if (!noteType.equals("encoding")) continue;
            if (noteValuelc.equals("gz")) {
                noteValuelc = "gzip";
            }
            fi.encoding = noteValuelc;
        }
        if (fi.spaceDims > 0) {
            spatialCal = fi.updateCalibration(spatialCal);
        } else {
            if (spatialCal.pixelWidth != 0.0) {
                spatialCal.xOrigin /= spatialCal.pixelWidth;
            }
            if (spatialCal.pixelHeight != 0.0) {
                spatialCal.yOrigin /= spatialCal.pixelHeight;
            }
            if (spatialCal.pixelDepth != 0.0) {
                spatialCal.zOrigin /= spatialCal.pixelDepth;
            }
            if (fi.centers != null) {
                if (fi.centers[0].equals("cell")) {
                    spatialCal.xOrigin -= spatialCal.pixelWidth / 2.0;
                }
                if (fi.centers[1].equals("cell")) {
                    spatialCal.yOrigin -= spatialCal.pixelHeight / 2.0;
                }
                if (fi.dimension > 2 && fi.centers[2].equals("cell")) {
                    spatialCal.zOrigin -= spatialCal.pixelDepth / 2.0;
                }
            }
        }
        if (!this.detachedHeader) {
            fi.longOffset = input.getFilePointer();
        }
        input.close();
        this.setCalibration(spatialCal);
        return fi;
    }

    String getFieldPart(String str, int fieldIndex) {
        String[] fieldParts = (str = str.trim()).split(":\\s+");
        if (fieldParts.length < 2) {
            return fieldParts[0];
        }
        if (fieldIndex == 0) {
            return fieldParts[0];
        }
        return fieldParts[1];
    }

    String getSubField(String str, int fieldIndex) {
        String[] fields_values;
        String fieldDescriptor = this.getFieldPart(str, 1);
        fieldDescriptor = fieldDescriptor.trim();
        if (IJ.debugMode) {
            IJ.log((String)("fieldDescriptor = " + fieldDescriptor + "; fieldIndex = " + fieldIndex));
        }
        if (fieldIndex >= (fields_values = fieldDescriptor.split("\\s+")).length) {
            return "";
        }
        String rval = fields_values[fieldIndex];
        if (rval.startsWith("\"")) {
            rval = rval.substring(1);
        }
        if (rval.endsWith("\"")) {
            rval = rval.substring(0, rval.length() - 1);
        }
        return rval;
    }

    double[] getVector(String str, int vecIndex) {
        String fieldDescriptor = this.getFieldPart(str, 1);
        fieldDescriptor = fieldDescriptor.trim();
        if (IJ.debugMode) {
            IJ.log((String)("fieldDescriptor = " + fieldDescriptor));
        }
        fieldDescriptor.replace("none", "(none)");
        String[] fields_values = fieldDescriptor.split("\\)\\s*\\(");
        if (vecIndex >= fields_values.length) {
            return null;
        }
        String svec = fields_values[vecIndex];
        svec = svec.trim();
        if ((svec = svec.replaceAll("[()]", "")).equals("") || svec.equals("none")) {
            return null;
        }
        String[] svals = svec.split("\\s*,\\s*");
        double[] rvals = new double[svals.length];
        for (int i = 0; i < svals.length; ++i) {
            rvals[i] = new Double(svals[i]);
        }
        return rvals;
    }
}

