/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.File;
import java.io.FileInputStream;

public class Open_DF3
implements PlugIn {
    public void run(String arg) {
        File f = new File(arg);
        if (!f.exists()) {
            OpenDialog od = new OpenDialog("Open df3 file.", null);
            String dir = od.getDirectory();
            String name = od.getFileName();
            f = new File(dir + name);
            if (!f.exists()) {
                IJ.error((String)"File not found.");
                return;
            }
        }
        try {
            FileInputStream file = new FileInputStream(f);
            byte[] header = new byte[6];
            file.read(header);
            int width = ((0xFF & header[0]) << 8) + (0xFF & header[1]);
            int height = ((0xFF & header[2]) << 8) + (0xFF & header[3]);
            int depth = ((0xFF & header[4]) << 8) + (0xFF & header[5]);
            byte typeLength = (byte)(f.length() / (long)width / (long)depth / (long)height);
            ImageStack stack = new ImageStack(width, height);
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (int z = 0; z < depth; ++z) {
                ByteProcessor ip = null;
                byte[] slice = new byte[height * width * typeLength];
                file.read(slice);
                switch (typeLength) {
                    case 1: {
                        ip = new ByteProcessor(width, height, slice, null);
                        break;
                    }
                    case 2: {
                        short[] shortSlice = new short[height * width];
                        for (int i = 0; i < shortSlice.length; ++i) {
                            int j = 2 * i;
                            int v = (0xFF & slice[j]) << 8;
                            if ((double)(v += 0xFF & slice[j + 1]) < min) {
                                min = v;
                            }
                            if ((double)v > max) {
                                max = v;
                            }
                            shortSlice[i] = (short)v;
                        }
                        ip = new ShortProcessor(width, height, shortSlice, null);
                        break;
                    }
                    default: {
                        float[] floatSlice = new float[height * width];
                        for (int i = 0; i < floatSlice.length; ++i) {
                            int j = 4 * i;
                            long v = (0xFFL & (long)slice[j]) << 24;
                            v += (0xFFL & (long)slice[j + 1]) << 16;
                            v += (0xFFL & (long)slice[j + 2]) << 8;
                            if ((double)(v += 0xFFL & (long)slice[j + 3]) < min) {
                                min = v;
                            }
                            if ((double)v > max) {
                                max = v;
                            }
                            floatSlice[i] = v;
                        }
                        ip = new FloatProcessor(width, height, floatSlice, null);
                    }
                }
                IJ.showProgress((int)z, (int)depth);
                IJ.showStatus((String)("Reading: " + z + "/" + depth));
                stack.addSlice(null, (ImageProcessor)ip);
            }
            ImagePlus imp = new ImagePlus(f.getName().replaceAll(".df3$", ""), stack);
            imp.setDisplayRange(min, max);
            imp.show();
        }
        catch (Exception e) {
            IJ.error((String)("Opening '" + f + "' as df3 failed.\n" + e.getMessage()));
        }
    }
}

