/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.QRDecomposition;
import org.ojalgo.matrix.decomposition.RawQR;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.type.context.NumberContext;

public interface QR<N extends Number>
extends MatrixDecomposition<N>,
MatrixDecomposition.Solver<N>,
MatrixDecomposition.EconomySize<N>,
MatrixDecomposition.Determinant<N>,
MatrixDecomposition.RankRevealing<N> {
    public static final Factory<BigDecimal> BIG = (typical, fullSize) -> new QRDecomposition.Big(fullSize);
    public static final Factory<ComplexNumber> COMPLEX = (typical, fullSize) -> new QRDecomposition.Complex(fullSize);
    public static final Factory<Double> PRIMITIVE = (typical, fullSize) -> {
        if (fullSize || typical.isFat() || 256L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
            return new QRDecomposition.Primitive(fullSize);
        }
        return new RawQR();
    };
    public static final Factory<Quaternion> QUATERNION = (typical, fullSize) -> new QRDecomposition.Quat(fullSize);
    public static final Factory<RationalNumber> RATIONAL = (typical, fullSize) -> new QRDecomposition.Rational(fullSize);

    public static <N extends Number> QR<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return BIG.make(typical);
        }
        if (tmpNumber instanceof ComplexNumber) {
            return COMPLEX.make(typical);
        }
        if (tmpNumber instanceof Double) {
            return PRIMITIVE.make(typical);
        }
        throw new IllegalArgumentException();
    }

    public static <N extends Number> boolean equals(MatrixStore<N> matrix, QR<N> decomposition, NumberContext context) {
        MatrixStore<MatrixStore<N>> tmpQ = decomposition.getQ();
        MatrixStore<N> tmpR = decomposition.getR();
        MatrixStore<MatrixStore<N>> tmpStore = tmpQ.multiply(tmpR);
        return Access2D.equals(tmpStore, matrix, context);
    }

    public static <N extends Number> MatrixStore<N> reconstruct(QR<N> decomposition) {
        return decomposition.getQ().multiply(decomposition.getR());
    }

    public MatrixStore<N> getQ();

    public MatrixStore<N> getR();

    @Deprecated
    default public boolean isFullColumnRank() {
        return this.isFullRank();
    }

    @Override
    default public boolean isOrdered() {
        return false;
    }

    @Override
    default public MatrixStore<N> reconstruct() {
        return QR.reconstruct(this);
    }

    public static interface Factory<N extends Number>
    extends MatrixDecomposition.Factory<QR<N>> {
        default public QR<N> make(boolean fullSize) {
            return this.make(MatrixDecomposition.TYPICAL, fullSize);
        }

        @Override
        default public QR<N> make(Structure2D typical) {
            return this.make(typical, false);
        }

        public QR<N> make(Structure2D var1, boolean var2);
    }
}

