/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.io.Serializable;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.type.context.NumberContext;

abstract class AbstractStore<N extends Number>
implements MatrixStore<N>,
Serializable {
    private final int myColDim;
    private transient Class<?> myComponentType = null;
    private final int myRowDim;

    private AbstractStore() {
        this(0, 0);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected AbstractStore(int numberOfRows, int numberOfColumns) {
        this.myRowDim = numberOfRows;
        this.myColDim = numberOfColumns;
    }

    @Override
    public long countColumns() {
        return this.myColDim;
    }

    @Override
    public long countRows() {
        return this.myRowDim;
    }

    public final boolean equals(Object someObj) {
        if (someObj instanceof MatrixStore) {
            return this.equals((MatrixStore)someObj, NumberContext.getGeneral(6));
        }
        return super.equals(someObj);
    }

    @Override
    public final MatrixStore<N> get() {
        return this;
    }

    public final int hashCode() {
        return MatrixUtils.hashCode(this);
    }

    @Override
    public int limitOfColumn(int col) {
        return this.myRowDim;
    }

    @Override
    public int limitOfRow(int row) {
        return this.myColDim;
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        if (this.isPrimitive()) {
            PhysicalStore tmpStep1 = (PhysicalStore)this.physical().makeZero(1L, leftAndRight.count());
            tmpStep1.fillByMultiplying(leftAndRight, this);
            PhysicalStore tmpStep2 = (PhysicalStore)this.physical().makeZero(1L, 1L);
            tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
            return tmpStep2.get(0L);
        }
        return MatrixStore.super.multiplyBoth(leftAndRight);
    }

    public final String toString() {
        return Access2D.toString(this);
    }

    protected final int getColDim() {
        return this.myColDim;
    }

    protected final int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    protected final int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    protected final int getRowDim() {
        return this.myRowDim;
    }

    protected final boolean isPrimitive() {
        return this.getComponentType().equals(Double.class);
    }

    final Class<?> getComponentType() {
        if (this.myComponentType == null) {
            this.myComponentType = this.get(0L, 0L).getClass();
        }
        return this.myComponentType;
    }
}

