/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.localization;

import net.imglib2.algorithm.localization.FitFunction;

public class EllipticGaussianOrtho
implements FitFunction {
    public String toString() {
        return "Orthogonal elliptic gaussian function A \u00d7 exp( - \u2211 b\u1d62 \u00d7 (x\u1d62 - x\u2080\u1d62)\u00b2 )";
    }

    @Override
    public final double val(double[] x, double[] a) {
        return a[x.length] * EllipticGaussianOrtho.E(x, a);
    }

    @Override
    public final double grad(double[] x, double[] a, int k) {
        int ndims = x.length;
        if (k < ndims) {
            int dim = k;
            return -2.0 * a[ndims] * a[dim + ndims + 1] * (x[dim] - a[dim]) * EllipticGaussianOrtho.E(x, a);
        }
        if (k == ndims) {
            return EllipticGaussianOrtho.E(x, a);
        }
        int dim = k - ndims - 1;
        double di = x[dim] - a[dim];
        return -di * di * a[ndims] * EllipticGaussianOrtho.E(x, a);
    }

    @Override
    public final double hessian(double[] x, double[] a, int r, int c) {
        if (c < r) {
            int tmp = c;
            c = r;
            r = tmp;
        }
        int ndims = x.length;
        if (c == r) {
            if (c < ndims) {
                int dim = c;
                double di = a[dim] - x[dim];
                return 2.0 * a[ndims] * a[ndims + 1 + dim] * (2.0 * a[ndims + 1 + dim] * di * di - 1.0) * EllipticGaussianOrtho.E(x, a);
            }
            if (c == ndims) {
                return 0.0;
            }
            int dim = c - ndims - 1;
            double di = x[dim] - a[dim];
            return a[ndims] * EllipticGaussianOrtho.E(x, a) * di * di * di * di;
        }
        if (c < ndims && r < ndims) {
            int i = c;
            int j = r;
            double di = x[i] - a[i];
            double dj = x[j] - a[j];
            return 4.0 * a[ndims] * a[i + ndims + 1] * a[j + ndims + 1] * di * dj * EllipticGaussianOrtho.E(x, a);
        }
        if (r < ndims && c == ndims) {
            int dim = r;
            return -2.0 * a[dim + ndims + 1] * (x[dim] - a[dim]) * EllipticGaussianOrtho.E(x, a);
        }
        if (r < ndims && c > ndims) {
            if (c == r + ndims + 1) {
                int i = r;
                double di = x[i] - a[i];
                return -2.0 * a[ndims] * di * (a[r + ndims + 1] * di * di - 1.0) * EllipticGaussianOrtho.E(x, a);
            }
            int i = r;
            int j = c - ndims - 1;
            double di = x[i] - a[i];
            double dj = x[j] - a[j];
            return -2.0 * a[ndims] * a[i + ndims + 1] * di * dj * dj * EllipticGaussianOrtho.E(x, a);
        }
        if (c > ndims && r > ndims) {
            int i = r - ndims - 1;
            int j = c - ndims - 1;
            double di = x[i] - a[i];
            double dj = x[j] - a[j];
            return a[ndims] * EllipticGaussianOrtho.E(x, a) * di * di * dj * dj;
        }
        int dim = c - ndims - 1;
        double di = x[dim] - a[dim];
        return di * di * EllipticGaussianOrtho.E(x, a);
    }

    private static final double E(double[] x, double[] a) {
        int ndims = x.length;
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double di = x[i] - a[i];
            sum += a[i + ndims + 1] * di * di;
        }
        return Math.exp(-sum);
    }
}

