/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.pde.ExplicitDiffusionScheme3D;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class StandardDiffusionScheme3D<T extends RealType<T>>
extends ExplicitDiffusionScheme3D<T> {
    private static final float DEFAULT_DT = 0.15f;
    private float dt;

    public StandardDiffusionScheme3D(Img<T> input, Img<FloatType> D) {
        this(input, D, 0.15f);
    }

    public StandardDiffusionScheme3D(Img<T> input, Img<FloatType> D, float dt) {
        super(input, D);
        this.dt = dt;
    }

    public StandardDiffusionScheme3D(RandomAccessibleInterval<T> input, RandomAccessibleInterval<FloatType> D, ImgFactory<FloatType> imgFactory) {
        this(input, D, imgFactory, 0.15f);
    }

    public StandardDiffusionScheme3D(RandomAccessibleInterval<T> input, RandomAccessibleInterval<FloatType> D, ImgFactory<FloatType> imgFactory, float dt) {
        super(input, D, imgFactory);
        this.dt = dt;
    }

    @Override
    protected final float diffusionScheme(float[] U, float[][] D) {
        float Uccc = U[0];
        float Uccm = U[1];
        float Ucmm = U[2];
        float Umcm = U[3];
        float Ucpm = U[4];
        float Upcm = U[5];
        float Upmc = U[6];
        float Ucmc = U[7];
        float Ummc = U[8];
        float Umcc = U[9];
        float Umpc = U[10];
        float Ucpc = U[11];
        float Uppc = U[12];
        float Upcc = U[13];
        float Upcp = U[14];
        float Ucmp = U[15];
        float Umcp = U[16];
        float Ucpp = U[17];
        float Uccp = U[18];
        float Accc = D[0][0];
        float Amcc = D[0][1];
        float Apcc = D[0][2];
        float Bccc = D[1][0];
        float Bcmc = D[1][1];
        float Bcpc = D[1][2];
        float Cccc = D[2][0];
        float Cccm = D[2][1];
        float Cccp = D[2][2];
        float Dcmc = D[3][2];
        float Dmcc = D[3][4];
        float Dcpc = D[3][6];
        float Dpcc = D[3][8];
        float Eccm = D[4][1];
        float Emcc = D[4][4];
        float Epcc = D[4][5];
        float Eccp = D[4][8];
        float Fccm = D[5][1];
        float Fcmc = D[5][4];
        float Fcpc = D[5][5];
        float Fccp = D[5][8];
        float Icpm = 0.5f * (-Fccm - Fcpc) * (Ucpm - Uccc);
        float Imcm = 0.5f * (Eccm + Emcc) * (Umcm - Uccc);
        float Iccm = (Cccm + Cccc) * (Uccm - Uccc);
        float Ipcm = 0.5f * (-Eccm - Epcc) * (Upcm - Uccc);
        float Icmm = 0.5f * (Fccm + Fcmc) * (Ucmm - Uccc);
        float Impc = 0.5f * (-Dmcc - Dcpc) * (Umpc - Uccc);
        float Icpc = (Bcpc + Bccc) * (Ucpc - Uccc);
        float Ippc = 0.5f * (Dpcc + Dcpc) * (Uppc - Uccc);
        float Imcc = (Amcc + Accc) * (Umcc - Uccc);
        float Ipcc = (Apcc + Accc) * (Upcc - Uccc);
        float Immc = 0.5f * (Dmcc + Dcmc) * (Ummc - Uccc);
        float Icmc = (Bcmc + Bccc) * (Ucmc - Uccc);
        float Ipmc = 0.5f * (-Dpcc - Dcmc) * (Upmc - Uccc);
        float Icpp = 0.5f * (Fccp + Fcpc) * (Ucpp - Uccc);
        float Imcp = 0.5f * (-Eccp - Emcc) * (Umcp - Uccc);
        float Iccp = (Cccp + Cccc) * (Uccp - Uccc);
        float Ipcp = 0.5f * (Eccp + Epcc) * (Upcp - Uccc);
        float Icmp = 0.5f * (-Fccp - Fcmc) * (Ucmp - Uccc);
        return 0.5f * this.dt * (Icpm + Imcm + Iccm + Ipcm + Icmm + Impc + Icpc + Ippc + Imcc + Ipcc + Immc + Icmc + Ipmc + Icpp + Imcp + Iccp + Ipcp + Icmp);
    }
}

