/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui;

import ij.ImagePlus;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.imagej.ImageJ;
import net.imagej.display.ImageDisplay;
import org.scijava.Context;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.FilamentWorkflow;
import sc.fiji.filamentdetector.gui.GUIUtils;
import sc.fiji.filamentdetector.gui.controller.MainController;

public class MainAppFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    @Parameter
    private LogService log;
    @Parameter
    private Context context;
    @Parameter
    private ConvertService convert;
    private ImageJ ij;
    private JFXPanel fxPanel;
    private final FilamentWorkflow filamentDetector;
    private final ImageDisplay imd;

    public MainAppFrame(ImageJ ij, FilamentWorkflow filamentDetector) {
        ij.context().inject((Object)this);
        this.ij = ij;
        this.filamentDetector = filamentDetector;
        this.imd = filamentDetector.getImageDisplay();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainAppFrame.this.log.info((Object)"Quitting FilamentDetector... Bye bye !");
                SwingUtilities.invokeLater(() -> {
                    MainAppFrame.this.setVisible(true);
                    MainAppFrame.this.dispose();
                });
            }
        });
    }

    public void initialize() throws Exception {
        try {
            this.filamentDetector.initialize();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        GUIUtils.userCheckImpDimensions(this.ij, this.filamentDetector.getDataset());
        Platform.setImplicitExit((boolean)false);
        this.fxPanel = new JFXPanel();
        this.add((Component)this.fxPanel);
        this.setVisible(true);
        Platform.runLater(() -> this.initFX(this.fxPanel));
    }

    public void initFX(JFXPanel fxPanel) {
        try {
            URL fxmlUrl = MainAppFrame.class.getResource("/sc/fiji/filamentdetector/gui/view/MainView.fxml");
            FXMLLoader loader = new FXMLLoader(fxmlUrl);
            MainController mainController = new MainController(this.context, this.filamentDetector);
            loader.setController((Object)mainController);
            AnchorPane mainScreen = (AnchorPane)loader.load();
            Scene scene = new Scene((Parent)mainScreen);
            this.fxPanel.setScene(scene);
            mainController.setPane((Pane)mainScreen);
            this.setSize((int)scene.getWidth(), (int)scene.getHeight());
            ImagePlus imp = (ImagePlus)this.convert.convert((Object)this.filamentDetector.getImageDisplay(), ImagePlus.class);
            GUIUtils.positionWindow(this, (Component)imp.getWindow());
            mainController.loadPanes();
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
    }
}

