/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller.detection;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import org.scijava.Context;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.detection.FilamentDetector;
import sc.fiji.filamentdetector.detection.RidgeDetectionFilamentDetector;
import sc.fiji.filamentdetector.gui.controller.detection.AbstractFilamentDetectorController;
import sc.fiji.filamentdetector.gui.event.DetectionParametersUpdatedEvent;
import sc.fiji.filamentdetector.gui.fxwidgets.SliderLabelSynchronizer;
import sc.fiji.filamentdetector.gui.fxwidgets.UpperLowerSynchronizer;

public class RidgeDetectionFilamentDetectorController
extends AbstractFilamentDetectorController {
    private static String FXML_PATH = "/sc/fiji/filamentdetector/gui/view/detection/RidgeDetectionFilamentDetectorView.fxml";
    @Parameter
    private EventService eventService;
    @FXML
    private Slider lineWidthSlider;
    @FXML
    private TextField lineWidthField;
    @FXML
    private Slider highContrastSlider;
    @FXML
    private TextField highContrastField;
    @FXML
    private Slider lowContrastSlider;
    @FXML
    private TextField lowContrastField;
    @FXML
    private Slider sigmaSlider;
    @FXML
    private TextField sigmaField;
    @FXML
    private Slider lowerThresholdSlider;
    @FXML
    private TextField lowerThresholdField;
    @FXML
    private Slider upperThresholdSlider;
    @FXML
    private TextField upperThresholdField;
    private SliderLabelSynchronizer sigmaSync;
    private UpperLowerSynchronizer thresholdSync;
    private SliderLabelSynchronizer lineWidthSync;
    private UpperLowerSynchronizer contrastSync;
    private RidgeDetectionFilamentDetector filamentDetector;

    public RidgeDetectionFilamentDetectorController(Context context, FilamentDetector filamentDetector) {
        context.inject((Object)this);
        this.setFXMLPath(FXML_PATH);
        this.filamentDetector = (RidgeDetectionFilamentDetector)filamentDetector;
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.sigmaSync = new SliderLabelSynchronizer(this.sigmaSlider, this.sigmaField);
        this.sigmaSync.setTooltip("Determines the sigma for the derivatives. It depends on the line width.");
        this.sigmaSync.setValue(this.filamentDetector.getSigma());
        this.thresholdSync = new UpperLowerSynchronizer(this.lowerThresholdSlider, this.lowerThresholdField, this.upperThresholdSlider, this.upperThresholdField);
        this.thresholdSync.setLowerTooltip("Line points with a response smaller as this threshold are rejected.");
        this.thresholdSync.setUpperTooltip("Line points with a response larger as this threshold are accepted.");
        this.thresholdSync.setLowerValue(this.filamentDetector.getLowerThresh());
        this.thresholdSync.setUpperValue(this.filamentDetector.getUpperThresh());
        this.lineWidthSync = new SliderLabelSynchronizer(this.lineWidthSlider, this.lineWidthField);
        this.lineWidthSync.setTooltip("The line diameter in pixels. It estimates the parameter \"sigma\" (available in the \"Advanced\" tab).");
        this.lineWidthSync.setValue(this.filamentDetector.getLineWidth());
        this.contrastSync = new UpperLowerSynchronizer(this.lowContrastSlider, this.lowContrastField, this.highContrastSlider, this.highContrastField);
        this.contrastSync.setLowerTooltip("Lowest grayscale value of the line. It estimates the parameter \"Upper Threshold\" (available in the \\\"Advanced\\\" tab).");
        this.contrastSync.setUpperTooltip("Highest grayscale value of the line. It estimates the parameter \"Lower Threshold\" (available in the \\\"Advanced\\\" tab).");
        this.contrastSync.setLowerValue(this.filamentDetector.getLowContrast());
        this.contrastSync.setUpperValue(this.filamentDetector.getHighContrast());
    }

    @FXML
    public void updateParameters(Event event) {
        if (this.sigmaSync.isEvent(event)) {
            this.sigmaSync.update(event);
            this.filamentDetector.setSigma(this.sigmaSync.getValue());
        } else if (this.thresholdSync.isEvent(event)) {
            this.thresholdSync.update(event);
            this.filamentDetector.setLowerThresh(this.thresholdSync.getLowerValue());
            this.filamentDetector.setUpperThresh(this.thresholdSync.getUpperValue());
        }
        if (this.lineWidthSync.isEvent(event)) {
            this.lineWidthSync.update(event);
            this.filamentDetector.setLineWidth(this.lineWidthSync.getValue());
            this.sigmaSync.setValue(this.filamentDetector.getSigma());
        } else if (this.contrastSync.isEvent(event)) {
            this.contrastSync.update(event);
            this.filamentDetector.setLowContrast(this.contrastSync.getLowerValue());
            this.filamentDetector.setHighContrast(this.contrastSync.getUpperValue());
            this.thresholdSync.setLowerValue(this.filamentDetector.getLowerThresh());
            this.thresholdSync.setUpperValue(this.filamentDetector.getUpperThresh());
        }
        this.eventService.publish((SciJavaEvent)new DetectionParametersUpdatedEvent());
    }
}

