/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.fxwidgets;

import java.text.DecimalFormat;
import java.text.ParseException;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;

public class SliderLabelSynchronizer {
    private Slider slider;
    private TextField textField;
    private double value;

    public SliderLabelSynchronizer(Slider slider, TextField textField) {
        this.slider = slider;
        this.textField = textField;
        this.setValue(0.0);
    }

    public void setValue(double value) {
        this.textField.setText(Double.toString(value));
        this.slider.setValue(value);
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isEvent(Event event) {
        return event.getSource().equals(this.slider) || event.getSource().equals(this.textField);
    }

    public void update(Event event) {
        DecimalFormat f = new DecimalFormat("##.00");
        if (event.getSource().equals(this.slider)) {
            try {
                double newValue = f.parse(f.format(this.slider.getValue())).doubleValue();
                this.textField.setText(Double.toString(newValue));
                this.value = newValue;
            }
            catch (ParseException e) {
                this.slider.setValue(this.value);
            }
        } else if (event.getSource().equals(this.textField)) {
            try {
                double newValue = f.parse(f.format(Double.parseDouble(this.textField.getText()))).doubleValue();
                this.slider.setValue(newValue);
                this.value = newValue;
            }
            catch (ClassCastException | NumberFormatException | ParseException e) {
                this.textField.setText(Double.toString(this.value));
            }
        }
    }

    public void setTooltip(String tooltipMessage) {
        Tooltip tooltip = new Tooltip(tooltipMessage);
        Tooltip.install((Node)this.slider, (Tooltip)tooltip);
        Tooltip.install((Node)this.textField, (Tooltip)tooltip);
    }
}

