/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.tracking.lap;

import fiji.plugin.trackmate.tracking.jaqaman.costfunction.CostFunction;
import java.util.Arrays;
import sc.fiji.filamentdetector.model.Filament;

public class BoundingBoxOverlapCostFunction
implements CostFunction<Filament, Filament> {
    public double linkingCost(Filament source, Filament target) {
        double interArea;
        double[] bboxSource = Arrays.copyOf(source.getBoundingBox(), source.getBoundingBox().length);
        double[] bboxTarget = Arrays.copyOf(target.getBoundingBox(), target.getBoundingBox().length);
        bboxSource[2] = bboxSource[0] + bboxSource[2];
        bboxSource[3] = bboxSource[1] + bboxSource[3];
        bboxTarget[2] = bboxTarget[0] + bboxTarget[2];
        bboxTarget[3] = bboxTarget[1] + bboxTarget[3];
        if (this.checkOverlap(bboxSource, bboxTarget)) {
            double xA = Math.max(bboxSource[0], bboxTarget[0]);
            double yA = Math.max(bboxSource[1], bboxTarget[1]);
            double xB = Math.min(bboxSource[2], bboxTarget[2]);
            double yB = Math.min(bboxSource[3], bboxTarget[3]);
            interArea = (xB - xA + 1.0) * (yB - yA + 1.0);
        } else {
            interArea = 0.0;
        }
        double sourceArea = (bboxSource[2] - bboxSource[0] + 1.0) * (bboxSource[3] - bboxSource[1] + 1.0);
        double targetArea = (bboxTarget[2] - bboxTarget[0] + 1.0) * (bboxTarget[3] - bboxTarget[1] + 1.0);
        double unionArea = sourceArea + targetArea - interArea;
        double iou = interArea / unionArea;
        double score = 1.0 - iou;
        if (score == 0.0) {
            score = 1.0E-5;
        }
        if (score == 1.0) {
            score = source.distanceFromCenter(target);
        }
        return score;
    }

    private boolean checkOverlap(double[] bboxSource, double[] bboxTarget) {
        if (bboxSource[2] < bboxTarget[0]) {
            return false;
        }
        if (bboxSource[0] > bboxTarget[2]) {
            return false;
        }
        if (bboxSource[3] < bboxTarget[1]) {
            return false;
        }
        return !(bboxSource[1] > bboxTarget[3]);
    }
}

