/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;

public interface N5Reader
extends AutoCloseable {
    public static final Version NO_VERSION = new Version(0, 0, 0);
    public static final Version VERSION = new Version(4, 0, 0);
    public static final String VERSION_KEY = "n5";

    default public Version getVersion() throws N5Exception {
        return new Version(this.getAttribute("/", VERSION_KEY, String.class));
    }

    public URI getURI();

    public <T> T getAttribute(String var1, String var2, Class<T> var3) throws N5Exception;

    public <T> T getAttribute(String var1, String var2, Type var3) throws N5Exception;

    public DatasetAttributes getDatasetAttributes(String var1) throws N5Exception;

    public DataBlock<?> readBlock(String var1, DatasetAttributes var2, long ... var3) throws N5Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T readSerializedBlock(String dataset, DatasetAttributes attributes, long ... gridPosition) throws N5Exception, ClassNotFoundException {
        DataBlock<?> block = this.readBlock(dataset, attributes, gridPosition);
        if (block == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(block.toByteBuffer().array());
        try (ObjectInputStream in = new ObjectInputStream(byteArrayInputStream);){
            Object object = in.readObject();
            return (T)object;
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException(e);
        }
    }

    public boolean exists(String var1);

    default public boolean datasetExists(String pathName) throws N5Exception {
        return this.exists(pathName) && this.getDatasetAttributes(pathName) != null;
    }

    public String[] list(String var1) throws N5Exception;

    default public String[] deepList(String pathName, Predicate<String> filter) throws N5Exception {
        String groupSeparator = this.getGroupSeparator();
        String normalPathName = pathName.replaceAll("(^" + groupSeparator + "*)|(" + groupSeparator + "*$)", "");
        ArrayList<String> absolutePaths = N5Reader.deepList(this, normalPathName, false, filter);
        return (String[])absolutePaths.stream().map(a -> a.replaceFirst(normalPathName + "(" + groupSeparator + "?)", "")).filter(a -> !a.isEmpty()).toArray(String[]::new);
    }

    default public String[] deepList(String pathName) throws N5Exception {
        return this.deepList(pathName, (String a) -> true);
    }

    default public String[] deepListDatasets(String pathName, Predicate<String> filter) throws N5Exception {
        String groupSeparator = this.getGroupSeparator();
        String normalPathName = pathName.replaceAll("(^" + groupSeparator + "*)|(" + groupSeparator + "*$)", "");
        ArrayList<String> absolutePaths = N5Reader.deepList(this, normalPathName, true, filter);
        return (String[])absolutePaths.stream().map(a -> a.replaceFirst(normalPathName + "(" + groupSeparator + "?)", "")).filter(a -> !a.isEmpty()).toArray(String[]::new);
    }

    default public String[] deepListDatasets(String pathName) throws N5Exception {
        return this.deepListDatasets(pathName, (String a) -> true);
    }

    public static ArrayList<String> deepList(N5Reader n5, String pathName, boolean datasetsOnly, Predicate<String> filter) throws N5Exception {
        boolean passDatasetTest;
        ArrayList<String> children = new ArrayList<String>();
        boolean isDataset = n5.datasetExists(pathName);
        boolean bl = passDatasetTest = datasetsOnly && !isDataset;
        if (!passDatasetTest && filter.test(pathName)) {
            children.add(pathName);
        }
        if (!isDataset) {
            String[] baseChildren;
            String groupSeparator = n5.getGroupSeparator();
            for (String child : baseChildren = n5.list(pathName)) {
                children.addAll(N5Reader.deepList(n5, pathName + groupSeparator + child, datasetsOnly, filter));
            }
        }
        return children;
    }

    default public String[] deepList(String pathName, Predicate<String> filter, ExecutorService executor) throws N5Exception, InterruptedException, ExecutionException {
        String groupSeparator = this.getGroupSeparator();
        String normalPathName = pathName.replaceAll("(^" + groupSeparator + "*)|(" + groupSeparator + "*$)", "");
        ArrayList<String> results = new ArrayList<String>();
        LinkedBlockingQueue<Future<String>> datasetFutures = new LinkedBlockingQueue<Future<String>>();
        N5Reader.deepListHelper(this, normalPathName, false, filter, executor, datasetFutures);
        while (!datasetFutures.isEmpty()) {
            String result = datasetFutures.poll().get();
            if (result == null || result.equals(normalPathName)) continue;
            results.add(result.substring(normalPathName.length() + groupSeparator.length()));
        }
        return (String[])results.stream().toArray(String[]::new);
    }

    default public String[] deepList(String pathName, ExecutorService executor) throws N5Exception, InterruptedException, ExecutionException {
        return this.deepList(pathName, a -> true, executor);
    }

    default public String[] deepListDatasets(String pathName, Predicate<String> filter, ExecutorService executor) throws N5Exception, InterruptedException, ExecutionException {
        String groupSeparator = this.getGroupSeparator();
        String normalPathName = pathName.replaceAll("(^" + groupSeparator + "*)|(" + groupSeparator + "*$)", "");
        ArrayList<String> results = new ArrayList<String>();
        LinkedBlockingQueue<Future<String>> datasetFutures = new LinkedBlockingQueue<Future<String>>();
        N5Reader.deepListHelper(this, normalPathName, true, filter, executor, datasetFutures);
        datasetFutures.poll().get();
        while (!datasetFutures.isEmpty()) {
            String result = datasetFutures.poll().get();
            if (result == null) continue;
            results.add(result.substring(normalPathName.length() + groupSeparator.length()));
        }
        return (String[])results.stream().toArray(String[]::new);
    }

    default public String[] deepListDatasets(String pathName, ExecutorService executor) throws N5Exception, InterruptedException, ExecutionException {
        return this.deepListDatasets(pathName, a -> true, executor);
    }

    public static void deepListHelper(N5Reader n5, String path, boolean datasetsOnly, Predicate<String> filter, ExecutorService executor, LinkedBlockingQueue<Future<String>> datasetFutures) {
        String groupSeparator = n5.getGroupSeparator();
        datasetFutures.add(executor.submit(() -> {
            boolean isDataset = false;
            try {
                isDataset = n5.datasetExists(path);
            }
            catch (N5Exception n5Exception) {
                // empty catch block
            }
            if (!isDataset) {
                String[] children = null;
                try {
                    for (String child : children = n5.list(path)) {
                        String fullChildPath = path + groupSeparator + child;
                        N5Reader.deepListHelper(n5, fullChildPath, datasetsOnly, filter, executor, datasetFutures);
                    }
                }
                catch (N5Exception n5Exception) {
                    // empty catch block
                }
            }
            boolean passDatasetTest = datasetsOnly && !isDataset;
            return !passDatasetTest && filter.test(path) ? path : null;
        }));
    }

    public Map<String, Class<?>> listAttributes(String var1) throws N5Exception;

    default public String getGroupSeparator() {
        return "/";
    }

    default public String groupPath(String ... nodes) {
        if (nodes == null || nodes.length == 0) {
            return "";
        }
        String groupSeparator = this.getGroupSeparator();
        StringBuilder builder = new StringBuilder(nodes[0]);
        for (int i = 1; i < nodes.length; ++i) {
            builder.append(groupSeparator);
            builder.append(nodes[i]);
        }
        return builder.toString();
    }

    @Override
    default public void close() {
    }

    public static class Version {
        private final int major;
        private final int minor;
        private final int patch;
        private final String suffix;

        public Version(int major, int minor, int patch, String rest) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.suffix = rest;
        }

        public Version(int major, int minor, int patch) {
            this(major, minor, patch, "");
        }

        public Version(String versionString) {
            boolean isSemVer = false;
            if (versionString != null) {
                Matcher matcher = Pattern.compile("(\\d+)(\\.(\\d+))?(\\.(\\d+))?(.*)").matcher(versionString);
                isSemVer = matcher.find();
                if (isSemVer) {
                    this.major = Integer.parseInt(matcher.group(1));
                    String minorString = matcher.group(3);
                    this.minor = !minorString.equals("") ? Integer.parseInt(minorString) : 0;
                    String patchString = matcher.group(5);
                    this.patch = !patchString.equals("") ? Integer.parseInt(patchString) : 0;
                    this.suffix = matcher.group(6);
                } else {
                    this.major = 0;
                    this.minor = 0;
                    this.patch = 0;
                    this.suffix = "";
                }
            } else {
                this.major = 0;
                this.minor = 0;
                this.patch = 0;
                this.suffix = "";
            }
        }

        public final int getMajor() {
            return this.major;
        }

        public final int getMinor() {
            return this.minor;
        }

        public final int getPatch() {
            return this.patch;
        }

        public final String getSuffix() {
            return this.suffix;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.major);
            s.append(".");
            s.append(this.minor);
            s.append(".");
            s.append(this.patch);
            s.append(this.suffix);
            return s.toString();
        }

        public boolean equals(Object other) {
            if (other instanceof Version) {
                Version otherVersion = (Version)other;
                return this.major == otherVersion.major & this.minor == otherVersion.minor & this.patch == otherVersion.patch & this.suffix.equals(otherVersion.suffix);
            }
            return false;
        }

        public boolean isCompatible(Version version) {
            return version.getMajor() <= this.major;
        }
    }
}

