/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.curve;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import sc.fiji.kappa.curve.BezierPoint;
import sc.fiji.kappa.curve.Curve;
import sc.fiji.kappa.gui.ImageUtils;
import sc.fiji.kappa.gui.KappaFrame;
import sc.fiji.kappa.gui.KappaMenuBar;

public class BezierCurve
extends Curve {
    private ArrayList<BezierPoint> curvePoints;
    private ArrayList<BezierPoint> hodographPoints;
    private ArrayList<int[]> RGBvals;
    private Point2D[] hodographCtrlPts;
    public static final int RECURSE_DEPTH = 7;
    public static final Color DEFAULT_CURVE_COLOR = Color.CYAN;
    public static final int NO_CURVE_POINTS = (int)Math.pow(2.0, 7.0) + 1;
    public static final int NO_CURVE_POINTS_DIGITS = 4;
    public static final double STEP_SIZE_ANGLE = 0.2;
    public static final int STEP_SIZE_CURVE = Math.max(4, 1);

    public BezierCurve(List<Point2D> ctrlPts, int t, int noCtrlPts, String name, int dataRadius, KappaFrame frame) {
        super(ctrlPts, t, noCtrlPts, name, dataRadius, frame);
        this.fillPoints(ctrlPts, t);
        this.evaluateThresholdedPixels();
    }

    @Override
    public void addKeyFrame(Point2D newCtrlPt, int t) {
        super.addKeyFrame(newCtrlPt, t);
        this.evaluateThresholdedPixels();
    }

    @Override
    public void translateCurve(int t) {
        super.translateCurve(t);
        this.evaluateThresholdedPixels();
    }

    @Override
    public void printValues(PrintWriter out, double[][] averaged, boolean exportAllDataPoints) {
        if (exportAllDataPoints) {
            for (int i = 0; i < this.curvePoints.size() - 1; ++i) {
                BezierPoint p = this.curvePoints.get(i);
                double x = p.getX();
                double y = p.getY();
                double k = p.k;
                int sign = p.sign;
                double red = this.RGBvals.get(i)[0];
                double green = this.RGBvals.get(i)[1];
                double blue = this.RGBvals.get(i)[2];
                out.print("," + x * micronPixelFactor);
                out.print("," + y * micronPixelFactor);
                out.print("," + k);
                out.print("," + sign);
                out.print("," + red);
                out.print("," + green);
                out.print("," + blue);
            }
        } else {
            double totalX = 0.0;
            double totalY = 0.0;
            double totalK = 0.0;
            double totalRed = 0.0;
            double totalGreen = 0.0;
            double totalBlue = 0.0;
            for (int i = 0; i < this.curvePoints.size() - 1; ++i) {
                BezierPoint p = this.curvePoints.get(i);
                totalX += p.getX();
                totalY += p.getY();
                totalK += (double)p.sign * p.k;
                totalRed += (double)this.RGBvals.get(i)[0];
                totalGreen += (double)this.RGBvals.get(i)[1];
                totalBlue += (double)this.RGBvals.get(i)[2];
            }
            out.print("," + totalX / (double)this.curvePoints.size() * micronPixelFactor);
            out.print("," + totalY / (double)this.curvePoints.size() * micronPixelFactor);
            out.print("," + totalK / (double)this.curvePoints.size());
            out.print("," + totalRed / (double)this.curvePoints.size());
            out.print("," + totalGreen / (double)this.curvePoints.size());
            out.print("," + totalBlue / (double)this.curvePoints.size());
        }
    }

    public void printValuesAll(PrintWriter out, double curveLength, double curvature, double curvatureStd) {
        for (int i = 0; i < this.curvePoints.size() - 1; ++i) {
            BezierPoint p = this.curvePoints.get(i);
            double x = p.getX();
            double y = p.getY();
            double k = p.k;
            int sign = p.sign;
            double red = this.RGBvals.get(i)[0];
            double green = this.RGBvals.get(i)[1];
            double blue = this.RGBvals.get(i)[2];
            out.print(this.name);
            out.print("," + curveLength);
            out.print("," + curvature);
            out.print("," + curvatureStd);
            out.print("," + x * micronPixelFactor);
            out.print("," + y * micronPixelFactor);
            out.print("," + k);
            out.print("," + sign);
            out.print("," + red);
            out.print("," + green);
            out.print("," + blue);
            out.println();
        }
    }

    private Point2D[] reverse(Point2D[] orig) {
        Point2D[] rev = new Point2D[orig.length];
        for (int i = 0; i < orig.length; ++i) {
            rev[i] = orig[orig.length - i - 1];
        }
        return rev;
    }

    @Override
    public void evaluateThresholdedPixels() {
        int pixelThreshold = this.frame.getInfoPanel().getDataThresholdSlider().getValue();
        boolean isBrighter = this.frame.getInfoPanel().getDataRangeComboBox().getSelectedIndex() == 0;
        this.thresholdedPixels = new ArrayList();
        this.scaledDataBounds.reset();
        for (Point2D p : this.dataFittingBounds) {
            this.scaledDataBounds.addPoint((int)p.getX(), (int)p.getY());
        }
        ImageUtils imgUtils = new ImageUtils();
        for (int x = (int)this.boundingBox.getX() - this.dataRadius; x <= (int)this.boundingBox.getX() + (int)this.boundingBox.getWidth() + this.dataRadius; ++x) {
            for (int y = (int)this.boundingBox.getY() - this.dataRadius; y <= (int)this.boundingBox.getY() + (int)this.boundingBox.getHeight() + this.dataRadius; ++y) {
                if (x < 0 || x >= this.frame.getCurrImage().getWidth() || y < 0 || y >= this.frame.getCurrImage().getHeight()) continue;
                int[] rgb = imgUtils.getPixels(this.frame.getImageStack(), x, y);
                int channel = this.frame.getInfoPanel().getFittingChannelsComboBox().getSelectedIndex();
                long intensity = channel == 0 ? (long)rgb[0] : (channel == 1 ? (long)rgb[1] : (channel == 2 ? (long)rgb[2] : (long)((rgb[0] + rgb[1] + rgb[2]) / 3)));
                if ((!isBrighter || intensity < (long)pixelThreshold) && (isBrighter || intensity > (long)pixelThreshold) || !this.scaledDataBounds.contains(new Point2D.Double(x, y))) continue;
                this.thresholdedPixels.add(new Point2D.Double(x, y));
            }
        }
    }

    @Override
    public void drawThresholdedPixels(Graphics2D g, double scale) {
        g.setColor(Color.MAGENTA);
        for (Point2D p : this.thresholdedPixels) {
            g.fillRect((int)Math.round(p.getX() * scale), (int)Math.round(p.getY() * scale), (int)Math.round(scale), (int)Math.round(scale));
        }
    }

    @Override
    protected void fillPoints(List<Point2D> ctrlPtsList, int t) {
        this.curvePoints = new ArrayList(NO_CURVE_POINTS);
        this.RGBvals = new ArrayList(NO_CURVE_POINTS);
        this.hodographPoints = new ArrayList(NO_CURVE_POINTS);
        Point2D[] ctrlPts = new Point2D[this.noCtrlPts];
        for (int i = 0; i < ctrlPtsList.size(); ++i) {
            ctrlPts[i] = ctrlPtsList.get(i);
        }
        ImageUtils imgUtils = new ImageUtils();
        this.curvePoints.add(new BezierPoint(ctrlPts[0].getX(), ctrlPts[0].getY(), this.getCurvature(ctrlPts)));
        this.RGBvals.add(imgUtils.getPixels(this.frame.getImageStack(), (int)ctrlPts[0].getX(), (int)ctrlPts[0].getY()));
        this.fillBezierPoints(this.curvePoints, ctrlPts, this.noCtrlPts, 7, 0.0, 1.0, true);
        this.curvePoints.add(new BezierPoint(ctrlPts[this.noCtrlPts - 1].getX(), ctrlPts[this.noCtrlPts - 1].getY(), this.getCurvature(this.reverse(ctrlPts))));
        this.RGBvals.add(imgUtils.getPixels(this.frame.getImageStack(), (int)ctrlPts[this.noCtrlPts - 1].getX(), (int)ctrlPts[this.noCtrlPts - 1].getY()));
        this.hodographCtrlPts = new Point2D[ctrlPts.length - 1];
        for (int i = 0; i < this.hodographCtrlPts.length; ++i) {
            this.hodographCtrlPts[i] = new Point2D.Double((double)ctrlPts.length * (ctrlPts[i + 1].getX() - ctrlPts[i].getX()), (double)ctrlPts.length * (ctrlPts[i + 1].getY() - ctrlPts[i].getY()));
        }
        this.hodographPoints.add(new BezierPoint(this.hodographCtrlPts[0].getX(), this.hodographCtrlPts[0].getY(), this.getCurvature(this.hodographCtrlPts)));
        this.fillBezierPoints(this.hodographPoints, this.hodographCtrlPts, this.noCtrlPts - 1, 7, 0.0, 1.0, false);
        this.hodographPoints.add(new BezierPoint(this.hodographCtrlPts[this.hodographCtrlPts.length - 1].getX(), this.hodographCtrlPts[this.hodographCtrlPts.length - 1].getY(), this.getCurvature(this.reverse(this.hodographCtrlPts))));
        this.bounds = this.generateOffsetBounds(this.bounds, 5);
        this.dataFittingBounds = this.generateOffsetBounds(this.dataFittingBounds, this.dataRadius);
    }

    protected void generateRightOffsetCurve(List<Point2D> bounds, int radius) {
        for (int i = 0; i < this.curvePoints.size(); i += STEP_SIZE_CURVE) {
            Point2D p = this.curvePoints.get(i);
            Point2D dp = this.hodographPoints.get(i);
            double normalizationFactor = Math.sqrt(dp.getX() * dp.getX() + dp.getY() * dp.getY());
            bounds.add(new Point2D.Double(p.getX() + (double)radius * (dp.getY() / normalizationFactor), p.getY() + (double)radius * (-dp.getX() / normalizationFactor)));
        }
    }

    protected void generateRightCap(List<Point2D> bounds, int radius) {
        Point2D p = this.curvePoints.get(this.curvePoints.size() - 1);
        Point2D dp = this.hodographPoints.get(this.curvePoints.size() - 1);
        double normalizationFactor = Math.sqrt(dp.getX() * dp.getX() + dp.getY() * dp.getY());
        Point2D.Double offsetPt = new Point2D.Double(p.getX() + (double)radius * (dp.getY() / normalizationFactor), p.getY() + (double)radius * (-dp.getX() / normalizationFactor));
        Point2D.Double translatedPt = new Point2D.Double(((Point2D)offsetPt).getX() - p.getX(), ((Point2D)offsetPt).getY() - p.getY());
        for (double theta = 0.0; theta <= Math.PI; theta += 0.2) {
            bounds.add(new Point2D.Double(((Point2D)translatedPt).getX() * Math.cos(theta) - ((Point2D)translatedPt).getY() * Math.sin(theta) + p.getX(), ((Point2D)translatedPt).getX() * Math.sin(theta) + ((Point2D)translatedPt).getY() * Math.cos(theta) + p.getY()));
        }
    }

    protected void generateLeftOffsetCurve(List<Point2D> bounds, int radius) {
        for (int i = this.curvePoints.size() - 1; i >= 0; i -= STEP_SIZE_CURVE) {
            Point2D p = this.curvePoints.get(i);
            Point2D dp = this.hodographPoints.get(i);
            double normalizationFactor = Math.sqrt(dp.getX() * dp.getX() + dp.getY() * dp.getY());
            bounds.add(new Point2D.Double(p.getX() - (double)radius * (dp.getY() / normalizationFactor), p.getY() - (double)radius * (-dp.getX() / normalizationFactor)));
        }
    }

    protected void generateLeftCap(List<Point2D> bounds, int radius) {
        Point2D p = this.curvePoints.get(0);
        Point2D dp = this.hodographPoints.get(0);
        double normalizationFactor = Math.sqrt(dp.getX() * dp.getX() + dp.getY() * dp.getY());
        Point2D.Double offsetPt = new Point2D.Double(p.getX() - (double)radius * (dp.getY() / normalizationFactor), p.getY() - (double)radius * (-dp.getX() / normalizationFactor));
        Point2D.Double translatedPt = new Point2D.Double(((Point2D)offsetPt).getX() - p.getX(), ((Point2D)offsetPt).getY() - p.getY());
        for (double theta = 0.0; theta <= Math.PI; theta += 0.2) {
            bounds.add(new Point2D.Double(((Point2D)translatedPt).getX() * Math.cos(theta) - ((Point2D)translatedPt).getY() * Math.sin(theta) + p.getX(), ((Point2D)translatedPt).getX() * Math.sin(theta) + ((Point2D)translatedPt).getY() * Math.cos(theta) + p.getY()));
        }
    }

    @Override
    protected List<Point2D> generateOffsetBounds(List<Point2D> bounds, int radius) {
        bounds = new ArrayList<Point2D>();
        this.generateRightOffsetCurve(bounds, radius);
        this.generateRightCap(bounds, radius);
        this.generateLeftOffsetCurve(bounds, radius);
        this.generateLeftCap(bounds, radius);
        return bounds;
    }

    private double getCurvature(Point2D[] p) {
        if (p.length < 3) {
            return 0.0;
        }
        double a = p[0].distance(p[1]);
        double dx = p[1].getX() - p[0].getX();
        double dy = p[1].getY() - p[0].getY();
        double h = (dx * (p[0].getY() - p[2].getY()) - dy * (p[0].getX() - p[2].getX())) / Math.sqrt(dx * dx + dy * dy);
        int n = this.noCtrlPts - 1;
        return (double)(n - 1) / ((double)n * 1.0) * (h / (a * a)) * (1.0 / micronPixelFactor);
    }

    private void fillBezierPoints(ArrayList<BezierPoint> curvePoints, Point2D[] controlPoints, int noCtrlPts, int depth, double t0, double t2, boolean addRGB) {
        if (depth == 0) {
            return;
        }
        double t1 = (t0 + t2) / 2.0;
        double tau = (t1 - t0) / (t2 - t0);
        Point2D[][] points = new Point2D[noCtrlPts][noCtrlPts];
        for (int i = 0; i < noCtrlPts; ++i) {
            points[i][0] = controlPoints[i];
        }
        for (int j = 1; j < noCtrlPts; ++j) {
            for (int i = 0; i < noCtrlPts - j; ++i) {
                points[i][j] = new Point2D.Double(points[i][j - 1].getX() * (1.0 - tau) + tau * points[i + 1][j - 1].getX(), points[i][j - 1].getY() * (1.0 - tau) + tau * points[i + 1][j - 1].getY());
            }
        }
        Point2D[] firstHalfPoints = new Point2D[noCtrlPts];
        Point2D[] secondHalfPoints = new Point2D[noCtrlPts];
        for (int j = 0; j < noCtrlPts; ++j) {
            firstHalfPoints[j] = points[0][j];
            secondHalfPoints[j] = points[j][noCtrlPts - j - 1];
        }
        this.fillBezierPoints(curvePoints, firstHalfPoints, noCtrlPts, depth - 1, t0, t1, addRGB);
        curvePoints.add(new BezierPoint(points[0][noCtrlPts - 1].getX(), points[0][noCtrlPts - 1].getY(), this.getCurvature(secondHalfPoints)));
        if (addRGB) {
            ImageUtils imgUtils = new ImageUtils();
            this.RGBvals.add(imgUtils.getPixels(this.frame.getImageStack(), (int)points[0][noCtrlPts - 1].getX(), (int)points[0][noCtrlPts - 1].getY()));
        }
        this.fillBezierPoints(curvePoints, secondHalfPoints, noCtrlPts, depth - 1, t1, t2, addRGB);
    }

    public String toString() {
        StringBuffer curveString = new StringBuffer();
        curveString.append(this.name + "\n");
        for (int i = 0; i < this.curvePoints.size(); ++i) {
            curveString.append(this.curvePoints.get(i).toString() + "\n");
        }
        return curveString.toString();
    }

    @Override
    public void draw(double scale, Graphics2D g, int currentPoint, boolean showBoundingBox, boolean scaleCurveStrokes, boolean showTangent, boolean showThresholdRegion) {
        int i;
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (scaleCurveStrokes) {
            g.setStroke(new BasicStroke((int)this.frame.getStrokeThickness(scale)));
        } else {
            g.setStroke(new BasicStroke(0.0f));
        }
        if (this.selected) {
            g.setColor(Color.GRAY);
            for (i = 0; i < this.noCtrlPts - 1; ++i) {
                g.drawLine((int)(((Point2D)this.ctrlPts.get(i)).getX() * scale), (int)(((Point2D)this.ctrlPts.get(i)).getY() * scale), (int)(((Point2D)this.ctrlPts.get(i + 1)).getX() * scale), (int)(((Point2D)this.ctrlPts.get(i + 1)).getY() * scale));
            }
            g.drawLine((int)(((Point2D)this.ctrlPts.get(this.noCtrlPts - 1)).getX() * scale), (int)(((Point2D)this.ctrlPts.get(this.noCtrlPts - 1)).getY() * scale), (int)(((Point2D)this.ctrlPts.get(0)).getX() * scale), (int)(((Point2D)this.ctrlPts.get(0)).getY() * scale));
        }
        if (this.selected) {
            g.setColor(DEFAULT_CURVE_COLOR);
        } else {
            g.setColor(Color.GRAY);
        }
        for (i = 0; i < this.curvePoints.size() - 1; ++i) {
            g.drawLine((int)(this.curvePoints.get((int)i).x * scale), (int)(this.curvePoints.get((int)i).y * scale), (int)(this.curvePoints.get((int)(i + 1)).x * scale), (int)(this.curvePoints.get((int)(i + 1)).y * scale));
        }
        if (showBoundingBox) {
            g.setColor(Color.GRAY);
            Rectangle2D.Double b = this.getScaledBounds(this.boundingBox, scale);
            g.drawRect((int)((RectangularShape)b).getX(), (int)((RectangularShape)b).getY(), (int)((RectangularShape)b).getWidth(), (int)((RectangularShape)b).getHeight());
        }
        if (showThresholdRegion) {
            this.scaledDataBounds.reset();
            for (Point2D p : this.dataFittingBounds) {
                this.scaledDataBounds.addPoint((int)(p.getX() * scale), (int)(p.getY() * scale));
            }
            if (scaleCurveStrokes) {
                g.setStroke(new BasicStroke((int)(this.frame.getStrokeThickness(scale) * 0.75)));
                g.setColor(Curve.THRESHOLD_DATA_CONTOUR_COLOR);
                g.drawPolygon(this.scaledBounds);
            }
        }
        if (this.selected) {
            g.setColor(Curve.CTRL_PT_COLOR);
            for (int i2 = 0; i2 < this.ctrlPts.size(); ++i2) {
                if (i2 == this.selectedCtrlPtIndex) {
                    g.fillRect((int)((((Point2D)this.ctrlPts.get(i2)).getX() - 1.5 * this.frame.getSelectedCtrlPointSize()) * scale), (int)((((Point2D)this.ctrlPts.get(i2)).getY() - 1.5 * this.frame.getSelectedCtrlPointSize()) * scale), (int)(3.0 * this.frame.getSelectedCtrlPointSize() * scale), (int)(3.0 * this.frame.getSelectedCtrlPointSize() * scale));
                    g.setColor(new Color(230, 230, 230));
                    continue;
                }
                if (i2 == this.hoveredCtrlPt) {
                    g.fillRect((int)((((Point2D)this.ctrlPts.get(i2)).getX() - this.frame.getSelectedCtrlPointSize()) * scale), (int)((((Point2D)this.ctrlPts.get(i2)).getY() - this.frame.getSelectedCtrlPointSize()) * scale), (int)(2.0 * this.frame.getSelectedCtrlPointSize() * scale), (int)(2.0 * this.frame.getSelectedCtrlPointSize() * scale));
                    continue;
                }
                g.fillRect((int)((((Point2D)this.ctrlPts.get(i2)).getX() - this.frame.getCtrlPointSize()) * scale), (int)((((Point2D)this.ctrlPts.get(i2)).getY() - this.frame.getCtrlPointSize()) * scale), (int)(2.0 * this.frame.getCtrlPointSize() * scale), (int)(2.0 * this.frame.getCtrlPointSize() * scale));
            }
            BezierPoint p = this.getPoint(currentPoint);
            Point2D dp = this.hodographPoints.get((NO_CURVE_POINTS - 1) * currentPoint / this.frame.getNumberOfPointsPerCurve());
            if (showTangent) {
                g.setColor(new Color(50, 100, 50));
                g.drawLine((int)((((Point2D)p).getX() - dp.getX() * 1.0) * scale), (int)((((Point2D)p).getY() - dp.getY() * 1.0) * scale), (int)((((Point2D)p).getX() + dp.getX() * 1.0) * scale), (int)((((Point2D)p).getY() + dp.getY() * 1.0) * scale));
                g.setColor(new Color(100, 50, 50));
                g.drawLine((int)((((Point2D)p).getX() - dp.getY() * 1.0) * scale), (int)((((Point2D)p).getY() + dp.getX() * 1.0) * scale), (int)((((Point2D)p).getX() + dp.getY() * 1.0) * scale), (int)((((Point2D)p).getY() - dp.getX() * 1.0) * scale));
            }
            g.setColor(Color.YELLOW);
            g.fillRect((int)((((Point2D)p).getX() - this.frame.getCtrlPointSize()) * scale), (int)((((Point2D)p).getY() - this.frame.getCtrlPointSize()) * scale), (int)(2.0 * this.frame.getCtrlPointSize() * scale), (int)(2.0 * this.frame.getCtrlPointSize() * scale));
        }
    }

    public void draw(double scale, Graphics2D g, boolean scaleCurveStrokes) {
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (scaleCurveStrokes) {
            g.setStroke(new BasicStroke((int)this.frame.getStrokeThickness(scale)));
        } else {
            g.setStroke(new BasicStroke(0.0f));
        }
        if (this.selected) {
            g.setColor(DEFAULT_CURVE_COLOR);
        } else {
            g.setColor(Color.GRAY);
        }
        for (int i = 0; i < this.curvePoints.size() - 1; ++i) {
            g.drawLine((int)(this.curvePoints.get((int)i).x * scale), (int)(this.curvePoints.get((int)i).y * scale), (int)(this.curvePoints.get((int)(i + 1)).x * scale), (int)(this.curvePoints.get((int)(i + 1)).y * scale));
        }
    }

    @Override
    public double getPointCurvature(int percentage) {
        int n = (NO_CURVE_POINTS - 1) * percentage / this.frame.getNumberOfPointsPerCurve();
        return this.getExactPointCurvature(n);
    }

    public double getExactPointCurvature(int n) {
        return this.curvePoints.get((int)n).k * (double)this.curvePoints.get((int)n).sign;
    }

    @Override
    public boolean isPointOnCurve(Point2D p, int t, double scale) {
        Rectangle2D.Double curveBounds = this.getScaledBounds(this.boundingBox, scale);
        if (!curveBounds.contains(p) && ((RectangularShape)curveBounds).getHeight() >= 5.0 && ((RectangularShape)curveBounds).getWidth() >= 5.0) {
            return false;
        }
        this.scaledBounds.reset();
        for (Point2D v : this.bounds) {
            this.scaledBounds.addPoint((int)(v.getX() * scale), (int)(v.getY() * scale));
        }
        return this.scaledBounds.contains(p);
    }

    @Override
    public double getAverageCurvature() {
        double total = 0.0;
        for (BezierPoint point : this.curvePoints) {
            total += point.k;
        }
        return total / (double)this.curvePoints.size();
    }

    private double getApproxCurveLength(int segment) {
        double length = 0.0;
        for (int i = 0; i < segment; ++i) {
            length += this.curvePoints.get(i).distance(this.curvePoints.get(i + 1));
        }
        return length * micronPixelFactor;
    }

    @Override
    public double getApproxCurveLength() {
        return this.getApproxCurveLength(this.curvePoints.size() - 1);
    }

    @Override
    public double getCurvatureStdDev() {
        double variance = 0.0;
        double mu = this.getAverageCurvature();
        for (BezierPoint point : this.curvePoints) {
            variance += (point.k - mu) * (point.k - mu);
        }
        return Math.sqrt(variance /= (double)(this.curvePoints.size() - 1));
    }

    @Override
    public List<BezierPoint> getPoints() {
        return this.curvePoints;
    }

    @Override
    public List<BezierPoint> getDigitizedPoints() {
        ArrayList<BezierPoint> digitizedPoints = new ArrayList<BezierPoint>();
        for (int i = 0; i < this.curvePoints.size(); ++i) {
            BezierPoint p = this.curvePoints.get(i);
            int n = 1;
            double totalX = p.getX() + 1.0;
            double totalY = p.getY() + 1.0;
            double totalK = p.k;
            while (i + 1 < this.curvePoints.size() && (int)this.curvePoints.get(i + 1).getX() == (int)p.getX() && (int)this.curvePoints.get(i + 1).getY() == (int)p.getY()) {
                ++n;
                p = this.curvePoints.get(++i);
                totalX += p.getX();
                totalY += p.getY();
                totalK += p.k;
            }
            digitizedPoints.add(new BezierPoint(totalX / (double)n, totalY / (double)n, totalK / (double)n));
        }
        return digitizedPoints;
    }

    @Override
    public List<Point2D> getIntensityDataRed() {
        ArrayList<Point2D> intensityData = new ArrayList<Point2D>(NO_CURVE_POINTS);
        for (int i = 0; i < this.curvePoints.size(); ++i) {
            if (KappaMenuBar.distributionDisplay == 0) {
                intensityData.add(new Point2D.Double(this.curvePoints.get((int)i).x, this.RGBvals.get(i)[0]));
                continue;
            }
            if (KappaMenuBar.distributionDisplay == 1) {
                intensityData.add(new Point2D.Double(this.getApproxCurveLength(i), this.RGBvals.get(i)[0]));
                continue;
            }
            intensityData.add(new Point2D.Double(i, this.RGBvals.get(i)[0]));
        }
        return intensityData;
    }

    @Override
    public List<Point2D> getIntensityDataGreen() {
        ArrayList<Point2D> intensityData = new ArrayList<Point2D>(NO_CURVE_POINTS);
        for (int i = 0; i < this.curvePoints.size(); ++i) {
            if (KappaMenuBar.distributionDisplay == 0) {
                intensityData.add(new Point2D.Double(this.curvePoints.get((int)i).x, this.RGBvals.get(i)[1]));
                continue;
            }
            if (KappaMenuBar.distributionDisplay == 1) {
                intensityData.add(new Point2D.Double(this.getApproxCurveLength(i), this.RGBvals.get(i)[1]));
                continue;
            }
            intensityData.add(new Point2D.Double(i, this.RGBvals.get(i)[1]));
        }
        return intensityData;
    }

    @Override
    public List<Point2D> getIntensityDataBlue() {
        ArrayList<Point2D> intensityData = new ArrayList<Point2D>(NO_CURVE_POINTS);
        for (int i = 0; i < this.curvePoints.size(); ++i) {
            if (KappaMenuBar.distributionDisplay == 0) {
                intensityData.add(new Point2D.Double(this.curvePoints.get((int)i).x, this.RGBvals.get(i)[2]));
                continue;
            }
            if (KappaMenuBar.distributionDisplay == 1) {
                intensityData.add(new Point2D.Double(this.getApproxCurveLength(i), this.RGBvals.get(i)[2]));
                continue;
            }
            intensityData.add(new Point2D.Double(i, this.RGBvals.get(i)[2]));
        }
        return intensityData;
    }

    @Override
    public List<Point2D> getCurveData() {
        ArrayList<Point2D> curveData = new ArrayList<Point2D>(NO_CURVE_POINTS);
        for (int i = 0; i < this.curvePoints.size(); ++i) {
            if (KappaMenuBar.distributionDisplay == 0) {
                curveData.add(new Point2D.Double(this.curvePoints.get((int)i).x, this.curvePoints.get((int)i).k));
                continue;
            }
            if (KappaMenuBar.distributionDisplay == 1) {
                curveData.add(new Point2D.Double(this.getApproxCurveLength(i), this.curvePoints.get((int)i).k));
                continue;
            }
            curveData.add(new Point2D.Double(i, this.curvePoints.get((int)i).k));
        }
        return curveData;
    }

    @Override
    public List<Point2D> getDebugCurveData() {
        ArrayList<Point2D> debugCurveData = new ArrayList<Point2D>(NO_CURVE_POINTS);
        for (Point2D point2D : this.curvePoints) {
            debugCurveData.add(new Point2D.Double(point2D.getX(), this.frame.computeCurvature(point2D.getX(), 6000.0 / (Curve.getMicronPixelFactor() * 1000.0), Math.PI * 2 / (double)this.frame.getCurrImage().getWidth())));
        }
        return debugCurveData;
    }

    @Override
    public void updateIntensities() {
        this.RGBvals = new ArrayList();
        ImageUtils imgUtils = new ImageUtils();
        for (Point2D point2D : this.curvePoints) {
            int[] pixels = imgUtils.getPixels(this.frame.getImageStack(), (int)point2D.getX(), (int)point2D.getY());
            this.RGBvals.add(pixels);
        }
    }

    @Override
    public int getNoPoints() {
        return NO_CURVE_POINTS;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public BezierPoint getPoint(int percentage) {
        int n = (NO_CURVE_POINTS - 1) * percentage / this.frame.getNumberOfPointsPerCurve();
        return this.getExactPoint(n);
    }

    public BezierPoint getExactPoint(int n) {
        return this.curvePoints.get(n);
    }

    @Override
    public Point2D.Double getUnitTangent(int n) {
        double dx = this.hodographPoints.get(n).getX();
        double dy = this.hodographPoints.get(n).getY();
        double normalizationFactor = Math.sqrt(dx * dx + dy * dy);
        return new Point2D.Double(dx / normalizationFactor, dy / normalizationFactor);
    }

    @Override
    public Point2D.Double getUnitNormal(int n) {
        double dx = this.hodographPoints.get(n).getX();
        double dy = this.hodographPoints.get(n).getY();
        double normalizationFactor = Math.sqrt(dx * dx + dy * dy);
        return new Point2D.Double(-dy / normalizationFactor, dx / normalizationFactor);
    }

    @Override
    public int getSign(int n) {
        return this.curvePoints.get((int)n).sign;
    }

    private double squared(double x) {
        return x * x;
    }

    int getDistanceSign(int n, Point2D x) {
        BezierPoint p = this.curvePoints.get(n);
        Point2D.Double N = this.getUnitNormal(n);
        Point2D.Double C = new Point2D.Double(p.getX() + (double)this.getSign(n) * ((Point2D)N).getX() * (1.0 / p.k), p.getY() + (double)this.getSign(n) * ((Point2D)N).getY() * (1.0 / p.k));
        if (Math.sqrt(this.squared(p.getX() - x.getX() + (((Point2D)C).getX() - p.getX())) + this.squared(p.getY() - x.getY() + (((Point2D)C).getY() - p.getY()))) > 1.0 / p.k) {
            return 1;
        }
        return -1;
    }

    public Point2D.Double getHodographPoint(int n) {
        return this.hodographPoints.get(n);
    }

    @Override
    public List<Point2D> getThresholdedPixels() {
        return this.thresholdedPixels;
    }

    @Override
    public double getMaximum(double start, double end) {
        double max = Double.MIN_VALUE;
        for (BezierPoint p : this.curvePoints) {
            if (!(p.getX() >= start) || !(p.getX() <= end) || !(p.k > max)) continue;
            max = p.k;
        }
        return max;
    }
}

