/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import sc.fiji.kappa.gui.Panel;

public class PanelGroup
extends Component {
    private static final long serialVersionUID = 1L;
    private ArrayList<Panel> panels = new ArrayList();

    public void addPanel(Panel panel) {
        if (this.panels.size() >= 1) {
            Panel prevPanel = this.panels.get(this.panels.size() - 1);
            panel.setY(prevPanel.getY() + prevPanel.getH() + 2);
        }
        this.panels.add(panel);
    }

    public void toggleVisibility(int i) {
        this.panels.get(i).toggleExpanded();
        for (int j = 1 + i; j < this.panels.size(); ++j) {
            this.panels.get(j).setY(this.panels.get(j - 1).getY() + this.panels.get(j - 1).getH() + 2);
        }
    }

    public void toggleVisibility(Point p) {
        for (int i = 0; i < this.panels.size(); ++i) {
            if (!this.panels.get(i).isVisible() || !this.panels.get(i).isPointOnToggle(p)) continue;
            this.toggleVisibility(i);
        }
    }

    public void toggleVisibility(String title) {
        for (int i = 0; i < this.panels.size(); ++i) {
            if (!this.panels.get(i).getTitle().equals(title)) continue;
            this.toggleVisibility(i);
        }
    }

    public void hide(String title) {
        for (int i = 0; i < this.panels.size(); ++i) {
            if (!this.panels.get(i).isExpanded() || !this.panels.get(i).getTitle().equals(title)) continue;
            this.toggleVisibility(i);
        }
    }

    public void show(String title) {
        for (int i = 0; i < this.panels.size(); ++i) {
            if (this.panels.get(i).isExpanded() || !this.panels.get(i).getTitle().equals(title)) continue;
            this.toggleVisibility(i);
        }
    }

    public void draw(Graphics g) {
        for (Panel p : this.panels) {
            p.draw(g);
        }
    }
}

