/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;

public class ExtractStructuredText {
    public static boolean isTest = false;
    public final boolean debug = false;
    protected static String output = System.getProperty("user.dir") + "xml";
    public static boolean showMessages = true;
    protected String separator = System.getProperty("file.separator");
    protected PdfDecoder decodePdf = null;
    protected String outputFile = "";
    private static String testFile = "/PDFdata/sample_pdfs/acroforms/myform.pdf";

    public ExtractStructuredText() {
    }

    public ExtractStructuredText(String string, String string2) {
        File file;
        output = string2;
        if (!output.endsWith(this.separator)) {
            output = output + this.separator;
        }
        if (!(file = new File(output)).exists()) {
            file.mkdirs();
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(string);
        } else {
            String[] stringArray = null;
            File file2 = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file2 = new File(string);
                if (!file2.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file2.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (showMessages) {
                    System.out.println(n + "/ " + l + " " + stringArray[n]);
                }
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    if (showMessages) {
                        System.out.println(string + stringArray[n]);
                    }
                    this.decodeFile(string + stringArray[n]);
                }
                ++n;
            }
        }
    }

    protected void decodeFile(String string) {
        String string2 = "demo";
        int n = string.lastIndexOf(this.separator);
        string2 = string.substring(n + 1, string.length() - 4);
        this.outputFile = output + this.separator + string2 + ".xml";
        try {
            this.decodePdf = new PdfDecoder(false);
            if (showMessages) {
                System.out.println("\n----------------------------");
            }
            if (showMessages) {
                System.out.println("Opening file :" + string);
            }
            this.decodePdf.openPdfFile(string);
        }
        catch (PdfSecurityException pdfSecurityException) {
            System.err.println("Security Exception " + pdfSecurityException + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
        }
        catch (PdfException pdfException) {
            System.err.println("Pdf Exception " + pdfException + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
        }
        if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied() && !this.decodePdf.isExtractionAllowed()) {
            if (showMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
                System.out.println("Or get support/consultancy");
            }
        } else {
            try {
                Document document = this.decodePdf.getMarkedContent();
                if (document == null) {
                    if (showMessages) {
                        System.out.println("No text found");
                    }
                } else {
                    InputStream inputStream = this.getClass().getResourceAsStream("/org/jpedal/examples/text/xmlstyle.xslt");
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    try {
                        Transformer transformer = transformerFactory.newTransformer(new StreamSource(inputStream));
                        transformer.transform(new DOMSource(document), new StreamResult(this.outputFile));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (showMessages) {
                        System.out.println("Writing to " + this.outputFile);
                    }
                }
                if (showMessages) {
                    System.out.println("\n----------done--------------");
                }
                this.decodePdf.flushObjectValues(false);
            }
            catch (Exception exception) {
                this.decodePdf.closePdfFile();
                System.err.println("Exception " + exception.getMessage());
                exception.printStackTrace();
                System.out.println(this.decodePdf.getObjectStore().getCurrentFilename());
            }
            this.decodePdf.flushObjectValues(true);
            if (showMessages) {
                System.out.println("Text read");
            }
            this.decodePdf.closePdfFile();
        }
    }

    public static void main(String[] stringArray) {
        if (showMessages) {
            System.out.println("Simple demo to extract text objects");
        }
        String string = testFile;
        if (stringArray.length == 2) {
            string = stringArray[0];
            output = stringArray[1];
            System.out.println("File :" + string);
        } else {
            System.out.println("Please call with either ");
            System.out.println("FileName");
        }
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + string + " not found");
        }
        long l = System.currentTimeMillis();
        ExtractStructuredText extractStructuredText = new ExtractStructuredText(string, output);
        long l2 = System.currentTimeMillis();
        if (!isTest) {
            System.out.println("Time taken=" + (l2 - l) / 1000L);
        }
    }
}

