/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.AsString;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.Complex;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Filename;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.GlobalVariable;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.ObjectClass;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Rational;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StandardError;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.SymbolProc;
import org.jruby.ir.operands.TemporaryBooleanVariable;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UnboxedBoolean;
import org.jruby.ir.operands.UnboxedFixnum;
import org.jruby.ir.operands.UnboxedFloat;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.runtime.Signature;
import org.jruby.util.KeyValuePair;
import org.jruby.util.cli.Options;

public class IRDumper
extends IRVisitor {
    private final PrintStream stream;
    private final boolean color;
    private static final String SPACES = "                                                                                                                                                                                       ";
    private static final String INSTR_COLOR = "\u001b[1;36m";
    private static final String OPERAND_COLOR = "\u001b[1;33m";
    private static final String VARIABLE_COLOR = "\u001b[1;32m";
    private static final String FIELD_COLOR = "\u001b[1;34m";
    private static final String BLOCK_COLOR = "\u001b[4;31m";
    private static final String CLEAR_COLOR = "\u001b[0m";

    public IRDumper(PrintStream ps, boolean color) {
        this.stream = ps;
        this.color = color;
    }

    public static ByteArrayOutputStream printIR(IRScope scope, boolean full) {
        return IRDumper.printIR(scope, full, false);
    }

    public static ByteArrayOutputStream printIR(IRScope scope, boolean full, boolean recurse) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        IRDumper dumper = new IRDumper(ps, (java.lang.Boolean)Options.IR_PRINT_COLOR.load());
        dumper.visit(scope, full, recurse);
        return baos;
    }

    /*
     * WARNING - void declaration
     */
    public void visit(IRScope scope, boolean full, boolean recurse) {
        BasicBlock[] instrList;
        Set<LocalVariable> usedVariables;
        this.println("begin " + scope.getScopeType().name() + "<" + scope.getName() + ">");
        InterpreterContext ic = full ? scope.getFullInterpreterContext() : scope.getInterpreterContext();
        this.println("flags: " + ic.getFlags());
        if (ic.getStaticScope().getSignature() == null) {
            this.println(Signature.NO_ARGUMENTS);
        } else {
            this.println(ic.getStaticScope().getSignature());
        }
        Map<String, LocalVariable> localVariables = ic.getScope().getLocalVariables();
        if (localVariables != null && !localVariables.isEmpty()) {
            this.println("declared variables");
            for (Map.Entry<String, LocalVariable> entry : localVariables.entrySet()) {
                this.println(this.ansiStr(VARIABLE_COLOR, "  " + entry.getValue().toString()));
            }
        }
        if ((usedVariables = ic.getScope().getUsedLocalVariables()) != null && !usedVariables.isEmpty()) {
            this.println("used variables");
            for (LocalVariable var : usedVariables) {
                this.println(this.ansiStr(VARIABLE_COLOR, "  " + var.toString()));
            }
        }
        Instr[] instrArray = ic.getInstructions();
        int longest = 0;
        int largestBlock = 0;
        if (instrArray != null) {
            largestBlock = instrArray.length;
            for (Instr i2 : instrArray) {
                if (!(i2 instanceof ResultInstr)) continue;
                longest = this.getLongestVariable(longest, (ResultInstr)((Object)i2));
            }
        } else {
            BasicBlock[] bbs;
            for (BasicBlock bb : bbs = ((FullInterpreterContext)ic).getLinearizedBBList()) {
                instrList = bb.getInstrs();
                largestBlock = Math.max(largestBlock, instrList.size());
                for (Instr instr : instrList) {
                    if (!(instr instanceof ResultInstr)) continue;
                    longest = this.getLongestVariable(longest, (ResultInstr)((Object)instr));
                }
            }
        }
        int instrLog = (int)Math.log10(largestBlock) + 1;
        String varFormat = this.ansiStr(VARIABLE_COLOR, "%" + longest + "s") + " := ";
        String varSpaces = IRDumper.spaces(longest + " := ".length());
        String ipcFormat = "  %0" + instrLog + "d: ";
        if (instrArray != null) {
            for (int i4 = 0; i4 < instrArray.length; ++i4) {
                this.formatInstr(instrArray[i4], varFormat, varSpaces, ipcFormat, instrArray[i4], i4);
            }
        } else {
            void var17_32;
            BasicBlock[] bbs;
            instrList = bbs = ((FullInterpreterContext)ic).getLinearizedBBList();
            int n = instrList.length;
            boolean bl = false;
            while (var17_32 < n) {
                Iterable<BasicBlock> outs;
                BasicBlock bb = instrList[var17_32];
                this.printAnsi(BLOCK_COLOR, "\nblock #" + bb.getID());
                if (scope.getCFG() != null && (outs = scope.getCFG().getOutgoingDestinations(bb)) != null && outs.iterator().hasNext()) {
                    this.printAnsi(BLOCK_COLOR, " (out: ");
                    boolean first2 = true;
                    for (BasicBlock out : outs) {
                        if (!first2) {
                            this.printAnsi(BLOCK_COLOR, ",");
                        }
                        first2 = false;
                        this.printAnsi(BLOCK_COLOR, "" + out.getID());
                    }
                    this.printAnsi(BLOCK_COLOR, ")");
                }
                this.printAnsi(BLOCK_COLOR, ": " + bb.getLabel() + "\n");
                List<Instr> instrList2 = bb.getInstrs();
                for (int i5 = 0; i5 < instrList2.size(); ++i5) {
                    this.formatInstr(instrList2.get(i5), varFormat, varSpaces, ipcFormat, instrList2.get(i5), i5);
                }
                ++var17_32;
            }
        }
        if (recurse && !scope.getClosures().isEmpty()) {
            this.println(new Object[0]);
            for (IRClosure closure : scope.getClosures()) {
                if (closure == scope) continue;
                this.visit(closure, full, true);
            }
        }
    }

    public void formatInstr(Instr instr1, String varFormat, String varSpaces, String ipcFormat, Instr instr2, int i2) {
        Instr instr = instr2;
        this.printf(ipcFormat, i2);
        if (instr instanceof ResultInstr) {
            Variable result2 = ((ResultInstr)((Object)instr)).getResult();
            String sigilName = result2 instanceof LocalVariable ? "*" + result2.getName() : result2.getName();
            this.printf(varFormat, sigilName);
        } else {
            this.print(varSpaces);
        }
        this.visit(instr1);
        this.println(new Object[0]);
    }

    public int getLongestVariable(int longest, ResultInstr i2) {
        Variable result2 = i2.getResult();
        longest = Math.max(longest, result2.getName().length() + (result2 instanceof LocalVariable ? 1 : 0));
        return longest;
    }

    @Override
    public void visit(Instr instr) {
        this.printAnsi(INSTR_COLOR, instr.getOperation().toString().toLowerCase());
        boolean comma = false;
        for (Operand o : instr.getOperands()) {
            if (!comma) {
                this.printAnsi(INSTR_COLOR, "(");
            }
            if (comma) {
                this.print(", ");
            }
            comma = true;
            this.visit(o);
        }
        for (Field f : instr.dumpableFields()) {
            if (!comma) {
                this.printAnsi(INSTR_COLOR, "(");
            }
            if (comma) {
                this.print(", ");
            }
            comma = true;
            f.setAccessible(true);
            this.printAnsi(FIELD_COLOR, f.getName() + ": ");
            this.print(IRDumper.get(f, instr));
        }
        if (comma) {
            this.printAnsi(INSTR_COLOR, ")");
        }
    }

    @Override
    public void visit(Operand operand) {
        if (operand instanceof LocalVariable) {
            this.printAnsiOp(VARIABLE_COLOR, "*", operand);
        } else if (operand instanceof TemporaryVariable) {
            this.printAnsiOp(VARIABLE_COLOR, operand);
        } else {
            this.printAnsi(OPERAND_COLOR, operand.getOperandType().shortName() + "<");
            operand.visit(this);
            this.printAnsi(OPERAND_COLOR, ">");
        }
    }

    @Override
    public void Array(Array array) {
        boolean[] comma = new boolean[]{false};
        for (Operand o : Arrays.asList(array.getElts())) {
            if (comma[0]) {
                this.print(", ");
            }
            comma[0] = true;
            this.visit(o);
        }
    }

    @Override
    public void AsString(AsString asstring) {
        this.visit(asstring.getSource());
    }

    @Override
    public void Bignum(Bignum bignum) {
        this.print(bignum.value);
    }

    @Override
    public void Boolean(Boolean bool2) {
        this.print(bool2.isTrue() ? "t" : "f");
    }

    @Override
    public void UnboxedBoolean(UnboxedBoolean bool2) {
        this.print(bool2.isTrue() ? "t" : "f");
    }

    @Override
    public void ClosureLocalVariable(ClosureLocalVariable closurelocalvariable) {
        this.LocalVariable(closurelocalvariable);
    }

    @Override
    public void Complex(Complex complex) {
        this.visit(complex.getNumber());
    }

    @Override
    public void CurrentScope(CurrentScope currentscope) {
        this.print(currentscope.getScopeNestingDepth());
    }

    @Override
    public void DynamicSymbol(DynamicSymbol dynamicsymbol) {
        this.print(dynamicsymbol.getSymbolName());
    }

    @Override
    public void Filename(Filename filename2) {
    }

    @Override
    public void Fixnum(Fixnum fixnum) {
        this.print(fixnum.getValue());
    }

    @Override
    public void FrozenString(FrozenString frozen) {
        this.print(frozen.getByteList());
    }

    @Override
    public void UnboxedFixnum(UnboxedFixnum fixnum) {
        this.print(fixnum.getValue());
    }

    @Override
    public void Float(Float flote) {
        this.print(flote.getValue());
    }

    @Override
    public void UnboxedFloat(UnboxedFloat flote) {
        this.print(flote.getValue());
    }

    @Override
    public void GlobalVariable(GlobalVariable globalvariable) {
        this.print(globalvariable.getName());
    }

    @Override
    public void Hash(Hash hash2) {
        List<KeyValuePair<Operand, Operand>> pairs = hash2.getPairs();
        boolean comma = false;
        for (KeyValuePair<Operand, Operand> pair : pairs) {
            if (comma) {
                this.print(Character.valueOf(','));
            }
            comma = true;
            this.visit(pair.getKey());
            this.print("=>");
            this.visit(pair.getValue());
        }
    }

    @Override
    public void IRException(IRException irexception) {
        this.print((Object)irexception.getType());
    }

    @Override
    public void Label(Label label2) {
        this.print(label2.toString());
    }

    @Override
    public void LocalVariable(LocalVariable localvariable) {
        this.print(localvariable.getName());
    }

    @Override
    public void Nil(Nil nil) {
    }

    @Override
    public void NthRef(NthRef nthref) {
        this.print(nthref.getName());
    }

    @Override
    public void NullBlock(NullBlock nullblock) {
    }

    @Override
    public void ObjectClass(ObjectClass objectclass) {
    }

    @Override
    public void Rational(Rational rational) {
        this.print(rational.getNumerator() + "/" + rational.getDenominator());
    }

    @Override
    public void Regexp(Regexp regexp2) {
        this.print(regexp2.getSource());
    }

    @Override
    public void ScopeModule(ScopeModule scopemodule) {
        this.print(scopemodule.getScopeModuleDepth());
    }

    @Override
    public void Self(Self self2) {
        this.print("%self");
    }

    @Override
    public void Splat(Splat splat) {
        this.visit(splat.getArray());
    }

    @Override
    public void StandardError(StandardError standarderror) {
    }

    @Override
    public void StringLiteral(StringLiteral stringliteral) {
        this.print(stringliteral.getByteList());
    }

    @Override
    public void SValue(SValue svalue) {
        this.visit(svalue.getArray());
    }

    @Override
    public void Symbol(Symbol symbol) {
        this.print(symbol.getBytes());
    }

    @Override
    public void SymbolProc(SymbolProc symbolproc) {
        this.print(symbolproc.getName());
    }

    @Override
    public void TemporaryVariable(TemporaryVariable temporaryvariable) {
        this.print(temporaryvariable.getName());
    }

    @Override
    public void TemporaryLocalVariable(TemporaryLocalVariable temporarylocalvariable) {
        this.TemporaryVariable(temporarylocalvariable);
    }

    @Override
    public void TemporaryFloatVariable(TemporaryFloatVariable temporaryfloatvariable) {
        this.TemporaryVariable(temporaryfloatvariable);
    }

    @Override
    public void TemporaryFixnumVariable(TemporaryFixnumVariable temporaryfixnumvariable) {
        this.TemporaryVariable(temporaryfixnumvariable);
    }

    @Override
    public void TemporaryBooleanVariable(TemporaryBooleanVariable temporarybooleanvariable) {
        this.TemporaryVariable(temporarybooleanvariable);
    }

    @Override
    public void UndefinedValue(UndefinedValue undefinedvalue) {
    }

    @Override
    public void UnexecutableNil(UnexecutableNil unexecutablenil) {
    }

    @Override
    public void WrappedIRClosure(WrappedIRClosure wrappedirclosure) {
        this.print(wrappedirclosure.getClosure().getName());
    }

    private static Object get(Field f, Instr i2) {
        try {
            return f.get(i2);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static final String spaces(int size2) {
        return SPACES.substring(0, size2);
    }

    private String ansiStr(String c, String mid) {
        return this.color ? c + mid + CLEAR_COLOR : mid;
    }

    private void printAnsi(String c, String mid) {
        this.print(this.ansiStr(c, mid));
    }

    private void printAnsiOp(String c, Operand op) {
        if (this.color) {
            this.print(c);
        }
        op.visit(this);
        if (this.color) {
            this.print(CLEAR_COLOR);
        }
    }

    private void printAnsiOp(String c, String pre, Operand op) {
        if (this.color) {
            this.print(c);
        }
        this.print(pre);
        op.visit(this);
        if (this.color) {
            this.print(CLEAR_COLOR);
        }
    }

    private void print(Object obj) {
        if (obj.getClass().isArray()) {
            if (obj.getClass().getComponentType().isPrimitive()) {
                switch (obj.getClass().getName().charAt(0)) {
                    case 'B': {
                        this.stream.print(Arrays.toString((boolean[])obj));
                        break;
                    }
                    case 'S': {
                        this.stream.print(Arrays.toString((short[])obj));
                        break;
                    }
                    case 'C': {
                        this.stream.print(Arrays.toString((char[])obj));
                        break;
                    }
                    case 'I': {
                        this.stream.print(Arrays.toString((int[])obj));
                        break;
                    }
                    case 'J': {
                        this.stream.print(Arrays.toString((long[])obj));
                        break;
                    }
                    case 'F': {
                        this.stream.print(Arrays.toString((float[])obj));
                        break;
                    }
                    case 'D': {
                        this.stream.print(Arrays.toString((double[])obj));
                        break;
                    }
                    case 'Z': {
                        this.stream.print(Arrays.toString((boolean[])obj));
                    }
                }
            } else {
                this.stream.print(Arrays.toString((Object[])obj));
            }
        } else {
            this.stream.print(obj);
        }
    }

    private void println(Object ... objs) {
        for (Object obj : objs) {
            this.print(obj);
        }
        this.stream.println();
    }

    private void printf(String format, Object ... objs) {
        this.stream.printf(format, objs);
    }
}

