/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.commands.debug;

import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.command.Previewable;
import org.scijava.log.LogService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>Sandbox>Parameter Assignment Order", headless=true, initializer="initParams", attrs={@Attr(name="no-legacy")})
public class ParamAssignOrder
extends ContextCommand
implements Previewable {
    @Parameter
    private LogService log;
    @Parameter(initializer="initInput1")
    private String input1 = "input1: initial value";
    @Parameter(initializer="initInput2")
    private String input2 = "input2: initial value";

    public ParamAssignOrder() {
        this.displayValues("constructor start");
        this.input1 = "input1: constructor";
        this.input2 = "input2: constructor";
        this.displayValues("constructor end");
    }

    public void run() {
        this.input1 = "input1: run called";
        this.input2 = "input2: run called";
        this.displayValues("run");
    }

    public void preview() {
        this.displayValues("preview");
    }

    public void cancel() {
        this.input1 = "input1: cancel called";
        this.input2 = "input2: cancel called";
        this.displayValues("cancel");
    }

    protected void initParams() {
        this.input1 = "input1: initParams called";
        this.input2 = "input2: initParams called";
        this.displayValues("initParams");
    }

    protected void initInput1() {
        this.input1 = "input1: initInput1 called";
        this.displayValues("initInput1");
    }

    protected void initInput2() {
        this.input2 = "input2: initInput2 called";
        this.displayValues("initInput2");
    }

    private void displayValues(String header) {
        if (this.log == null) {
            System.err.println();
            System.err.println("-- " + header + " --");
            System.err.println("input1 = " + this.input1);
            System.err.println("input2 = " + this.input2);
        } else {
            this.log.info((Object)"");
            this.log.info((Object)("-- " + header + " --"));
            this.log.info((Object)("input1 = " + this.input1));
            this.log.info((Object)("input2 = " + this.input2));
        }
    }
}

