/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary;

import java.util.Arrays;
import java.util.BitSet;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.ops.data.CooccurrenceMatrix;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.type.numeric.RealType;

@Deprecated
public class MakeCooccurrenceMatrix<T extends RealType<T>>
implements UnaryOperation<IterableInterval<T>, CooccurrenceMatrix> {
    private static final double EPSILON = (double)1.0E-8f;
    private final CooccurrenceMatrix.MatrixOrientation m_orientation;
    private final int m_nrGrayLevels;
    private final int m_distance;
    private double m_min;
    private double m_max;
    private int[][] m_pixels;
    private final BitSet m_enabledFeatures;
    private final int m_dimX;
    private final int m_dimY;

    public MakeCooccurrenceMatrix(int dimX, int dimY, int distance, int nrGrayLevels, CooccurrenceMatrix.MatrixOrientation orientation, BitSet enabledFeatures) {
        this.m_distance = distance;
        this.m_nrGrayLevels = nrGrayLevels;
        this.m_orientation = orientation;
        this.m_dimX = dimX;
        this.m_dimY = dimY;
        this.m_enabledFeatures = enabledFeatures;
    }

    @Override
    public CooccurrenceMatrix compute(IterableInterval<T> input, CooccurrenceMatrix output) {
        if (input == null) {
            throw new IllegalArgumentException("IterableInterval must not be null.");
        }
        if (output == null) {
            throw new IllegalArgumentException("CooccurrenceMatrix must not be null.");
        }
        Cursor cursor = input.cursor();
        this.m_min = ((RealType)cursor.get()).getMaxValue();
        this.m_max = ((RealType)cursor.get()).getMinValue();
        while (cursor.hasNext()) {
            cursor.fwd();
            this.m_max = Math.max(this.m_max, ((RealType)cursor.get()).getRealDouble());
            this.m_min = Math.min(this.m_min, ((RealType)cursor.get()).getRealDouble());
        }
        cursor = input.localizingCursor();
        this.m_pixels = new int[(int)input.dimension(this.m_dimY)][(int)input.dimension(this.m_dimX)];
        for (int i = 0; i < this.m_pixels.length; ++i) {
            Arrays.fill(this.m_pixels[i], Integer.MAX_VALUE);
        }
        while (cursor.hasNext()) {
            cursor.fwd();
            this.m_pixels[cursor.getIntPosition((int)this.m_dimY) - (int)input.min((int)this.m_dimY)][cursor.getIntPosition((int)this.m_dimX) - (int)input.min((int)this.m_dimX)] = (int)((((RealType)cursor.get()).getRealDouble() - this.m_min) / (this.m_max - this.m_min) * (double)(this.m_nrGrayLevels - 1));
        }
        output.clear();
        this.computeMatrices(output);
        this.computeFeatures(output);
        return output;
    }

    private void computeFeatures(CooccurrenceMatrix matrix) {
        int i;
        int j;
        int i2;
        double[] h = new double[HaralickFeature.values().length];
        double[] px = new double[this.m_nrGrayLevels];
        if (this.m_enabledFeatures.get(2) || this.m_enabledFeatures.get(3) || this.m_enabledFeatures.get(11) || this.m_enabledFeatures.get(12)) {
            for (int i3 = 0; i3 < this.m_nrGrayLevels; ++i3) {
                for (int j2 = 0; j2 < this.m_nrGrayLevels; ++j2) {
                    int n = i3;
                    px[n] = px[n] + matrix.getValueAt(i3, j2);
                }
            }
        }
        double meanx = 0.0;
        double stdx = 0.0;
        if (this.m_enabledFeatures.get(2) || this.m_enabledFeatures.get(3)) {
            int i4;
            for (i4 = 0; i4 < px.length; ++i4) {
                meanx += (double)i4 * px[i4];
            }
            for (i4 = 0; i4 < px.length; ++i4) {
                stdx += ((double)i4 - meanx) * ((double)i4 - meanx) * px[i4];
            }
            stdx = Math.sqrt(stdx);
        }
        double[] py = px;
        double meany = meanx;
        double stdy = stdx;
        double[] pxplusy = new double[2 * this.m_nrGrayLevels + 1];
        if (this.m_enabledFeatures.get(5) || this.m_enabledFeatures.get(6) || this.m_enabledFeatures.get(7)) {
            for (int k = 2; k <= 2 * this.m_nrGrayLevels; ++k) {
                for (int i5 = 0; i5 < this.m_nrGrayLevels; ++i5) {
                    for (int j3 = 0; j3 < this.m_nrGrayLevels; ++j3) {
                        if (i5 + 1 + (j3 + 1) != k) continue;
                        int n = k;
                        pxplusy[n] = pxplusy[n] + matrix.getValueAt(i5, j3);
                    }
                }
            }
        }
        double[] pxminusy = new double[this.m_nrGrayLevels];
        if (this.m_enabledFeatures.get(1) || this.m_enabledFeatures.get(9) || this.m_enabledFeatures.get(10)) {
            for (int k = 0; k < this.m_nrGrayLevels; ++k) {
                for (int i6 = 0; i6 < this.m_nrGrayLevels; ++i6) {
                    for (int j4 = 0; j4 < this.m_nrGrayLevels; ++j4) {
                        if (Math.abs(i6 - j4) != k) continue;
                        int n = k;
                        pxminusy[n] = pxminusy[n] + matrix.getValueAt(i6, j4);
                    }
                }
            }
        }
        double hx = 0.0;
        double hy = 0.0;
        double hxy1 = 0.0;
        double hxy2 = 0.0;
        if (this.m_enabledFeatures.get(11) || this.m_enabledFeatures.get(12)) {
            this.m_enabledFeatures.set(8);
            for (i2 = 0; i2 < px.length; ++i2) {
                hx += px[i2] * Math.log(px[i2] + (double)1.0E-8f);
            }
            hx = -hx;
            for (int j5 = 0; j5 < py.length; ++j5) {
                hy += py[j5] * Math.log(py[j5] + (double)1.0E-8f);
            }
            hy = -hy;
            for (i2 = 0; i2 < this.m_nrGrayLevels; ++i2) {
                for (j = 0; j < this.m_nrGrayLevels; ++j) {
                    hxy1 += matrix.getValueAt(i2, j) * Math.log(px[i2] * py[j] + (double)1.0E-8f);
                    hxy2 += px[i2] * py[j] * Math.log(px[i2] * py[j] + (double)1.0E-8f);
                }
            }
            hxy1 = -hxy1;
            hxy2 = -hxy2;
        }
        h[0] = 0.0;
        h[2] = 0.0;
        h[3] = 0.0;
        h[4] = 0.0;
        h[8] = 0.0;
        if (this.m_enabledFeatures.get(0) || this.m_enabledFeatures.get(2) || this.m_enabledFeatures.get(3) || this.m_enabledFeatures.get(4) || this.m_enabledFeatures.get(8)) {
            for (i2 = 0; i2 < this.m_nrGrayLevels; ++i2) {
                for (j = 0; j < this.m_nrGrayLevels; ++j) {
                    if (this.m_enabledFeatures.get(0)) {
                        h[0] = h[0] + matrix.getValueAt(i2, j) * matrix.getValueAt(i2, j);
                    }
                    if (this.m_enabledFeatures.get(2)) {
                        h[2] = h[2] + ((double)i2 - meanx) * ((double)j - meany) * matrix.getValueAt(i2, j) / (stdx * stdy);
                    }
                    if (this.m_enabledFeatures.get(4)) {
                        h[4] = h[4] + 1.0 / (double)(1 + (i2 - j) * (i2 - j)) * matrix.getValueAt(i2, j);
                    }
                    if (!this.m_enabledFeatures.get(8)) continue;
                    h[8] = h[8] + matrix.getValueAt(i2, j) * Math.log(matrix.getValueAt(i2, j) + (double)1.0E-8f);
                }
            }
        }
        h[8] = -h[8];
        if (Double.isNaN(h[2])) {
            h[2] = 0.0;
        }
        if (this.m_enabledFeatures.get(3)) {
            h[3] = stdx * stdx;
        }
        h[1] = 0.0;
        h[10] = 0.0;
        if (this.m_enabledFeatures.get(1) || this.m_enabledFeatures.get(10)) {
            for (int k = 0; k <= this.m_nrGrayLevels - 1; ++k) {
                if (this.m_enabledFeatures.get(1)) {
                    h[1] = h[1] + (double)(k * k) * pxminusy[k];
                }
                if (!this.m_enabledFeatures.get(10)) continue;
                h[10] = h[10] + pxminusy[k] * Math.log(pxminusy[k] + (double)1.0E-8f);
            }
            h[10] = -h[10];
        }
        h[5] = 0.0;
        if (this.m_enabledFeatures.get(6) && this.m_enabledFeatures.get(5)) {
            for (i2 = 2; i2 <= 2 * this.m_nrGrayLevels; ++i2) {
                h[5] = h[5] + (double)i2 * pxplusy[i2];
            }
        }
        h[6] = 0.0;
        h[7] = 0.0;
        if (this.m_enabledFeatures.get(5) || this.m_enabledFeatures.get(6) || this.m_enabledFeatures.get(7)) {
            for (i2 = 2; i2 <= 2 * this.m_nrGrayLevels; ++i2) {
                if (this.m_enabledFeatures.get(5) && !this.m_enabledFeatures.get(6)) {
                    h[5] = h[5] + (double)i2 * pxplusy[i2];
                }
                if (this.m_enabledFeatures.get(6)) {
                    h[6] = h[6] + ((double)i2 - h[5]) * ((double)i2 - h[5]) * pxplusy[i2];
                }
                if (!this.m_enabledFeatures.get(7)) continue;
                h[7] = h[7] + pxplusy[i2] * Math.log(pxplusy[i2] + (double)1.0E-8f);
            }
            if (this.m_enabledFeatures.get(7)) {
                h[7] = -h[7];
            }
        }
        h[9] = 0.0;
        if (this.m_enabledFeatures.get(9)) {
            int k;
            double sum = 0.0;
            for (k = 0; k < pxminusy.length; ++k) {
                sum += (double)k * pxminusy[k];
            }
            for (k = 0; k < pxminusy.length; ++k) {
                h[9] = h[9] + ((double)k - sum) * pxminusy[k];
            }
        }
        h[11] = 0.0;
        if (this.m_enabledFeatures.get(11)) {
            h[11] = (h[8] - hxy1) / Math.max(hx, hy);
        }
        h[12] = 0.0;
        if (this.m_enabledFeatures.get(12)) {
            h[12] = Math.sqrt(1.0 - Math.exp(-2.0 * (hxy2 - h[8])));
        }
        h[13] = 0.0;
        if (this.m_enabledFeatures.get(13)) {
            for (int j6 = 0; j6 < this.m_nrGrayLevels; ++j6) {
                h[13] = h[13] + Math.pow((double)(2 * j6) - 2.0 * stdx, 3.0) * matrix.getValueAt(j6, j6);
                for (i = j6 + 1; i < this.m_nrGrayLevels; ++i) {
                    h[13] = h[13] + 2.0 * Math.pow((double)(i + j6) - 2.0 * stdx, 3.0) * matrix.getValueAt(i, j6);
                }
            }
        }
        h[14] = 0.0;
        if (this.m_enabledFeatures.get(14)) {
            for (int j7 = 0; j7 < this.m_nrGrayLevels; ++j7) {
                h[14] = h[14] + Math.pow((double)(2 * j7) - 2.0 * stdx, 4.0) * matrix.getValueAt(j7, j7);
                for (i = j7 + 1; i < this.m_nrGrayLevels; ++i) {
                    h[14] = h[14] + 2.0 * Math.pow((double)(i + j7) - 2.0 * stdx, 4.0) * matrix.getValueAt(i, j7);
                }
            }
        }
        matrix.setFeatures(h);
    }

    private void computeMatrices(CooccurrenceMatrix matrix) {
        int nrPairs = 0;
        for (int y = 0; y < this.m_pixels.length; ++y) {
            for (int x = 0; x < this.m_pixels[y].length; ++x) {
                if (this.m_pixels[y][x] == Integer.MAX_VALUE) continue;
                int sx = x + this.m_orientation.dx * this.m_distance;
                int sy = y + this.m_orientation.dy * this.m_distance;
                int tx = x - this.m_orientation.dx * this.m_distance;
                int ty = y - this.m_orientation.dy * this.m_distance;
                if (sx >= 0 && sy >= 0 && sy < this.m_pixels.length && sx < this.m_pixels[sy].length && this.m_pixels[sy][sx] != Integer.MAX_VALUE) {
                    matrix.incValueAt(this.m_pixels[y][x], this.m_pixels[sy][sx]);
                    ++nrPairs;
                }
                if (tx < 0 || ty < 0 || ty >= this.m_pixels.length || tx >= this.m_pixels[ty].length || this.m_pixels[ty][tx] == Integer.MAX_VALUE) continue;
                matrix.incValueAt(this.m_pixels[y][x], this.m_pixels[ty][tx]);
                ++nrPairs;
            }
        }
        if (nrPairs > 0) {
            matrix.divideBy(nrPairs);
        }
    }

    @Override
    public UnaryOperation<IterableInterval<T>, CooccurrenceMatrix> copy() {
        return new MakeCooccurrenceMatrix<T>(this.m_dimX, this.m_dimY, this.m_distance, this.m_nrGrayLevels, this.m_orientation, this.m_enabledFeatures);
    }

    public static enum HaralickFeature {
        ASM,
        Contrast,
        Correlation,
        Variance,
        IFDM,
        SumAverage,
        SumVariance,
        SumEntropy,
        Entropy,
        DifferenceVariance,
        DifferenceEntropy,
        ICM1,
        ICM2,
        ClusterShade,
        ClusterProminence;


        public static int getIndex(HaralickFeature feature) {
            for (int i = 0; i < HaralickFeature.values().length; ++i) {
                if (HaralickFeature.values()[i] != feature) continue;
                return i;
            }
            return -1;
        }
    }
}

