/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.pointset;

import net.imglib2.AbstractCursor;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.ops.pointset.AbstractPointSet;
import net.imglib2.ops.pointset.PointSetIterator;

@Deprecated
public class IterableIntervalPointSet
extends AbstractPointSet {
    private final IterableInterval<?> interval;
    private final long[] boundMin;
    private final long[] boundMax;
    private final long size;

    public IterableIntervalPointSet(IterableInterval<?> interval) {
        this.interval = interval;
        int numDims = interval.numDimensions();
        this.boundMin = new long[numDims];
        this.boundMax = new long[numDims];
        interval.min(this.boundMin);
        interval.max(this.boundMax);
        long sum = 1L;
        for (int i = 0; i < numDims; ++i) {
            sum *= 1L + this.boundMax[i] - this.boundMin[i];
        }
        this.size = sum;
    }

    @Override
    public long[] getOrigin() {
        return this.boundMin;
    }

    @Override
    public void translate(long[] delta) {
        throw new UnsupportedOperationException("IterableIntervals cannot be moved through space");
    }

    @Override
    public PointSetIterator iterator() {
        return new IterableIntervalPointSetIterator();
    }

    @Override
    public int numDimensions() {
        return this.interval.numDimensions();
    }

    @Override
    protected long[] findBoundMin() {
        return this.boundMin;
    }

    @Override
    protected long[] findBoundMax() {
        return this.boundMax;
    }

    @Override
    public boolean includes(long[] point) {
        for (int i = 0; i < point.length; ++i) {
            long val = point[i];
            if (val >= this.boundMin[i] && val <= this.boundMax[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public IterableIntervalPointSet copy() {
        return new IterableIntervalPointSet(this.interval);
    }

    private class IterableIntervalPointSetIterator
    extends AbstractCursor<long[]>
    implements PointSetIterator {
        private final Cursor<?> cursor;
        private final long[] pos;

        public IterableIntervalPointSetIterator() {
            super(IterableIntervalPointSet.this.interval.numDimensions());
            this.cursor = IterableIntervalPointSet.this.interval.localizingCursor();
            this.pos = new long[this.n];
        }

        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        public void reset() {
            this.cursor.reset();
        }

        public long[] get() {
            return this.pos;
        }

        public void fwd() {
            this.cursor.fwd();
            this.cursor.localize(this.pos);
        }

        public void localize(long[] position) {
            for (int i = 0; i < this.n; ++i) {
                position[i] = this.pos[i];
            }
        }

        public long getLongPosition(int d) {
            return this.pos[d];
        }

        public AbstractCursor<long[]> copy() {
            return new IterableIntervalPointSetIterator();
        }

        public AbstractCursor<long[]> copyCursor() {
            return this.copy();
        }
    }
}

