/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.pointset;

import net.imglib2.AbstractCursor;
import net.imglib2.ops.pointset.AbstractPointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetIterator;

@Deprecated
public class PointSetUnion
extends AbstractPointSet {
    private final PointSet a;
    private final PointSet b;
    private final long[] min;
    private final long[] max;
    private final int numD;

    public PointSetUnion(PointSet a, PointSet b) {
        this.numD = a.numDimensions();
        if (this.numD != b.numDimensions()) {
            throw new IllegalArgumentException();
        }
        this.a = a;
        this.b = b;
        this.min = new long[this.numD];
        this.max = new long[this.numD];
    }

    @Override
    public long[] getOrigin() {
        return this.a.getOrigin();
    }

    @Override
    public void translate(long[] deltas) {
        this.a.translate(deltas);
        this.b.translate(deltas);
        this.invalidateBounds();
    }

    @Override
    public PointSetIterator iterator() {
        return new PointSetUnionIterator();
    }

    @Override
    public int numDimensions() {
        return this.numD;
    }

    @Override
    public boolean includes(long[] point) {
        return this.a.includes(point) || this.b.includes(point);
    }

    @Override
    protected long[] findBoundMin() {
        for (int i = 0; i < this.numD; ++i) {
            this.min[i] = Math.min(this.a.min(i), this.b.min(i));
        }
        return this.min;
    }

    @Override
    protected long[] findBoundMax() {
        for (int i = 0; i < this.numD; ++i) {
            this.max[i] = Math.max(this.a.max(i), this.b.max(i));
        }
        return this.max;
    }

    @Override
    public long size() {
        long numElements = 0L;
        PointSetIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++numElements;
        }
        return numElements;
    }

    @Override
    public PointSetUnion copy() {
        return new PointSetUnion(this.a.copy(), this.b.copy());
    }

    private class PointSetUnionIterator
    extends AbstractCursor<long[]>
    implements PointSetIterator {
        private final PointSetIterator aIter;
        private final PointSetIterator bIter;
        private long[] curr;
        private long[] nextCache;

        public PointSetUnionIterator() {
            super(PointSetUnion.this.numD);
            this.aIter = PointSetUnion.this.a.iterator();
            this.bIter = PointSetUnion.this.b.iterator();
            this.reset();
        }

        public boolean hasNext() {
            if (this.nextCache != null) {
                return true;
            }
            return this.positionToNext();
        }

        public void reset() {
            this.aIter.reset();
            this.bIter.reset();
            this.curr = null;
            this.nextCache = null;
        }

        public long[] get() {
            return this.curr;
        }

        public void fwd() {
            if (this.nextCache != null || this.positionToNext()) {
                if (this.curr == null) {
                    this.curr = new long[this.n];
                }
                for (int i = 0; i < this.n; ++i) {
                    this.curr[i] = this.nextCache[i];
                }
                this.nextCache = null;
                return;
            }
            throw new IllegalArgumentException("fwd() cannot go beyond end");
        }

        public void localize(long[] position) {
            for (int i = 0; i < this.n; ++i) {
                position[i] = this.curr[i];
            }
        }

        public long getLongPosition(int d) {
            return this.curr[d];
        }

        public AbstractCursor<long[]> copy() {
            return new PointSetUnionIterator();
        }

        public AbstractCursor<long[]> copyCursor() {
            return this.copy();
        }

        private boolean positionToNext() {
            this.nextCache = null;
            if (this.aIter.hasNext()) {
                this.nextCache = (long[])this.aIter.next();
                return true;
            }
            while (this.bIter.hasNext()) {
                long[] pos = (long[])this.bIter.next();
                if (PointSetUnion.this.a.includes(pos)) continue;
                this.nextCache = pos;
                return true;
            }
            return false;
        }
    }
}

