/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.vecmath.Point3d;

public class CompressedGeometryHeader {
    public static final int POINT_BUFFER = 0;
    public static final int LINE_BUFFER = 1;
    public static final int TRIANGLE_BUFFER = 2;
    public static final int NORMAL_IN_BUFFER = 1;
    public static final int COLOR_IN_BUFFER = 2;
    public static final int ALPHA_IN_BUFFER = 4;
    public int majorVersionNumber;
    public int minorVersionNumber;
    public int minorMinorVersionNumber;
    public int bufferType;
    public int bufferDataPresent;
    public int size;
    public int start;
    public Point3d lowerBound = null;
    public Point3d upperBound = null;

    void copy(CompressedGeometryHeader hdr) {
        hdr.majorVersionNumber = this.majorVersionNumber;
        hdr.minorVersionNumber = this.minorVersionNumber;
        hdr.minorMinorVersionNumber = this.minorMinorVersionNumber;
        hdr.bufferType = this.bufferType;
        hdr.bufferDataPresent = this.bufferDataPresent;
        hdr.size = this.size;
        hdr.start = this.start;
        hdr.lowerBound = this.lowerBound;
        hdr.upperBound = this.upperBound;
    }

    public String toString() {
        String type = "UNKNOWN";
        switch (this.bufferType) {
            case 0: {
                type = "POINT_BUFFER";
                break;
            }
            case 1: {
                type = "LINE_BUFFER";
                break;
            }
            case 2: {
                type = "TRIANGLE_BUFFER";
            }
        }
        String data = "";
        if ((this.bufferDataPresent & 1) != 0) {
            data = data + "NORMALS ";
        }
        if ((this.bufferDataPresent & 2) != 0) {
            data = data + "COLORS ";
        }
        if ((this.bufferDataPresent & 4) != 0) {
            data = data + "ALPHA ";
        }
        String lbound = "null";
        if (this.lowerBound != null) {
            lbound = this.lowerBound.toString();
        }
        String ubound = "null";
        if (this.upperBound != null) {
            ubound = this.upperBound.toString();
        }
        return "majorVersionNumber: " + this.majorVersionNumber + "  " + "minorVersionNumber: " + this.minorVersionNumber + "  " + "minorMinorVersionNumber: " + this.minorMinorVersionNumber + "\n" + "bufferType: " + type + "  " + "bufferDataPresent: " + data + "\n" + "size: " + this.size + "  " + "start: " + this.start + "\n" + "lower bound: " + lbound + "\n" + "upper bound: " + ubound + "  ";
    }
}

