/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.scheme;

import java.util.List;
import org.apposed.appose.Scheme;
import org.apposed.appose.util.Plugins;

public final class Schemes {
    private static final List<Scheme> ALL = Plugins.discover(Scheme.class, (a, b) -> Double.compare(b.priority(), a.priority()));

    private Schemes() {
    }

    public static Scheme fromContent(String content) {
        Scheme result = Plugins.find(ALL, scheme -> scheme.supportsContent(content));
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Cannot infer scheme from content. Please specify explicitly with .scheme()");
    }

    public static Scheme fromName(String name) {
        Scheme result = Plugins.find(ALL, scheme -> scheme.name().equals(name));
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Unknown scheme: " + name);
    }

    public static Scheme fromFilename(String filename) {
        Scheme result = Plugins.find(ALL, scheme -> scheme.supportsFilename(filename));
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Cannot infer scheme from filename: " + filename);
    }
}

