/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.axis;

import java.util.HashMap;
import net.imagej.axis.AxisType;
import net.imagej.axis.DefaultAxisType;

public final class Axes {
    public static final String UNKNOWN_LABEL = "Unknown";
    private static HashMap<String, AxisType> axes = new HashMap();
    public static final AxisType X = Axes.get("X", true);
    public static final AxisType Y = Axes.get("Y", true);
    public static final AxisType Z = Axes.get("Z", true);
    public static final AxisType TIME = Axes.get("Time");
    public static final AxisType CHANNEL = Axes.get("Channel");

    private Axes() {
    }

    public static AxisType get(String label) {
        return Axes.get(label, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AxisType get(String label, boolean spatial) {
        if (UNKNOWN_LABEL.equals(label)) {
            return Axes.unknown();
        }
        AxisType axis = axes.get(label);
        if (axis == null) {
            HashMap<String, AxisType> hashMap = axes;
            synchronized (hashMap) {
                axis = axes.get(label);
                if (axis == null) {
                    axis = new DefaultAxisType(label, spatial);
                    axes.put(label, axis);
                }
            }
        }
        return axis;
    }

    public static AxisType[] knownTypes() {
        return axes.values().toArray(new AxisType[0]);
    }

    public static AxisType unknown() {
        return new DefaultAxisType(UNKNOWN_LABEL);
    }
}

