/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import java.util.List;
import net.imagej.Data;
import net.imagej.Dataset;
import net.imagej.ImageJService;
import net.imagej.Position;
import net.imagej.display.DataView;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.event.EventService;
import org.scijava.plugin.PluginService;

public interface ImageDisplayService
extends ImageJService {
    public EventService getEventService();

    public PluginService getPluginService();

    public DisplayService getDisplayService();

    public DataView createDataView(Data var1);

    default public DatasetView createDatasetView(Dataset dataset) {
        DataView dataView = this.createDataView(dataset);
        if (!(dataView instanceof DatasetView)) {
            throw new IllegalStateException("Wrapped DataView is a " + dataView.getClass().getName() + ", not a DatasetView. There might be a rogue DataView plugin wrapping Datasets inappropriately.");
        }
        return (DatasetView)dataView;
    }

    default public ImageDisplay createImageDisplay(Data data) {
        return this.createImageDisplay(null, data);
    }

    default public ImageDisplay createImageDisplay(String name, Data data) {
        Display display = this.getDisplayService().createDisplay(name, (Object)data);
        if (!(display instanceof ImageDisplay)) {
            throw new IllegalStateException("Created Display is a " + display.getClass().getName() + ", not an ImageDisplay. There might be a rogue Display plugin wrapping DataViews inappropriately.");
        }
        return (ImageDisplay)display;
    }

    default public ImageDisplay createImageDisplay(DataView dataView) {
        return this.createImageDisplay(null, dataView);
    }

    default public ImageDisplay createImageDisplay(String name, DataView dataView) {
        Display display = this.getDisplayService().createDisplay(name, (Object)dataView);
        if (!(display instanceof ImageDisplay)) {
            throw new IllegalStateException("Created Display is a " + display.getClass().getName() + ", not an ImageDisplay. There might be a rogue Display plugin wrapping DataViews inappropriately.");
        }
        return (ImageDisplay)display;
    }

    public List<? extends DataView> getDataViews();

    public ImageDisplay getActiveImageDisplay();

    default public Dataset getActiveDataset() {
        return this.getActiveDataset(this.getActiveImageDisplay());
    }

    default public DatasetView getActiveDatasetView() {
        return this.getActiveDatasetView(this.getActiveImageDisplay());
    }

    default public Position getActivePosition() {
        return this.getActivePosition(this.getActiveImageDisplay());
    }

    default public Dataset getActiveDataset(ImageDisplay display) {
        DatasetView activeDatasetView = this.getActiveDatasetView(display);
        return activeDatasetView == null ? null : activeDatasetView.getData();
    }

    default public DatasetView getActiveDatasetView(ImageDisplay display) {
        if (display == null) {
            return null;
        }
        DataView activeView = display.getActiveView();
        if (activeView instanceof DatasetView) {
            return (DatasetView)activeView;
        }
        return null;
    }

    public List<ImageDisplay> getImageDisplays();

    default public Position getActivePosition(ImageDisplay display) {
        if (display == null) {
            return null;
        }
        DatasetView activeDatasetView = this.getActiveDatasetView(display);
        if (activeDatasetView == null) {
            return null;
        }
        return activeDatasetView.getPlanePosition();
    }
}

